/* Filename: IReference.java
 * Creator: M.A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: Aug 25, 2009
 */
package edu.mit.discourse.core.rep.referent;

import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IHasSegments;
import edu.mit.story.core.desc.ISegmentSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.util.IHasDisplayText;

/**
 * A reference to a referent. References may only be associated with a single
 * referent, and have a unique id number assigned to them by that referent.
 * 
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since edu.mit.discourse.core 1.0.0
 */
public interface IReference extends IHasPosition, IHasDisplayText, IHasSegments, IData {

	/**
	 * Returns an id for this reference, which should be unique relative to all
	 * the other references for the referent. IDs should be greater than zero.
	 * 
	 * @return a unique id for this reference
	 * @since edu.mit.discourse.core 1.0.0
	 */
	public int getID();

	/**
	 * Returns the referent to which this reference refers. Should not return
	 * <code>null</code>.
	 * 
	 * @return the referent to which this reference refers
	 * @since edu.mit.discourse.core 1.0.0
	 */
	public IReferent getParent();
	
	public ISegmentSet getExpression();

}
