/* Filename: IndArgModel.java
 * Creator: Raquel Hervas
 * Format: Java 2 v1.6.0
 * Date created: 06/10/2009
 */
package nil.ucm.indications2.core.rep.model;

import nil.ucm.indications2.core.rep.IndicationType;
import edu.mit.parsing.core.model.SegmentSetModel;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.model.IStoryModel;

/** 
 * TODO: Write comment
 *
 * @author Raquel Hervas
 * @version 1.0, (Oct. 6, 2009)
 * @since nil.ucm.indications.ui 1.0.0
 */
public class IndArgModel extends SegmentSetModel implements IIndArgModel {

	private IndicationType type = null;
	
	public IndArgModel(IStoryModel storyModel) {
		super(TokenRep.getInstance(), storyModel);
//		super(storyModel);
	}
	
	public IndicationType getType() {
		if (type == null)
			return IndicationType.UNKNOWN;
		else
			return type;
	}
	
	public void setType(IndicationType type) {
		this.type = type;
		
		// stimulate update
		setOutOfSync();
		notifyChangeListeners();
	}
	

	
	/* 
	 * (non-Javadoc) @see edu.mit.parsing.ui.models.SegmentSetModel#isCleared()
	 */
	@Override
	public boolean isCleared(){
		return type == null && super.isCleared();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.parsing.ui.models.SegmentSetModel#clear()
	 */
	@Override
	protected void internalClear(){
		type = null;
		super.internalClear();
	}
	
	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.IData#equals(edu.mit.story.core.desc.IData, edu.mit.story.core.align.IAlignedStoryModel)
	 */
	public boolean equals(IData tgtData, IAlignedStoryModel model) {
		throw new UnsupportedOperationException();
	}

}
