/* Filename: EntityContentProvider.java
 * Author: Mark A. Finlayson
 * Format: Java 2 v1.5.0
 * Date created: Nov 8, 2007
 */
package nil.ucm.indications2.ui.content;

import java.util.ArrayList;
import java.util.List;

import nil.ucm.indications2.core.rep.indication.IIndication;
import nil.ucm.indications2.core.rep.indication.IndicationRep;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.ui.content.StoryEditorContentProvider;
import edu.mit.story.ui.editor.IStoryEditor;

/**
 * A structure content provider that delivers the details of all the referent
 * descriptions in the story model of a particular story editor.
 *  
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since edu.mit.discourse.ui 1.0.0
 */
public class IndicationContentProvider extends StoryEditorContentProvider {
	
	/**
	 * Constructs a new content provider with no input
	 * 
	 * @since edu.mit.discourse.ui 1.0.0
	 */
	public IndicationContentProvider(){
		this(null);
	}

	/**
	 * Constructs a new content provider with the initial input specified.
	 * 
	 * @param input
	 *            the initial story editor; may be <code>null</code>
	 * @since edu.mit.discourse.ui 1.0.0
	 */
	public IndicationContentProvider(IStoryEditor input){
		super(IndicationRep.getInstance(), input, "(no indications)");
	}
	
	/* 
	 * (non-Javadoc) @see edu.mit.story.ui.content.StoryEditorContentProvider#hasChildren(java.lang.Object)
	 */
	public boolean hasChildren(Object element) {
		
		if(element instanceof IDesc){
			IDesc d = (IDesc)element;
			element = d.getData();
		}
		
		if(element instanceof IIndication)
			return true;
		
		if(element instanceof IHasPositionSet)
			return true;
		
		// defer to super, as always
		return super.hasChildren(element);
	}
	
	/* 
	 * (non-Javadoc) @see edu.mit.story.ui.content.StoryEditorContentProvider#getChildren(java.lang.Object)
	 */
	public Object[] getChildren(Object parent) {
		
		if(parent instanceof IDesc){
			IDesc d = (IDesc)parent;
			parent = d.getData();
		}
		
		if(parent instanceof IIndication){
			IIndication ind = (IIndication)parent;
			List<Object> result = new ArrayList<Object>(2);
			result.add(ind.getNuclei());
			if(ind.getModifiers().size() > 0)
				result.add(ind.getModifiers());
			return result.toArray();
		}
		
		if(parent instanceof IHasPositionSet){
			IHasPositionSet<?> set = (IHasPositionSet<?>)parent;
			return set.toArray();
		}
		
		// defer to super as always
		return super.getChildren(parent);
	}

}