/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.views.markers.MarkerContentGenerator;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.internal.AttributeMarkerGrouping;
import org.eclipse.ui.views.markers.internal.IField;
import org.eclipse.ui.views.markers.internal.MarkerGroup;
import org.eclipse.ui.views.markers.internal.MarkerGroupingEntry;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerType;
import org.eclipse.ui.views.markers.internal.MarkerTypesModel;
import org.eclipse.ui.views.markers.internal.ProblemFilter;
import org.eclipse.ui.views.markers.internal.TableComparator;

public class MarkerSupportRegistry
implements IExtensionChangeHandler {
    private static final String DESCRIPTION = "onDescription";
    public static final String ENABLED = "enabled";
    private static final Object ERROR = "ERROR";
    private static final Object INFO = "INFO";
    private static final Object WARNING = "WARNING";
    private static final String MARKER_ID = "markerId";
    public static final String MARKER_SUPPORT = "markerSupport";
    private static final Object ON_ANY = "ON_ANY";
    private static final Object ON_ANY_IN_SAME_CONTAINER = "ON_ANY_IN_SAME_CONTAINER";
    private static final Object ON_SELECTED_AND_CHILDREN = "ON_SELECTED_AND_CHILDREN";
    private static final Object ON_SELECTED_ONLY = "ON_SELECTED_ONLY";
    private static final Object PROBLEM_FILTER = "problemFilter";
    private static final String SCOPE = "scope";
    private static final String SELECTED_TYPE = "selectedType";
    private static final String SEVERITY = "severity";
    public static final String MARKER_TYPE_REFERENCE = "markerTypeReference";
    private static final String MARKER_CATEGORY = "markerTypeCategory";
    public static final String ATTRIBUTE_MAPPING = "markerAttributeMapping";
    public static final String MARKER_GROUPING = "markerGrouping";
    public static final String VALUE = "value";
    public static final String LABEL = "label";
    public static final String MARKER_ATTRIBUTE_GROUPING = "markerAttributeGrouping";
    public static final String MARKER_GROUPING_ENTRY = "markerGroupingEntry";
    private static final Object SEVERITY_ID = "org.eclipse.ui.ide.severity";
    static final String MARKER_CONTENT_GENERATOR = "markerContentGenerator";
    private static final String MARKER_CONTENT_GENERATOR_EXTENSION = "markerContentGeneratorExtension";
    private static final String MARKER_FIELD = "markerField";
    private static final String ATTRIBUTE_CLASS = "class";
    public static final String BOOKMARKS_GENERATOR = "org.eclipse.ui.ide.bookmarksGenerator";
    public static final String TASKS_GENERATOR = "org.eclipse.ui.ide.tasksGenerator";
    public static final String PROBLEMS_GENERATOR = "org.eclipse.ui.ide.problemsGenerator";
    public static final String ALL_MARKERS_GENERATOR = "org.eclipse.ui.ide.allMarkersGenerator";
    public static final String MARKERS_ID = "org.eclipse.ui.ide.MarkersView";
    private static final String ATTRIBUTE_GENERATOR_ID = "generatorId";
    private static MarkerSupportRegistry singleton;
    private static Object creationLock;
    private Map registeredFilters = new HashMap();
    private Map markerGroups = new HashMap();
    private HashMap categories = new HashMap();
    private HashMap hierarchyOrders = new HashMap();
    private MarkerType rootType;
    private HashMap generators = new HashMap();
    private HashMap fields = new HashMap();

    static {
        creationLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MarkerSupportRegistry getInstance() {
        if (singleton == null) {
            Object object = creationLock;
            synchronized (object) {
                if (singleton == null) {
                    singleton = new MarkerSupportRegistry();
                }
            }
        }
        return singleton;
    }

    private MarkerSupportRegistry() {
        IExtensionTracker tracker = PlatformUI.getWorkbench().getExtensionTracker();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui.ide", MARKER_SUPPORT);
        if (point == null) {
            return;
        }
        IExtension[] extensions = point.getExtensions();
        HashMap groupingEntries = new HashMap();
        HashMap generatorExtensions = new HashMap();
        HashMap entryIDsToEntries = new HashMap();
        HashSet attributeMappings = new HashSet();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            this.processExtension(tracker, extension, groupingEntries, entryIDsToEntries, attributeMappings, generatorExtensions);
            ++i;
        }
        this.postProcessExtensions(groupingEntries, entryIDsToEntries, attributeMappings, generatorExtensions);
        tracker.registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)point));
    }

    private void processExtension(IExtensionTracker tracker, IExtension extension, Map groupIDsToEntries, Map entryIDsToEntries, Collection attributeMappings, Map generatorExtensions) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int j = 0;
        while (j < elements.length) {
            IConfigurationElement element = elements[j];
            if (element.getName().equals(PROBLEM_FILTER)) {
                ProblemFilter filter = this.newFilter(element);
                this.registeredFilters.put(filter.getId(), filter);
                tracker.registerObject(extension, (Object)filter, 0);
            } else if (element.getName().equals(MARKER_GROUPING)) {
                MarkerGroup group = MarkerGroup.createMarkerGroup(element);
                this.markerGroups.put(group.getId(), group);
                tracker.registerObject(extension, (Object)group, 0);
            } else if (element.getName().equals(MARKER_GROUPING_ENTRY)) {
                MarkerGroupingEntry entry = new MarkerGroupingEntry(element);
                String groupName = element.getAttribute(MARKER_GROUPING);
                Collection entries = groupIDsToEntries.containsKey(groupName) ? (Collection)groupIDsToEntries.get(groupName) : new HashSet();
                entries.add(entry);
                groupIDsToEntries.put(groupName, entries);
                entryIDsToEntries.put(entry.getId(), entry);
                tracker.registerObject(extension, (Object)entry, 0);
            } else if (element.getName().equals(MARKER_ATTRIBUTE_GROUPING)) {
                AttributeMarkerGrouping grouping = new AttributeMarkerGrouping(element);
                attributeMappings.add(grouping);
                tracker.registerObject(extension, (Object)grouping, 0);
            } else if (element.getName().equals(MARKER_CATEGORY)) {
                String[] markerTypes = this.getMarkerTypes(element);
                String categoryName = element.getAttribute("name");
                int i = 0;
                while (i < markerTypes.length) {
                    this.categories.put(markerTypes[i], categoryName);
                    ++i;
                }
                tracker.registerObject(extension, (Object)categoryName, 0);
            } else if (element.getName().equals(MARKER_CONTENT_GENERATOR_EXTENSION)) {
                String generatorName = element.getAttribute(ATTRIBUTE_GENERATOR_ID);
                Collection extensionCollection = generatorExtensions.containsKey(generatorName) ? (Collection)generatorExtensions.get(generatorName) : new ArrayList();
                extensionCollection.add(element);
                generatorExtensions.put(generatorName, extensionCollection);
                tracker.registerObject(extension, (Object)element, 0);
            } else if (element.getName().equals(MARKER_CONTENT_GENERATOR)) {
                MarkerContentGenerator generator = new MarkerContentGenerator(element);
                this.generators.put(generator.getId(), generator);
                tracker.registerObject(extension, (Object)generator, 0);
            } else if (element.getName().equals(MARKER_FIELD)) {
                this.processMarkerField(tracker, extension, element);
            }
            ++j;
        }
    }

    private void processMarkerField(IExtensionTracker tracker, IExtension extension, IConfigurationElement element) {
        MarkerField field = null;
        try {
            field = (MarkerField)IDEWorkbenchPlugin.createExtension(element, ATTRIBUTE_CLASS);
            field.setConfigurationElement(element);
        }
        catch (CoreException e) {
            Policy.handle(e);
        }
        if (field != null) {
            this.fields.put(element.getAttribute("id"), field);
        }
        tracker.registerObject(extension, (Object)field, 0);
    }

    private void postProcessExtensions(Map groupIDsToEntries, Map entryIDsToEntries, Collection attributeMappings, Map generatorExtensions) {
        this.processGroupingEntries(groupIDsToEntries);
        this.processAttributeMappings(entryIDsToEntries, attributeMappings);
        this.postProcessContentGenerators(generatorExtensions);
    }

    private void postProcessContentGenerators(Map generatorExtensions) {
        Iterator generatorIterator = this.generators.values().iterator();
        while (generatorIterator.hasNext()) {
            MarkerContentGenerator generator = (MarkerContentGenerator)generatorIterator.next();
            generator.initializeFromConfigurationElement(this);
            if (!generatorExtensions.containsKey(generator.getId())) continue;
            generator.addExtensions((Collection)generatorExtensions.get(generator.getId()));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processGroupingEntries(Map groupingEntries) {
        entriesIterator = groupingEntries.keySet().iterator();
        while (entriesIterator.hasNext()) {
            nextGroupId = (String)entriesIterator.next();
            nextEntriesIterator = ((Collection)groupingEntries.get(nextGroupId)).iterator();
            if (!this.markerGroups.containsKey(nextGroupId)) ** GOTO lbl13
            while (nextEntriesIterator.hasNext()) {
                next = (MarkerGroupingEntry)nextEntriesIterator.next();
                next.setGroup((MarkerGroup)this.markerGroups.get(nextGroupId));
            }
            continue;
lbl-1000:
            // 1 sources

            {
                next = (MarkerGroupingEntry)nextEntriesIterator.next();
                IDEWorkbenchPlugin.log(NLS.bind((String)"markerGroupingEntry {0} defines invalid group {1}", (Object[])new String[]{next.getId(), nextGroupId}));
lbl13:
                // 2 sources

                ** while (nextEntriesIterator.hasNext())
            }
lbl14:
            // 1 sources

        }
    }

    private void processAttributeMappings(Map entryIDsToEntries, Collection attributeMappings) {
        Iterator mappingsIterator = attributeMappings.iterator();
        while (mappingsIterator.hasNext()) {
            AttributeMarkerGrouping attributeGrouping = (AttributeMarkerGrouping)mappingsIterator.next();
            String defaultEntryId = attributeGrouping.getDefaultGroupingEntry();
            if (defaultEntryId != null) {
                if (entryIDsToEntries.containsKey(defaultEntryId)) {
                    MarkerGroupingEntry entry = (MarkerGroupingEntry)entryIDsToEntries.get(defaultEntryId);
                    entry.setAsDefault(attributeGrouping.getMarkerType());
                } else {
                    IDEWorkbenchPlugin.log(NLS.bind((String)"Reference to invalid markerGroupingEntry {0}", (Object)defaultEntryId));
                }
            }
            IConfigurationElement[] mappings = attributeGrouping.getElement().getChildren(ATTRIBUTE_MAPPING);
            int i = 0;
            while (i < mappings.length) {
                String entryId = mappings[i].getAttribute(MARKER_GROUPING_ENTRY);
                if (entryIDsToEntries.containsKey(entryId)) {
                    MarkerGroupingEntry entry = (MarkerGroupingEntry)entryIDsToEntries.get(entryId);
                    entry.getMarkerGroup().mapAttribute(attributeGrouping, entry, mappings[i].getAttribute(VALUE));
                } else {
                    IDEWorkbenchPlugin.log(NLS.bind((String)"Reference to invaild markerGroupingEntry {0}", (Object)defaultEntryId));
                }
                ++i;
            }
        }
    }

    private String[] getMarkerTypes(IConfigurationElement element) {
        IConfigurationElement[] types = element.getChildren(MARKER_TYPE_REFERENCE);
        String[] ids = new String[types.length];
        int i = 0;
        while (i < ids.length) {
            ids[i] = types[i].getAttribute("id");
            ++i;
        }
        return ids;
    }

    public void addExtension(IExtensionTracker tracker, IExtension extension) {
        HashMap groupIDsToEntries = new HashMap();
        HashMap entryIDsToEntries = new HashMap();
        HashMap generatorExtensions = new HashMap();
        HashSet attributeMappings = new HashSet();
        this.processExtension(tracker, extension, groupIDsToEntries, entryIDsToEntries, attributeMappings, generatorExtensions);
        this.postProcessExtensions(groupIDsToEntries, entryIDsToEntries, attributeMappings, generatorExtensions);
    }

    public Collection getRegisteredFilters() {
        ArrayList<ProblemFilter> filteredFilters = new ArrayList<ProblemFilter>();
        Iterator registeredIterator = this.registeredFilters.values().iterator();
        while (registeredIterator.hasNext()) {
            ProblemFilter next = (ProblemFilter)registeredIterator.next();
            if (next.isFilteredOutByActivity()) continue;
            filteredFilters.add(next);
        }
        return filteredFilters;
    }

    private int getScopeValue(IConfigurationElement element) {
        String scope = element.getAttribute(SCOPE);
        if (scope == null) {
            return -1;
        }
        if (scope.equals(ON_ANY)) {
            return 0;
        }
        if (scope.equals(ON_SELECTED_ONLY)) {
            return 1;
        }
        if (scope.equals(ON_SELECTED_AND_CHILDREN)) {
            return 2;
        }
        if (scope.equals(ON_ANY_IN_SAME_CONTAINER)) {
            return 3;
        }
        return -1;
    }

    private int getSeverityValue(IConfigurationElement element) {
        String severity = element.getAttribute(SEVERITY);
        if (severity == null) {
            return -1;
        }
        if (severity.equals(INFO)) {
            return 1;
        }
        if (severity.equals(WARNING)) {
            return 2;
        }
        if (severity.equals(ERROR)) {
            return 4;
        }
        return -1;
    }

    private ProblemFilter newFilter(IConfigurationElement element) {
        int severityValue;
        String description;
        ProblemFilter filter = new ProblemFilter(element.getAttribute("name"));
        filter.createContributionFrom(element);
        String enabledValue = element.getAttribute(ENABLED);
        filter.setEnabled(enabledValue == null || Boolean.valueOf(enabledValue) != false);
        int scopeValue = this.getScopeValue(element);
        if (scopeValue >= 0) {
            filter.setOnResource(scopeValue);
        }
        if ((description = element.getAttribute(DESCRIPTION)) != null) {
            boolean contains = true;
            if (description.charAt(0) == '!') {
                description = description.substring(1, description.length());
                contains = false;
            }
            filter.setContains(contains);
            filter.setDescription(description);
        }
        if ((severityValue = this.getSeverityValue(element)) > 0) {
            filter.setSelectBySeverity(true);
            filter.setSeverity(severityValue);
        } else {
            filter.setSelectBySeverity(false);
        }
        ArrayList<MarkerType> selectedTypes = new ArrayList<MarkerType>();
        IConfigurationElement[] types = element.getChildren(SELECTED_TYPE);
        int j = 0;
        while (j < types.length) {
            String markerId = types[j].getAttribute(MARKER_ID);
            if (markerId != null) {
                MarkerType type = filter.getMarkerType(markerId);
                if (type == null) {
                    Status status = new Status(2, "org.eclipse.ui.ide", 2, NLS.bind((String)MarkerMessages.ProblemFilterRegistry_nullType, (Object[])new Object[]{markerId, filter.getName()}), null);
                    IDEWorkbenchPlugin.getDefault().getLog().log((IStatus)status);
                } else {
                    selectedTypes.add(type);
                }
            }
            ++j;
        }
        if (selectedTypes.size() > 0) {
            filter.setSelectedTypes(selectedTypes);
        }
        return filter;
    }

    public void removeExtension(IExtension extension, Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            Object entry;
            if (objects[i] instanceof ProblemFilter) {
                this.registeredFilters.remove(objects[i]);
            } else if (objects[i] instanceof MarkerGroup) {
                this.markerGroups.remove(((MarkerGroup)objects[i]).getId());
            } else if (objects[i] instanceof MarkerGroupingEntry) {
                entry = (MarkerGroupingEntry)objects[i];
                ((MarkerGroupingEntry)entry).getMarkerGroup().remove((MarkerGroupingEntry)entry);
            } else if (objects[i] instanceof AttributeMarkerGrouping) {
                entry = (AttributeMarkerGrouping)objects[i];
                ((AttributeMarkerGrouping)entry).unmap();
            } else if (objects[i] instanceof String) {
                this.removeValues(objects[i], this.categories);
            } else if (objects[i] instanceof MarkerField) {
                this.fields.remove(MarkerSupportInternalUtilities.getId((MarkerField)objects[i]));
            } else if (objects[i] instanceof MarkerContentGenerator) {
                this.generators.remove(((MarkerContentGenerator)objects[i]).getId());
            } else if (objects[i] instanceof IConfigurationElement) {
                IConfigurationElement element = (IConfigurationElement)objects[i];
                MarkerContentGenerator generator = (MarkerContentGenerator)this.generators.get(element.getAttribute(ATTRIBUTE_GENERATOR_ID));
                generator.removeExtension(element);
            }
            ++i;
        }
    }

    private void removeValues(Object value, HashMap cache) {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        Iterator keys = cache.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object next = cache.get(key);
            if (next instanceof Collection) {
                Collection collection = (Collection)next;
                if (!collection.contains(value)) continue;
                collection.remove(value);
                if (!collection.isEmpty()) break;
                keysToRemove.add(key);
                break;
            }
            if (!cache.get(key).equals(value)) continue;
            keysToRemove.add(key);
        }
        Iterator keysToRemoveIterator = keysToRemove.iterator();
        while (keysToRemoveIterator.hasNext()) {
            cache.remove(keysToRemoveIterator.next());
        }
    }

    public String getCategory(IMarker marker) {
        try {
            return this.getCategory(marker.getType());
        }
        catch (CoreException e) {
            Policy.handle(e);
            return null;
        }
    }

    public String getCategory(String markerType) {
        if (this.categories.containsKey(markerType)) {
            return (String)this.categories.get(markerType);
        }
        return null;
    }

    public TableComparator getSorterFor(String type) {
        if (this.hierarchyOrders.containsKey(type)) {
            return (TableComparator)this.hierarchyOrders.get(type);
        }
        TableComparator sorter = this.findSorterInChildren(type, this.getRootType());
        if (sorter == null) {
            return new TableComparator(new IField[0], new int[0], new int[0]);
        }
        return sorter;
    }

    private MarkerType getRootType() {
        if (this.rootType == null) {
            this.rootType = MarkerTypesModel.getInstance().getType("org.eclipse.core.resources.problemmarker");
        }
        return this.rootType;
    }

    private TableComparator findSorterInChildren(String typeName, MarkerType type) {
        MarkerType[] types = type.getAllSubTypes();
        TableComparator defaultSorter = null;
        if (this.hierarchyOrders.containsKey(type.getId())) {
            defaultSorter = (TableComparator)this.hierarchyOrders.get(type.getId());
        }
        int i = 0;
        while (i < types.length) {
            MarkerType[] subtypes = types[i].getAllSubTypes();
            int j = 0;
            while (j < subtypes.length) {
                TableComparator sorter = this.findSorterInChildren(typeName, subtypes[j]);
                if (sorter != null) {
                    return sorter;
                }
                ++j;
            }
            ++i;
        }
        return defaultSorter;
    }

    public Collection getMarkerGroups() {
        return this.markerGroups.values();
    }

    IField getDefaultGroupField() {
        return ((MarkerGroup)this.markerGroups.get(SEVERITY_ID)).getField();
    }

    public MarkerContentGenerator getGenerator(String id) {
        if (id != null && this.generators.containsKey(id)) {
            return (MarkerContentGenerator)this.generators.get(id);
        }
        return null;
    }

    public MarkerContentGenerator getDefaultGenerator() {
        return (MarkerContentGenerator)this.generators.get(PROBLEMS_GENERATOR);
    }

    public MarkerGroup getMarkerGroup(String categoryName) {
        if (this.markerGroups.containsKey(categoryName)) {
            return (MarkerGroup)this.markerGroups.get(categoryName);
        }
        return null;
    }

    public MarkerField getField(String id) {
        if (this.fields.containsKey(id)) {
            return (MarkerField)this.fields.get(id);
        }
        return null;
    }

    public MarkerContentGenerator[] getGenerators() {
        MarkerContentGenerator[] generatorArray = new MarkerContentGenerator[this.generators.size()];
        this.generators.values().toArray(generatorArray);
        return generatorArray;
    }
}

