/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.tag.factories;

import edu.mit.parsing.core.rep.parse.ITree;
import edu.mit.parsing.core.rep.parse.ParseRep;
import edu.mit.parsing.core.rep.tag.TagData;
import edu.mit.parsing.core.rep.tag.TagRep;
import edu.mit.parsing.core.rep.tag.factories.IndexedTagData;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.Segment;
import edu.mit.story.core.desc.factory.AbstractDescFactory2;
import edu.mit.story.core.mappers.BlockMapper;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.Change;
import edu.mit.story.core.model.change.Flag;
import edu.mit.story.core.model.change.IFlag;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.position.DistinctRegionSet;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.property.ConfigDescriptor;
import edu.mit.story.core.property.IConfigDescriptor;
import edu.mit.story.core.property.PropertyDescriptor;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.validation.IValidator;
import edu.mit.story.core.validation.NonEmptyStringValidator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagParseSpanFactory
extends AbstractDescFactory2<IndexedTagData> {
    public static final String ID = "edu.mit.parsing.tag.factory.parseTreeSpan";
    public static final String PARAM_ID_parseTagSet = "parseTagSet";
    public static final String PARAM_ID_defaultTagID = "defaultTagID";
    public static final String DEFAULT_PARSE_TAGS = "S SBAR";
    public static final String DEFAULT_TAG_ID = "UNKNOWN";
    private Set<String> parseTagSet;
    private String defaultTagID;

    public TagParseSpanFactory() {
        super(TagRep.getInstance(), new IRep[]{TokenRep.getInstance(), ParseRep.getInstance()});
    }

    protected boolean doInit(IStoryModel model) {
        String defaultTagID;
        String parseTagStr = (String)this.getConfiguration().get((Object)PARAM_ID_parseTagSet);
        if (parseTagStr == null) {
            parseTagStr = DEFAULT_PARSE_TAGS;
        }
        if ((defaultTagID = (String)this.getConfiguration().get((Object)PARAM_ID_defaultTagID)) == null) {
            defaultTagID = DEFAULT_TAG_ID;
        }
        List tagList = BlockMapper.SPACE.reconstitute(parseTagStr);
        HashSet parseTagSet = new HashSet(tagList);
        this.parseTagSet = Collections.unmodifiableSet(parseTagSet);
        this.defaultTagID = defaultTagID;
        return true;
    }

    public void dispose(IStoryModel model) {
        this.parseTagSet = null;
        this.defaultTagID = null;
    }

    protected DistinctRegionSet calculateRegions(StoryChangeEvent event) {
        IHasPositionSet parseRegions;
        Change parseChange = event.getChange(ParseRep.getInstance());
        if (parseChange == null) {
            return null;
        }
        IHasPositionSet iHasPositionSet = parseRegions = parseChange == null ? null : parseChange.getChanges((IFlag)Flag.DESCS);
        if (parseRegions == null || parseRegions.isEmpty()) {
            return null;
        }
        DistinctRegionSet result = new DistinctRegionSet();
        result.addAll((Collection)parseRegions);
        return result;
    }

    protected IHasPositionSet<IndexedTagData> calculateData(IHasPosition region, IStoryModel model) {
        IDescSet parseDs = model.getData().getDescriptions(ParseRep.getInstance()).openSet(region);
        HasPositionSet result = new HasPositionSet();
        for (IDesc parseD : parseDs) {
            ITree parse = (ITree)parseD.getData();
            result.addAll(this.extractTags(parse, model.getData()));
        }
        return result;
    }

    protected Collection<IndexedTagData> extractTags(ITree tree, IStoryData data) {
        LinkedList<IndexedTagData> result = new LinkedList<IndexedTagData>();
        LinkedList<? extends ITree> queue = new LinkedList<ITree>();
        queue.add(tree);
        while (!queue.isEmpty()) {
            tree = (ITree)queue.remove();
            queue.addAll(tree.getChildren());
            IndexedTagData tag = this.makeTag(tree, data);
            if (tag == null) continue;
            result.add(tag);
        }
        return result;
    }

    protected IndexedTagData makeTag(ITree tree, IStoryData data) {
        if (!this.parseTagSet.contains(tree.getLabel())) {
            return null;
        }
        Segment segment = new Segment((Collection)tree.getTokens(), data);
        TagData tagData = new TagData(this.defaultTagID, Collections.singleton(segment));
        return new IndexedTagData((IHasPosition)tree.getTokens(), tagData);
    }

    protected IConfigDescriptor createConfigurationDescriptor() {
        return new TagParseSpanFactoryConfigDescriptor(this.getID(), this.getName(), this.getDescription());
    }

    public static class TagParseSpanFactoryConfigDescriptor
    extends ConfigDescriptor {
        private static final long serialVersionUID = 1L;

        public TagParseSpanFactoryConfigDescriptor(String id, String name, String desc) {
            this();
            this.setID(id);
            this.setName(name);
            this.setDescription(desc);
        }

        public TagParseSpanFactoryConfigDescriptor() {
            String name = "Parse Tag Set";
            String desc = "A set of space-delimited parse tree tags to be transformed into tag spans; e.g., \"S SBAR\"";
            NonEmptyStringValidator validator = new NonEmptyStringValidator("parse tag set");
            PropertyDescriptor parseTagSetProp = new PropertyDescriptor(TagParseSpanFactory.PARAM_ID_parseTagSet, name, desc, TagParseSpanFactory.DEFAULT_PARSE_TAGS, (IValidator)validator, false);
            name = "Default Tag ID";
            desc = "The tag id to be used for generated spans; it is recommended this tag id be one that generates an error, warning, or to-do item in the UI; e.g., an unknown tag id";
            validator = new NonEmptyStringValidator("tag id");
            PropertyDescriptor tagIDProp = new PropertyDescriptor(TagParseSpanFactory.PARAM_ID_defaultTagID, name, desc, TagParseSpanFactory.DEFAULT_TAG_ID, (IValidator)validator, false);
            this.put(parseTagSetProp.getID(), parseTagSetProp);
            this.put(tagIDProp.getID(), tagIDProp);
        }
    }
}

