/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.label;

import edu.mit.jpropbank.Aspect;
import edu.mit.jpropbank.Feature;
import edu.mit.jpropbank.Form;
import edu.mit.jpropbank.Label;
import edu.mit.jpropbank.Tense;
import edu.mit.jpropbank.frames.IRoleset;
import edu.mit.parsing.core.rep.parse.ITree;
import edu.mit.parsing.core.rep.token.IBaseToken;
import edu.mit.parsing.core.rep.token.IToken;
import edu.mit.semantics.core.rep.semrole.ISemArg;
import edu.mit.semantics.core.rep.semrole.ISemRole;
import edu.mit.semantics.core.rep.semrole.ITreeNode;
import edu.mit.semantics.core.rep.semrole.SemRoleRep;
import edu.mit.semantics.ui.SemanticsUIPlugin;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.ui.content.StoryEditorContentProvider;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.label.StoryModelLabelProvider;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class SemRoleLabelProvider
extends StoryModelLabelProvider {
    private Image verbImg;
    private Image verbsImg;
    private Image featureImg;
    private Image featuresImg;
    private Image argImg;

    public SemRoleLabelProvider(IStoryEditor editor) {
        super(editor);
    }

    public StyledString getStyledText(Object element) {
        Object data = element;
        if (data instanceof IDescSet) {
            return this.getStyledText((IDescSet)data);
        }
        long id = -1L;
        if (data instanceof IDesc) {
            IDesc desc;
            IDesc iDesc = desc = data instanceof IDesc ? (IDesc)data : null;
            if (SemRoleRep.getInstance().isType((IHasRep)desc)) {
                id = desc.getID();
                data = desc.getData();
            }
        }
        if (data instanceof ISemRole) {
            StyledString result = this.getStyledText((ISemRole)data, id);
            if (element instanceof IDesc) {
                IDesc desc = (IDesc)element;
                return SemRoleLabelProvider.appendMergeTags((StyledString)result, (IDesc)desc);
            }
            return result;
        }
        if (data instanceof ISemArg) {
            return this.getStyledText((ISemArg)data);
        }
        if (StoryEditorContentProvider.isElement((Object)data, (int)1)) {
            return new StyledString("Features", StyledString.COUNTER_STYLER);
        }
        if (StoryEditorContentProvider.isElement((Object)data, (int)2)) {
            return new StyledString("Active: " + ((StoryEditorContentProvider.Element)data).getElement());
        }
        if (StoryEditorContentProvider.isElement((Object)data, (int)3)) {
            return new StyledString("Third Person: " + ((StoryEditorContentProvider.Element)data).getElement());
        }
        if (data instanceof Tense) {
            return new StyledString("Tense: " + ((Tense)data).getName());
        }
        if (data instanceof Aspect) {
            return new StyledString("Aspect: " + ((Aspect)data).getName());
        }
        if (data instanceof Form) {
            return new StyledString("Form: " + ((Form)data).getName());
        }
        return super.getStyledText(data);
    }

    public Image getImage(Object element) {
        if (element instanceof IDesc) {
            return this.getVerbImg();
        }
        if (element instanceof ISemRole) {
            return this.getVerbImg();
        }
        if (element instanceof IDescSet) {
            return this.getVerbsImg();
        }
        if (element instanceof ISemArg) {
            return this.getArgImg();
        }
        if (StoryEditorContentProvider.isElement((Object)element, (int)1)) {
            return this.getFeaturesImg();
        }
        if (element instanceof Tense) {
            return this.getFeatureImg();
        }
        if (element instanceof Aspect) {
            return this.getFeatureImg();
        }
        if (element instanceof Form) {
            return this.getFeatureImg();
        }
        if (StoryEditorContentProvider.isElement((Object)element, (int)2)) {
            return this.getFeatureImg();
        }
        if (StoryEditorContentProvider.isElement((Object)element, (int)3)) {
            return this.getFeatureImg();
        }
        return super.getImage(element);
    }

    protected StyledString getStyledText(IDescSet ds) {
        IDesc d = (IDesc)ds.first();
        ISemRole semrole = (ISemRole)d.getData();
        IDesc pred = (IDesc)semrole.getPredicate().getTokens().first();
        IBaseToken token = (IBaseToken)pred.getData();
        StyledString result = new StyledString();
        result.append(token.getSurface());
        result.append(" (count: ", StyledString.COUNTER_STYLER);
        result.append(Integer.toString(ds.size()), StyledString.COUNTER_STYLER);
        result.append(')');
        return result;
    }

    protected StyledString getStyledText(ISemRole semrole, long id) {
        IToken token = null;
        StyledString sb = new StyledString();
        ITree pred = semrole.getPredicate();
        if (pred == null) {
            sb.append("(none)");
        } else {
            for (IDesc d : pred.getTokens()) {
                if (token != null && token.isFollowedByBreak()) {
                    sb.append(' ');
                }
                token = (IToken)d.getData();
                sb.append(token.getSurface());
            }
        }
        IRoleset roleSet = semrole.getRoleset();
        if (roleSet != null) {
            sb.append(" (", StyledString.QUALIFIER_STYLER);
            sb.append(roleSet.getID(), StyledString.QUALIFIER_STYLER);
            sb.append(')', StyledString.QUALIFIER_STYLER);
            sb.append(' ');
            sb.append(roleSet.getName(), StyledString.COUNTER_STYLER);
        }
        if (id >= 0L) {
            sb.append(" (" + Long.toString(id) + ")", StyledString.DECORATIONS_STYLER);
        }
        return sb;
    }

    protected StyledString getStyledText(ISemArg arg) {
        StyledString sb = new StyledString();
        IDescSet leaves = null;
        HashSet tokens = new HashSet();
        for (List trace : arg.getLocation()) {
            for (ITreeNode split : trace) {
                tokens.addAll(split.getTree().getTokens());
                if (leaves != null) continue;
                leaves = split.getTree().getRoot().getTokens();
            }
        }
        if (leaves == null) {
            return new StyledString("(none)");
        }
        boolean notFirst = false;
        IToken lastToken = null;
        for (IDesc leaf : leaves) {
            if (!tokens.remove(leaf)) {
                lastToken = null;
                continue;
            }
            if (notFirst) {
                if (lastToken == null) {
                    sb.append("...");
                } else if (lastToken.isFollowedByBreak()) {
                    sb.append(' ');
                }
            }
            lastToken = (IToken)leaf.getData();
            sb.append(lastToken.getSurface());
            notFirst = true;
        }
        sb.append(" (", StyledString.DECORATIONS_STYLER);
        Label l = Label.valueOf((String)arg.getLabel());
        sb.append(l == null ? arg.getLabel().toString() : l.name(), StyledString.DECORATIONS_STYLER);
        if (arg.getFeature().length() > 0) {
            Feature f = Feature.getFeature((String)arg.getFeature());
            sb.append('-', StyledString.DECORATIONS_STYLER);
            if (f == null) {
                sb.append(arg.getFeature(), StyledString.DECORATIONS_STYLER);
            } else {
                sb.append(f.getDescription(), StyledString.DECORATIONS_STYLER);
            }
        }
        sb.append(") ", StyledString.DECORATIONS_STYLER);
        if (arg.getRole() != null) {
            sb.append(' ');
            sb.append(arg.getRole().getDescription(), StyledString.COUNTER_STYLER);
        }
        return sb;
    }

    protected Image getVerbsImg() {
        if (this.verbsImg == null) {
            this.verbsImg = SemanticsUIPlugin.getDefault().getImageRegistry().get("obj16/event.gif");
        }
        return this.verbsImg;
    }

    protected Image getVerbImg() {
        if (this.verbImg == null) {
            this.verbImg = SemanticsUIPlugin.getDefault().getImageRegistry().get("obj16/verb.gif");
        }
        return this.verbImg;
    }

    protected Image getFeaturesImg() {
        if (this.featuresImg == null) {
            this.featuresImg = SemanticsUIPlugin.getDefault().getImageRegistry().get("obj16/features.gif");
        }
        return this.featuresImg;
    }

    protected Image getFeatureImg() {
        if (this.featureImg == null) {
            this.featureImg = SemanticsUIPlugin.getDefault().getImageRegistry().get("obj16/feature.gif");
        }
        return this.featureImg;
    }

    protected Image getArgImg() {
        if (this.argImg == null) {
            this.argImg = SemanticsUIPlugin.getDefault().getImageRegistry().get("obj16/part.gif");
        }
        return this.argImg;
    }
}

