/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.position;

import edu.mit.story.core.element.IStoryElement;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IPosition;
import edu.mit.story.core.position.IPositionSet;
import edu.mit.story.core.position.ImmutablePosition;
import edu.mit.story.core.position.PositionComparator;
import edu.mit.story.core.position.PositionUtils;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.position.StoryPosition;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PositionSet
extends AbstractSet<IPosition>
implements IPositionSet {
    private static final long serialVersionUID = -6675830020707391303L;
    final PositionSet parent;
    final boolean openRange;
    final int fromOffset;
    final int toOffset;
    final IPosition fromPos;
    final IPosition toPos;
    protected SortedMap<Integer, SortedSet<IPosition>> offsetMap = new TreeMap<Integer, SortedSet<IPosition>>();

    public Object getAdapter(Class adapter) {
        return null;
    }

    public PositionSet() {
        this.parent = null;
        this.offsetMap = this.createOffsetMap(null);
        this.fromPos = null;
        this.toPos = null;
        this.fromOffset = 0;
        this.toOffset = 0x7FFFFFFE;
        this.openRange = false;
    }

    public PositionSet(Collection<? extends IPosition> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        this.parent = null;
        this.offsetMap = this.createOffsetMap(c);
        this.fromPos = null;
        this.toPos = null;
        this.fromOffset = 0;
        this.toOffset = 0x7FFFFFFE;
        this.openRange = false;
    }

    protected PositionSet(PositionSet parent, IPosition fromPos, IPosition toPos, int fromOffset, int toOffset, boolean open) {
        if (parent == null || this.offsetMap == null) {
            throw new NullPointerException();
        }
        this.parent = parent;
        this.offsetMap = parent.offsetMap;
        this.openRange = open;
        this.fromPos = fromPos;
        this.toPos = toPos;
        this.fromOffset = fromOffset;
        this.toOffset = toOffset;
        if (PositionUtils.definesNullSet(fromPos, toPos, fromOffset, toOffset)) {
            throw new IllegalArgumentException("the range of the of set is null");
        }
    }

    protected PositionSet getSubsetParent() {
        return this.parent == null ? this : this.parent;
    }

    public boolean isValid(IHasPosition hp) {
        if (hp == null) {
            return false;
        }
        if (this.parent == null) {
            return true;
        }
        IPosition p = hp instanceof IPosition ? (IPosition)hp : new ImmutablePosition(hp);
        return this.isWithinBounds(p) & this.isWithinRange(p);
    }

    protected boolean isWithinBounds(IPosition p) {
        if (p == null) {
            return false;
        }
        if (this.fromPos != null && PositionUtils.comparePositions(this.fromPos, p) > 0) {
            return false;
        }
        return this.toPos == null || PositionUtils.comparePositions(p, this.toPos) < 0;
    }

    protected boolean isWithinRange(IHasPosition p) {
        if (p == null) {
            return false;
        }
        if (this.openRange) {
            if (p.getOffset() == this.fromOffset & p.getRightOffset() == this.toOffset) {
                return true;
            }
            if (p.getLength() == 0 && (p.getOffset() == this.fromOffset || p.getRightOffset() == this.toOffset)) {
                return true;
            }
            if (p.getRightOffset() <= this.fromOffset) {
                return false;
            }
            return this.toOffset > p.getOffset();
        }
        return this.fromOffset <= p.getRightOffset() & p.getOffset() <= this.toOffset;
    }

    protected void throwException(IHasPosition p) {
        StringBuffer sb = new StringBuffer();
        sb.append("The argument is out of range for this set: ");
        if (p != null) {
            sb.append("argument=");
            sb.append(p.toString());
        }
        int length = sb.length();
        if (this.fromPos != null & this.toPos != null) {
            sb.append("position must fall between the left-closed range from=");
            sb.append(this.fromPos.toString());
            sb.append(", to=");
            sb.append(this.toPos.toString());
        } else if (this.fromPos != null) {
            sb.append("position must be less than ");
            sb.append(this.fromPos.toString());
        } else if (this.toPos != null) {
            sb.append("position must be greater than or equal to ");
            sb.append(this.toPos.toString());
        }
        if (sb.length() > length) {
            sb.append(", and ");
        }
        sb.append(" must overlap the ");
        sb.append(this.openRange ? "open" : "closed");
        sb.append(" index range=[" + this.fromOffset + "," + this.toOffset + "]");
        throw new IllegalArgumentException(sb.toString());
    }

    @Override
    public int getOffset() {
        OffsetIterator itr = new OffsetIterator();
        return itr.nextOffset();
    }

    @Override
    public int getLength() {
        int left = -1;
        int right = -1;
        OffsetIterator itr = new OffsetIterator();
        while (itr.hasNext()) {
            int nextRight;
            if (left == -1) {
                left = itr.nextOffset();
            }
            if (right >= (nextRight = ((IPosition)itr.next().last()).getRightOffset())) continue;
            right = nextRight;
        }
        return left != -1 & right != -1 ? right - left : -1;
    }

    @Override
    public int getRightOffset() {
        int right = -1;
        OffsetIterator itr = new OffsetIterator();
        while (itr.hasNext()) {
            int nextRight = ((IPosition)itr.next().last()).getRightOffset();
            if (right >= nextRight) continue;
            right = nextRight;
        }
        return right;
    }

    @Override
    public boolean add(IPosition p) {
        TreeSet<? super IPosition> subset;
        if (!this.isValid(p)) {
            this.throwException(p);
        }
        if ((subset = (TreeSet<? super IPosition>)this.offsetMap.get(p.getOffset())) == null) {
            subset = new TreeSet<IPosition>(this.comparator());
            this.offsetMap.put(p.getOffset(), subset);
        }
        boolean result = subset.add(p);
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends IPosition> c) {
        int n;
        if (c.isEmpty()) {
            return false;
        }
        if (!(c instanceof PositionSet)) {
            return super.addAll(c);
        }
        PositionSet ps = (PositionSet)c;
        if (ps == this | ps.parent == this) {
            for (IPosition iPosition : c) {
                if (this.isValid(iPosition)) continue;
                this.throwException(iPosition);
            }
            return false;
        }
        boolean bl = false;
        for (Map.Entry<Integer, SortedSet<IPosition>> entry : ps.offsetMap.entrySet()) {
            n |= this.addUniformOffsetCollection(entry.getKey(), (Collection<IPosition>)entry.getValue());
        }
        return n != 0;
    }

    protected boolean addUniformOffsetCollection(int offset, Collection<IPosition> c) {
        if (offset < 0 | c == null) {
            return false;
        }
        if (c.isEmpty()) {
            return false;
        }
        for (IPosition p : c) {
            if (this.isValid(p)) continue;
            this.throwException(p);
        }
        SortedSet<IPosition> subset = (SortedSet<IPosition>)this.offsetMap.get(offset);
        if (subset.isEmpty()) {
            return false;
        }
        if (subset == null) {
            subset = this.createOffsetSet(null);
            this.offsetMap.put(offset, subset);
        }
        boolean result = subset.addAll(c);
        return result;
    }

    @Override
    public boolean contains(Object o) {
        if (this.offsetMap.isEmpty()) {
            return false;
        }
        if (!(o instanceof IPosition)) {
            return false;
        }
        IPosition p = (IPosition)o;
        if (!this.isValid(p)) {
            return false;
        }
        SortedSet subset = (SortedSet)this.offsetMap.get(p.getOffset());
        if (subset == null) {
            return false;
        }
        return subset.contains(o);
    }

    @Override
    public Iterator<IPosition> iterator() {
        return new PositionSetIterator();
    }

    protected Iterator<SortedSet<IPosition>> offsetIterator() {
        return new OffsetIterator();
    }

    @Override
    public Comparator<? super IPosition> comparator() {
        return PositionComparator.getInstance();
    }

    @Override
    public boolean remove(Object o) {
        if (this.offsetMap.isEmpty()) {
            return false;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof IPosition)) {
            return false;
        }
        IPosition p = (IPosition)o;
        if (!this.isValid(p)) {
            return false;
        }
        SortedSet subset = (SortedSet)this.offsetMap.get(p.getOffset());
        if (subset == null) {
            return false;
        }
        return subset.remove(p);
    }

    @Override
    public int size() {
        int result = 0;
        Iterator<SortedSet<IPosition>> i = this.offsetIterator();
        while (i.hasNext()) {
            result += i.next().size();
        }
        return result;
    }

    @Override
    public IPosition first() {
        if (this.parent == null) {
            Integer firstOffset = this.offsetMap.firstKey();
            SortedSet firstSet = (SortedSet)this.offsetMap.get(firstOffset);
            if (firstSet == null) {
                throw new NoSuchElementException();
            }
            return (IPosition)firstSet.first();
        }
        Iterator<SortedSet<IPosition>> subsetItr = this.offsetIterator();
        if (subsetItr.hasNext()) {
            return subsetItr.next().first();
        }
        throw new NoSuchElementException();
    }

    @Override
    public IPosition last() {
        if (this.parent == null) {
            SortedSet lastSet = (SortedSet)this.offsetMap.get(this.offsetMap.lastKey());
            if (lastSet == null) {
                throw new NoSuchElementException();
            }
            return (IPosition)lastSet.last();
        }
        SortedSet<IPosition> last = null;
        Iterator<SortedSet<IPosition>> subsetItr = this.offsetIterator();
        while (subsetItr.hasNext()) {
            last = subsetItr.next();
        }
        if (last == null) {
            throw new NoSuchElementException();
        }
        return (IPosition)last.last();
    }

    protected SortedSet<IPosition> createOffsetSet(Collection<? extends IPosition> c) {
        TreeSet<IPosition> result = new TreeSet<IPosition>(this.comparator());
        if (c != null) {
            result.addAll(c);
        }
        return result;
    }

    protected SortedMap<Integer, SortedSet<IPosition>> createOffsetMap(Collection<? extends IPosition> c) {
        if (c == null) {
            return new TreeMap<Integer, SortedSet<IPosition>>();
        }
        PositionSet result = new PositionSet();
        result.addAll(c);
        return result.offsetMap;
    }

    protected IPositionSet createSubset(PositionSet parent, IPosition fromElement, IPosition toElement, int fromOffset, int toOffset, boolean open) {
        return new PositionSet(parent, fromElement, toElement, fromOffset, toOffset, open);
    }

    @Override
    public IPositionSet subSet(IHasPosition fromElement, IHasPosition toElement) {
        ImmutablePosition to;
        ImmutablePosition from = fromElement == null ? null : new ImmutablePosition(fromElement);
        ImmutablePosition immutablePosition = to = toElement == null ? null : new ImmutablePosition(toElement);
        if (!this.isWithinBounds(from)) {
            this.throwException(from);
        }
        if (!this.isWithinBounds(to)) {
            this.throwException(to);
        }
        return this.createSubset(this.getSubsetParent(), from, to, this.fromOffset, this.toOffset, false);
    }

    @Override
    public IPositionSet headSet(int offset, int length) {
        ImmutablePosition to = new ImmutablePosition(offset, length);
        if (!this.isWithinBounds(to)) {
            this.throwException(new SimplePosition(offset, length));
        }
        return this.createSubset(this.getSubsetParent(), this.fromPos, to, this.fromOffset, this.toOffset, false);
    }

    @Override
    public IPositionSet headSet(IHasPosition toElement) {
        ImmutablePosition to = new ImmutablePosition(toElement);
        if (!this.isWithinBounds(to)) {
            this.throwException(toElement);
        }
        return this.createSubset(this.getSubsetParent(), this.fromPos, to, this.fromOffset, this.toOffset, false);
    }

    @Override
    public IPositionSet tailSet(int offset, int length) {
        ImmutablePosition from = new ImmutablePosition(offset, length);
        if (!this.isWithinBounds(from)) {
            this.throwException(new SimplePosition(offset, length));
        }
        return this.createSubset(this.getSubsetParent(), from, this.toPos, this.fromOffset, this.toOffset, false);
    }

    @Override
    public IPositionSet tailSet(IHasPosition fromElement) {
        ImmutablePosition from = new ImmutablePosition(fromElement);
        if (!this.isWithinBounds(from)) {
            this.throwException(from);
        }
        return this.createSubset(this.getSubsetParent(), from, this.toPos, this.fromOffset, this.toOffset, false);
    }

    @Override
    public IPositionSet closedSet(IHasPosition range) {
        StoryPosition newRange = new StoryPosition(range);
        if (!this.isWithinBounds(newRange)) {
            this.throwException(newRange);
        }
        return this.createSubset(this.getSubsetParent(), this.fromPos, this.toPos, Math.max(this.fromOffset, range.getOffset()), Math.min(this.toOffset, range.getRightOffset()), false);
    }

    @Override
    public IPositionSet matchSet(IHasPosition position) {
        ImmutablePosition from = new ImmutablePosition(position);
        ImmutablePosition to = new ImmutablePosition(position.getOffset(), position.getLength() + 1);
        if (!this.isValid(from)) {
            this.throwException(position);
        }
        return this.createSubset(this.getSubsetParent(), from, to, this.fromOffset, this.toOffset, false);
    }

    @Override
    public IPositionSet openSet(IHasPosition range) {
        if (!this.isValid(range)) {
            this.throwException(range);
        }
        return this.createSubset(this.getSubsetParent(), this.fromPos, this.toPos, Math.max(this.fromOffset, range.getOffset()), Math.min(this.toOffset, range.getRightOffset()), true);
    }

    @Override
    public final int getImplementationCode() {
        return 4;
    }

    @Override
    public final String getImplementationName() {
        return IStoryElement.NAME_IPositionSet;
    }

    @Override
    public final String getSerializedData() {
        return null;
    }

    public IPositionSet subSet(IPosition fromElement, IPosition toElement) {
        return this.subSet((IHasPosition)fromElement, (IHasPosition)toElement);
    }

    public IPositionSet headSet(IPosition toElement) {
        return this.headSet((IHasPosition)toElement);
    }

    public IPositionSet tailSet(IPosition fromElement) {
        return this.tailSet((IHasPosition)fromElement);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class OffsetIterator
    implements Iterator<SortedSet<IPosition>> {
        Iterator<Map.Entry<Integer, SortedSet<IPosition>>> sortedSetItr;
        SortedSet<IPosition> next;
        int nextOffset;

        protected OffsetIterator() {
            if (PositionSet.this.parent == null) {
                this.sortedSetItr = PositionSet.this.offsetMap.entrySet().iterator();
            } else {
                int toInt = PositionSet.this.toPos != null ? Math.min(PositionSet.this.toPos.getOffset() + 1, PositionSet.this.toOffset + 1) : PositionSet.this.toOffset + 1;
                this.sortedSetItr = PositionSet.this.fromPos != null ? PositionSet.this.offsetMap.subMap(PositionSet.this.fromPos.getOffset(), toInt).entrySet().iterator() : PositionSet.this.offsetMap.headMap(toInt).entrySet().iterator();
            }
            this.loadNext();
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        protected void loadNext() {
            block6: {
                this.next = null;
                this.nextOffset = -1;
                if (PositionSet.this.parent != null) ** GOTO lbl30
                while (this.sortedSetItr.hasNext()) {
                    entry = this.sortedSetItr.next();
                    if (entry.getValue().isEmpty()) continue;
                    this.next = entry.getValue();
                    this.nextOffset = entry.getKey();
                    return;
                }
                break block6;
lbl-1000:
                // 1 sources

                {
                    entry = this.sortedSetItr.next();
                    if (entry.getValue().isEmpty()) continue;
                    if (PositionSet.this.toOffset <= entry.getKey() && PositionSet.this.openRange) {
                        toPosActual /* !! */  = new ImmutablePosition(PositionSet.this.toOffset, 1);
                        if (PositionSet.this.toPos != null) {
                            toPosActual /* !! */  = (IPosition)PositionUtils.minPosition(toPosActual /* !! */ , PositionSet.this.toPos);
                        }
                        if (PositionSet.this.comparator().compare(toPosActual /* !! */ , entry.getValue().first()) <= 0) {
                            return;
                        }
                        this.next = entry.getValue().headSet(toPosActual /* !! */ );
                        this.nextOffset = entry.getKey();
                        return;
                    }
                    fromLength = PositionSet.this.fromOffset - entry.getKey() + (PositionSet.this.openRange != false && entry.getKey() < PositionSet.this.fromOffset ? 1 : 0);
                    fromPosActual /* !! */  = new ImmutablePosition(entry.getKey(), Math.max(0, fromLength));
                    if (PositionSet.this.fromPos != null) {
                        fromPosActual /* !! */  = (IPosition)PositionUtils.maxPosition(fromPosActual /* !! */ , PositionSet.this.fromPos);
                    }
                    if (PositionUtils.comparePositions(entry.getValue().last(), fromPosActual /* !! */ ) < 0 || PositionSet.this.toPos != null && (PositionUtils.comparePositions(fromPosActual /* !! */ , PositionSet.this.toPos) >= 0 || PositionUtils.comparePositions(PositionSet.this.toPos, entry.getValue().first()) < 0)) continue;
                    this.next = PositionSet.this.toPos != null ? entry.getValue().subSet(fromPosActual /* !! */ , PositionSet.this.toPos) : entry.getValue().tailSet(fromPosActual /* !! */ );
                    this.nextOffset = entry.getKey();
                    return;
lbl30:
                    // 3 sources

                    ** while (this.sortedSetItr.hasNext())
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public SortedSet<IPosition> next() {
            SortedSet<IPosition> result = this.next;
            this.loadNext();
            return result;
        }

        public int nextOffset() {
            return this.nextOffset();
        }

        @Override
        public void remove() {
            throw new IllegalArgumentException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PositionSetIterator
    implements Iterator<IPosition> {
        int total;
        int delivered = 0;
        protected Iterator<IPosition> currentItr = null;
        protected Iterator<SortedSet<IPosition>> mainItr;

        protected PositionSetIterator() {
            this.mainItr = PositionSet.this.offsetIterator();
            this.total = PositionSet.this.size();
        }

        @Override
        public boolean hasNext() {
            return this.delivered < this.total;
        }

        @Override
        public IPosition next() {
            if (this.currentItr == null) {
                this.loadNextIterator();
            } else if (!this.currentItr.hasNext()) {
                this.loadNextIterator();
            }
            if (this.currentItr == null) {
                throw new NoSuchElementException();
            }
            ++this.delivered;
            return this.currentItr.next();
        }

        protected void loadNextIterator() {
            if (this.mainItr.hasNext()) {
                this.currentItr = this.mainItr.next().iterator();
            }
        }

        @Override
        public void remove() {
            if (this.currentItr == null) {
                throw new IllegalStateException("next() not yet called");
            }
            this.currentItr.remove();
        }
    }
}

