/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.model.change;

import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.change.AbstractModelChange;
import edu.mit.story.core.model.change.AddDescriptionsChange;
import edu.mit.story.core.model.change.CompositeModelChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.RemoveDescriptionsChange;
import edu.mit.story.core.model.change.StoryChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecalculateChange
extends AbstractModelChange {
    private final List<Long> targets;

    public RecalculateChange(Collection<? extends IDesc> ds) {
        super("Recalculate Description");
        if (ds.isEmpty()) {
            throw new IllegalArgumentException();
        }
        LinkedHashSet<? extends IDesc> targets = new LinkedHashSet<IDesc>(ds);
        ArrayList<Long> hidden = new ArrayList<Long>(targets.size());
        for (IDesc iDesc : targets) {
            hidden.add(iDesc.getID());
        }
        this.targets = Collections.unmodifiableList(hidden);
    }

    @Override
    protected StoryChangeEvent doApply(Object source, IMutableStoryModel model) {
        LinkedList<IDesc> toRemove = new LinkedList<IDesc>();
        LinkedList<Desc> toAdd = new LinkedList<Desc>();
        for (long id : this.targets) {
            IStructuredData oldData;
            IStructuredData newData;
            IDesc oldDesc = model.getData().getDescription(id);
            if (!oldDesc.getRep().isStructured() || (newData = (oldData = (IStructuredData)oldDesc.getData()).recalculate(oldDesc, model)) == oldData) continue;
            toRemove.add(oldDesc);
            if (oldData == null) continue;
            Desc newDesc = new Desc(id, oldDesc.getRep(), newData.calculatePosition(), newData, oldDesc.getMetaData());
            toAdd.add(newDesc);
        }
        if (toRemove.isEmpty() && toAdd.isEmpty()) {
            return null;
        }
        ArrayList<AbstractModelChange> changes = new ArrayList<AbstractModelChange>(2);
        if (!toRemove.isEmpty()) {
            changes.add(new RemoveDescriptionsChange(toRemove));
        }
        if (!toAdd.isEmpty()) {
            changes.add(new AddDescriptionsChange(toAdd));
        }
        IModelChange change = changes.size() == 1 ? (IModelChange)changes.get(0) : new CompositeModelChange(changes);
        return change.apply(source, model);
    }
}

