/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.io.InDataStreamFile;
import edu.stanford.nlp.io.OutDataStreamFile;
import edu.stanford.nlp.util.Index;
import java.io.IOException;
import java.util.HashSet;

public class TTags {
    private Index<String> index = new Index();
    private HashSet<String> closed = new HashSet();
    private String[] openTags = null;

    public TTags() {
        this("english");
    }

    public TTags(String language) {
        if (language.equalsIgnoreCase("english")) {
            this.closed.add(".");
            this.closed.add(",");
            this.closed.add("``");
            this.closed.add("''");
            this.closed.add(":");
            this.closed.add("$");
            this.closed.add("EX");
            this.closed.add("(");
            this.closed.add(")");
            this.closed.add("#");
            this.closed.add("MD");
            this.closed.add("CC");
            this.closed.add("DT");
            this.closed.add("LS");
            this.closed.add("PDT");
            this.closed.add("POS");
            this.closed.add("PRP");
            this.closed.add("PRP$");
            this.closed.add("RP");
            this.closed.add("TO");
            this.closed.add("EOS");
            this.closed.add("UH");
            this.closed.add("WDT");
            this.closed.add("WP");
            this.closed.add("WP$");
            this.closed.add("WRB");
        } else if (language.equalsIgnoreCase("polish")) {
            this.closed.add(".");
            this.closed.add(",");
            this.closed.add("``");
            this.closed.add("''");
            this.closed.add(":");
            this.closed.add("$");
            this.closed.add("(");
            this.closed.add(")");
            this.closed.add("#");
            this.closed.add("POS");
            this.closed.add("EOS");
            this.closed.add("ppron12");
            this.closed.add("ppron3");
            this.closed.add("siebie");
            this.closed.add("qub");
            this.closed.add("conj");
        } else if (language.equalsIgnoreCase("chinese")) {
            this.closed.add("AS");
            this.closed.add("BA");
            this.closed.add("CC");
            this.closed.add("CS");
            this.closed.add("DEC");
            this.closed.add("DEG");
            this.closed.add("DER");
            this.closed.add("DEV");
            this.closed.add("DT");
            this.closed.add("ETC");
            this.closed.add("IJ");
            this.closed.add("LB");
            this.closed.add("LC");
            this.closed.add("P");
            this.closed.add("PN");
            this.closed.add("PU");
            this.closed.add("SB");
            this.closed.add("SP");
            this.closed.add("VC");
            this.closed.add("VE");
        } else if (language.equalsIgnoreCase("")) {
            System.err.println("warning: no language set; assuming all tags are open tags");
        } else {
            throw new RuntimeException("unknown language: " + language);
        }
    }

    public String[] getOpenTags() {
        if (this.openTags == null) {
            HashSet<String> open = new HashSet<String>();
            for (String tag : this.index) {
                if (this.closed.contains(tag)) continue;
                open.add(tag);
            }
            this.openTags = open.toArray(new String[0]);
        }
        return this.openTags;
    }

    public int add(String tag) {
        this.index.add(tag);
        return this.index.indexOf(tag);
    }

    public String getTag(int i) {
        if (i == -1) {
            throw new Error("WTF-wmorgan");
        }
        return this.index.get(i);
    }

    public void save(String filename) {
        try {
            OutDataStreamFile out2 = new OutDataStreamFile(filename);
            out2.writeInt(this.index.size());
            for (int i = 0; i < this.index.size(); ++i) {
                out2.writeUTF(this.index.get(i));
                out2.writeBoolean(this.closed.contains(this.index.get(i)));
            }
            out2.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void read(String filename) {
        try {
            InDataStreamFile in = new InDataStreamFile(filename);
            int size = in.readInt();
            this.index = new Index();
            for (int i = 0; i < size; ++i) {
                String tag = in.readUTF();
                boolean inClosed = in.readBoolean();
                this.index.add(tag);
                if (!inClosed) continue;
                this.closed.add(tag);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isClosed(String tag) {
        return this.closed.contains(tag);
    }

    public void markClosed(String tag) {
        this.closed.add(tag);
    }

    public int getIndex(String tag) {
        return this.index.indexOf(tag);
    }

    public int getSize() {
        return this.index.size();
    }
}

