/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.ling.WordTag;

public class WordTagFactory
implements LabelFactory {
    private final char divider;

    public WordTagFactory() {
        this('/');
    }

    public WordTagFactory(char divider) {
        this.divider = divider;
    }

    public Label newLabel(String labelStr) {
        return new WordTag(labelStr);
    }

    public Label newLabel(String labelStr, int options) {
        if (options == 2) {
            return new WordTag(null, labelStr);
        }
        return new WordTag(labelStr);
    }

    public Label newLabelFromString(String word) {
        int where = word.lastIndexOf(this.divider);
        if (where >= 0) {
            return new WordTag(word.substring(0, where), word.substring(where + 1));
        }
        return new WordTag(word);
    }

    public Label newLabel(Label oldLabel) {
        return new WordTag(oldLabel);
    }
}

