/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.actions.delegates;

import edu.mit.discourse.core.rep.referent.IReferent;
import edu.mit.discourse.core.rep.referent.Referent;
import edu.mit.discourse.core.rep.referent.ReferentRep;
import edu.mit.discourse.core.rep.referent.change.AddReferenceChange;
import edu.mit.discourse.ui.DiscourseUIPlugin;
import edu.mit.discourse.ui.actions.ReferentActionUtils;
import edu.mit.parsing.core.util.ParsingUtils;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.IUndoableStoryModel;
import edu.mit.story.core.model.change.Change;
import edu.mit.story.core.model.change.Flag;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.IModelListener;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.ui.actions.delegates.AbstractDelegate;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.editor.StoryEditorUtils;
import java.util.HashSet;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class AddReferenceToLastDelegate
extends AbstractDelegate
implements IModelListener {
    IStoryEditor editor;
    IDesc lastEntity;

    public void init(IAction action) {
        action.setDisabledImageDescriptor(DiscourseUIPlugin.getDefault().getImageRegistry().getDescriptor("dtool16/add_reference.gif"));
    }

    public void run(IAction action) {
        if (!ReferentActionUtils.canAddReferenceTo(this.lastEntity, this.editor) || this.doRun()) {
            PlatformUI.getWorkbench().getDisplay().beep();
        }
    }

    protected boolean doRun() {
        Timing timing = new Timing("user", true);
        if (!this.editor.getStoryModel().supports(ReferentRep.getInstance())) {
            return false;
        }
        IDescSet tokens = ParsingUtils.getSelectedTokens((IStoryEditor)this.editor);
        if (tokens.isEmpty()) {
            return false;
        }
        if (Referent.isReferenceInModel((IHasPosition)tokens, (IStoryData)this.editor.getStoryModel().getData()) != null) {
            return false;
        }
        this.editor.getStoryModel().applyChange((Object)this, (IModelChange)new AddReferenceChange((IHasPosition)tokens, this.lastEntity, (ITiming)timing), false);
        return true;
    }

    public void setActivePart(IWorkbenchPart activePart) {
        IUndoableStoryModel model;
        if (this.editor != null && (model = this.editor.getStoryModel()) != null) {
            model.removeModelListener((IModelListener)this);
        }
        this.editor = StoryEditorUtils.extractStoryEditor((IWorkbenchPart)activePart);
        if (this.editor != null) {
            this.editor.getStoryModel().addModelListener((IModelListener)this);
        }
    }

    public void updateAction(IAction action) {
        if (this.lastEntity == null) {
            action.setEnabled(false);
            action.setText("Add Reference to Last");
            return;
        }
        if (this.editor == null) {
            action.setEnabled(false);
            return;
        }
        if (!this.editor.getStoryModel().supports(ReferentRep.getInstance())) {
            action.setEnabled(false);
            return;
        }
        IReferent ref = (IReferent)this.lastEntity.getData();
        String name = ref.getName();
        if (name.length() > 13) {
            name = String.valueOf(name.substring(0, 10)) + "...";
        }
        action.setText("Add Reference to '" + name + "'");
        action.setEnabled(true);
    }

    public void modelChanged(StoryChangeEvent e) {
        Change change = e.getChange(ReferentRep.getInstance());
        if (change == null) {
            return;
        }
        IDesc result = this.lastEntity;
        IHasPositionSet descs = change.getChanges(Flag.DESC_REMOVED);
        if (descs != null && descs.contains((Object)this.lastEntity)) {
            result = null;
        }
        HashSet changed = new HashSet();
        descs = change.getChanges(Flag.DESC_ADDED);
        if (descs != null) {
            changed.addAll(descs);
        }
        if (changed.size() == 1) {
            result = (IDesc)changed.iterator().next();
        } else if (changed.size() > 1) {
            result = null;
        }
        this.lastEntity = result;
        this.update();
    }
}

