/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TypedListener;

public class TreeColumn
extends Item {
    Tree parent;
    int headerHandle;
    int stringPtr;
    boolean moveable;
    boolean resizable = true;

    public TreeColumn(Tree parent, int style) {
        this(TreeColumn.checkNull(parent), TreeColumn.checkStyle(style), parent.columnCount);
    }

    public TreeColumn(Tree parent, int style, int index) {
        super(parent, TreeColumn.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, index);
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static Tree checkNull(Tree tree) {
        if (tree == null) {
            SWT.error(4);
        }
        return tree;
    }

    static int checkStyle(int style) {
        return TreeColumn.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createHandle() {
        this.handle = OS.gcnew_GridViewColumn();
        if (this.handle == 0) {
            SWT.error(2);
        }
        this.headerHandle = OS.gcnew_GridViewColumnHeader();
        OS.GridViewColumn_Header(this.handle, this.headerHandle);
        OS.GridViewColumn_Width(this.handle, 0.0);
    }

    void deregister() {
        this.display.removeWidget(this.headerHandle);
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    int findContentPresenter(int element, int contentPresenterType) {
        int type = OS.Object_GetType(element);
        boolean found = OS.Object_Equals(contentPresenterType, type);
        OS.GCHandle_Free(type);
        if (found) {
            return element;
        }
        int count = OS.VisualTreeHelper_GetChildrenCount(element);
        int i = 0;
        while (i < count) {
            int result;
            int child = OS.VisualTreeHelper_GetChild(element, i);
            if (child != (result = this.findContentPresenter(child, contentPresenterType))) {
                OS.GCHandle_Free(child);
            }
            if (result != 0) {
                return result;
            }
            ++i;
        }
        return 0;
    }

    int findPart(String part) {
        int contentPresenterType = OS.ContentPresenter_typeid();
        int contentPresenter = this.findContentPresenter(this.headerHandle, contentPresenterType);
        int result = 0;
        if (contentPresenter != 0) {
            int template = OS.GridViewColumn_HeaderTemplate(this.handle);
            int strPtr = this.createDotNetString(part, false);
            result = OS.FrameworkTemplate_FindName(template, strPtr, contentPresenter);
            OS.GCHandle_Free(strPtr);
            OS.GCHandle_Free(template);
            OS.GCHandle_Free(contentPresenter);
        }
        OS.GCHandle_Free(contentPresenterType);
        return result;
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public boolean getMoveable() {
        this.checkWidget();
        return this.moveable;
    }

    String getNameText() {
        return this.getText();
    }

    public Tree getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getResizable() {
        this.checkWidget();
        return this.resizable;
    }

    public String getToolTipText() {
        this.checkWidget();
        int strPtr = OS.FrameworkElement_ToolTip(this.headerHandle);
        String string = TreeColumn.createJavaString(strPtr);
        OS.GCHandle_Free(strPtr);
        return string;
    }

    public int getWidth() {
        this.checkWidget();
        return (int)OS.GridViewColumn_ActualWidth(this.handle);
    }

    void HandleLoaded(int source, int e) {
        this.updateImage();
        this.updateText();
    }

    void hookEvents() {
        super.hookEvents();
        int handler = OS.gcnew_RoutedEventHandler(this.jniRef, "HandleLoaded");
        if (handler == 0) {
            this.error(2);
        }
        OS.FrameworkElement_Loaded(this.headerHandle, handler);
        OS.GCHandle_Free(handler);
    }

    public void pack() {
        this.checkWidget();
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return;
        }
        int widthProperty = OS.GridViewColumn_WidthProperty();
        OS.DependencyObject_ClearValue(this.handle, widthProperty);
        OS.GCHandle_Free(widthProperty);
    }

    void register() {
        this.display.addWidget(this.headerHandle, this);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.handle != 0) {
            OS.GCHandle_Free(this.handle);
        }
        this.handle = 0;
        OS.GCHandle_Free(this.headerHandle);
        this.headerHandle = 0;
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.stringPtr != 0) {
            OS.GCHandle_Free(this.stringPtr);
        }
        this.stringPtr = 0;
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, listener);
        this.eventTable.unhook(11, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        int index = this.parent.indexOf(this);
        if (index == -1 || index == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
    }

    public void setImage(Image image) {
        this.checkWidget();
        super.setImage(image);
        this.updateImage();
    }

    public void setMoveable(boolean moveable) {
        this.checkWidget();
        this.moveable = moveable;
    }

    public void setResizable(boolean resizable) {
        this.checkWidget();
        this.resizable = resizable;
    }

    void setSortDirection(int direction) {
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.text = string;
        this.updateText();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        if (string != null && string.length() == 0) {
            string = null;
        }
        int strPtr = this.createDotNetString(string, false);
        OS.FrameworkElement_ToolTip(this.headerHandle, strPtr);
        OS.GCHandle_Free(strPtr);
    }

    public void setWidth(int width) {
        this.checkWidget();
        if (width < 0) {
            return;
        }
        OS.GridViewColumn_Width(this.handle, width);
    }

    void updateImage() {
        int part = this.findPart("SWT_PART_IMAGE");
        if (part == 0) {
            return;
        }
        OS.Image_Source(part, this.image == null ? 0 : this.image.handle);
        OS.GCHandle_Free(part);
    }

    void updateText() {
        int part = this.findPart("SWT_PART_TEXT");
        if (part == 0) {
            return;
        }
        int str = this.createDotNetString(this.text, false);
        OS.TextBlock_Text(part, str);
        OS.GCHandle_Free(str);
        OS.GCHandle_Free(part);
    }
}

