/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tracker
extends Widget {
    Composite parent;
    boolean cancelled;
    boolean stippled;
    Rectangle[] rectangles;
    Rectangle[] proportions;
    Rectangle bounds;
    Cursor clientCursor;
    int resizeCursor;
    int cursorOrientation = 0;
    int oldX;
    int oldY;
    int canvasHandle;
    int frame;
    static final int STEPSIZE_SMALL = 1;
    static final int STEPSIZE_LARGE = 9;

    public Tracker(Composite parent, int style) {
        super(parent, Tracker.checkStyle(style));
        this.parent = parent;
    }

    public Tracker(Display display, int style) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.style = Tracker.checkStyle(style);
        this.display = display;
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    Point adjustMoveCursor() {
        if (this.bounds == null) {
            return null;
        }
        int newX = this.bounds.x + this.bounds.width / 2;
        int newY = this.bounds.y;
        Point point = this.display.map(this.parent, null, newX, newY);
        this.display.setCursorLocation(point);
        return point;
    }

    Point adjustResizeCursor() {
        if (this.bounds == null) {
            return null;
        }
        int newX = (this.cursorOrientation & 0x4000) != 0 ? this.bounds.x : ((this.cursorOrientation & 0x20000) != 0 ? this.bounds.x + this.bounds.width : this.bounds.x + this.bounds.width / 2);
        int newY = (this.cursorOrientation & 0x80) != 0 ? this.bounds.y : ((this.cursorOrientation & 0x400) != 0 ? this.bounds.y + this.bounds.height : this.bounds.y + this.bounds.height / 2);
        Point point = this.display.map(this.parent, null, newX, newY);
        this.display.setCursorLocation(point);
        if (this.clientCursor == null) {
            int newCursor = 0;
            switch (this.cursorOrientation) {
                case 128: {
                    newCursor = OS.Cursors_SizeNS();
                    break;
                }
                case 1024: {
                    newCursor = OS.Cursors_SizeNS();
                    break;
                }
                case 16384: {
                    newCursor = OS.Cursors_SizeWE();
                    break;
                }
                case 131072: {
                    newCursor = OS.Cursors_SizeWE();
                    break;
                }
                case 16512: {
                    newCursor = OS.Cursors_SizeNWSE();
                    break;
                }
                case 132096: {
                    newCursor = OS.Cursors_SizeNWSE();
                    break;
                }
                case 17408: {
                    newCursor = OS.Cursors_SizeNESW();
                    break;
                }
                case 131200: {
                    newCursor = OS.Cursors_SizeNESW();
                    break;
                }
                default: {
                    newCursor = OS.Cursors_SizeAll();
                }
            }
            OS.FrameworkElement_Cursor(this.canvasHandle, newCursor);
            if (this.resizeCursor != 0) {
                OS.GCHandle_Free(this.resizeCursor);
            }
            this.resizeCursor = newCursor;
        }
        return point;
    }

    static int checkStyle(int style) {
        if ((style & 0x24480) == 0) {
            style |= 0x24480;
        }
        return style;
    }

    public void close() {
        this.checkWidget();
        if (this.frame != 0) {
            OS.DispatcherFrame_Continue(this.frame, false);
        }
    }

    Rectangle computeBounds() {
        if (this.rectangles.length == 0) {
            return null;
        }
        int xMin = this.rectangles[0].x;
        int yMin = this.rectangles[0].y;
        int xMax = this.rectangles[0].x + this.rectangles[0].width;
        int yMax = this.rectangles[0].y + this.rectangles[0].height;
        int i = 1;
        while (i < this.rectangles.length) {
            int rectBottom;
            int rectRight;
            if (this.rectangles[i].x < xMin) {
                xMin = this.rectangles[i].x;
            }
            if (this.rectangles[i].y < yMin) {
                yMin = this.rectangles[i].y;
            }
            if ((rectRight = this.rectangles[i].x + this.rectangles[i].width) > xMax) {
                xMax = rectRight;
            }
            if ((rectBottom = this.rectangles[i].y + this.rectangles[i].height) > yMax) {
                yMax = rectBottom;
            }
            ++i;
        }
        return new Rectangle(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    Rectangle[] computeProportions(Rectangle[] rects) {
        Rectangle[] result = new Rectangle[rects.length];
        this.bounds = this.computeBounds();
        if (this.bounds != null) {
            int i = 0;
            while (i < rects.length) {
                int x = 0;
                int y = 0;
                int width = 0;
                int height = 0;
                if (this.bounds.width != 0) {
                    x = (rects[i].x - this.bounds.x) * 100 / this.bounds.width;
                    width = rects[i].width * 100 / this.bounds.width;
                } else {
                    width = 100;
                }
                if (this.bounds.height != 0) {
                    y = (rects[i].y - this.bounds.y) * 100 / this.bounds.height;
                    height = rects[i].height * 100 / this.bounds.height;
                } else {
                    height = 100;
                }
                result[i] = new Rectangle(x, y, width, height);
                ++i;
            }
        }
        return result;
    }

    void drawRectangles() {
        int brush;
        int stroke;
        Rectangle bounds = this.bounds;
        if (bounds == null) {
            return;
        }
        int children = OS.Panel_Children(this.canvasHandle);
        OS.UIElementCollection_Clear(children);
        if (this.parent != null) {
            Rectangle rect = this.parent.getClientArea();
            rect.intersect(bounds);
            bounds = rect;
            Point pt = this.display.map(this.parent, null, bounds.x, bounds.y);
            OS.Popup_HorizontalOffset(this.handle, pt.x);
            OS.Popup_VerticalOffset(this.handle, pt.y);
        } else {
            OS.Popup_HorizontalOffset(this.handle, bounds.x);
            OS.Popup_VerticalOffset(this.handle, bounds.y);
        }
        OS.FrameworkElement_Width(this.handle, bounds.width);
        OS.FrameworkElement_Height(this.handle, bounds.height);
        if (this.stippled) {
            stroke = 3;
            int pixelFormat = OS.PixelFormats_BlackWhite();
            byte[] byArray = new byte[16];
            byArray[0] = -86;
            byArray[2] = 85;
            byArray[4] = -86;
            byArray[6] = 85;
            byArray[8] = -86;
            byArray[10] = 85;
            byArray[12] = -86;
            byArray[14] = 85;
            byte[] buffer = byArray;
            int image = OS.BitmapSource_Create(8, 8, 96.0, 96.0, pixelFormat, 0, buffer, buffer.length, 2);
            OS.GCHandle_Free(pixelFormat);
            brush = OS.gcnew_ImageBrush(image);
            OS.TileBrush_TileMode(brush, 4);
            OS.TileBrush_Stretch(brush, 1);
            OS.TileBrush_ViewportUnits(brush, 0);
            int rect = OS.gcnew_Rect(0.0, 0.0, OS.BitmapSource_PixelWidth(image), OS.BitmapSource_PixelHeight(image));
            OS.TileBrush_Viewport(brush, rect);
            OS.GCHandle_Free(rect);
            OS.GCHandle_Free(image);
        } else {
            stroke = 1;
            brush = OS.Brushes_Black();
        }
        int i = 0;
        while (i < this.rectangles.length) {
            int child = OS.gcnew_Rectangle();
            OS.UIElementCollection_Add(children, child);
            OS.Shape_StrokeThickness(child, stroke);
            OS.Shape_Stroke(child, brush);
            Rectangle rect = this.rectangles[i];
            OS.Canvas_SetLeft(child, rect.x - bounds.x);
            OS.Canvas_SetTop(child, rect.y - bounds.y);
            OS.FrameworkElement_Width(child, rect.width);
            OS.FrameworkElement_Height(child, rect.height);
            OS.GCHandle_Free(child);
            ++i;
        }
        OS.GCHandle_Free(brush);
        OS.GCHandle_Free(children);
    }

    public Rectangle[] getRectangles() {
        this.checkWidget();
        int length = 0;
        if (this.rectangles != null) {
            length = this.rectangles.length;
        }
        Rectangle[] result = new Rectangle[length];
        int i = 0;
        while (i < length) {
            Rectangle current = this.rectangles[i];
            result[i] = new Rectangle(current.x, current.y, current.width, current.height);
            ++i;
        }
        return result;
    }

    public boolean getStippled() {
        this.checkWidget();
        return this.stippled;
    }

    void HandleKeyUp(int sender, int e) {
        if (this.handle == 0) {
            return;
        }
        if (!this.sendKeyEvent(2, e, false)) {
            return;
        }
    }

    void HandleKeyDown(int sender, int e) {
        if (this.handle == 0) {
            return;
        }
        if (!this.sendKeyEvent(1, e, false)) {
            return;
        }
        boolean ctrlDown = (OS.Keyboard_Modifiers() & 2) != 0;
        int stepSize = ctrlDown ? 1 : 9;
        int key = OS.KeyEventArgs_Key(e);
        int xChange = 0;
        int yChange = 0;
        switch (key) {
            case 13: 
            case 156: {
                this.cancelled = true;
                if (this.frame == 0) break;
                OS.DispatcherFrame_Continue(this.frame, false);
                break;
            }
            case 6: {
                if (this.frame == 0) break;
                OS.DispatcherFrame_Continue(this.frame, false);
                break;
            }
            case 23: {
                xChange = -stepSize;
                break;
            }
            case 25: {
                xChange = stepSize;
                break;
            }
            case 24: {
                yChange = -stepSize;
                break;
            }
            case 26: {
                yChange = stepSize;
            }
        }
        if (xChange != 0 || yChange != 0) {
            Point cursorPos;
            Event event = new Event();
            event.x = this.oldX + xChange;
            event.y = this.oldY + yChange;
            if ((this.style & 0x10) != 0) {
                this.resizeRectangles(xChange, yChange);
                this.sendEvent(11, event);
                if (this.isDisposed()) {
                    this.cancelled = true;
                    if (this.frame != 0) {
                        OS.DispatcherFrame_Continue(this.frame, false);
                    }
                    return;
                }
                this.drawRectangles();
                cursorPos = this.adjustResizeCursor();
            } else {
                this.moveRectangles(xChange, yChange);
                this.sendEvent(10, event);
                if (this.isDisposed()) {
                    this.cancelled = true;
                    if (this.frame != 0) {
                        OS.DispatcherFrame_Continue(this.frame, false);
                    }
                    return;
                }
                this.drawRectangles();
                cursorPos = this.adjustMoveCursor();
            }
            this.oldX = cursorPos.x;
            this.oldY = cursorPos.y;
        }
    }

    void HandleMouseUp(int sender, int e) {
        if (this.handle == 0) {
            return;
        }
        if (!this.sendMouseEvent(4, e, false)) {
            return;
        }
        if (this.frame != 0) {
            OS.DispatcherFrame_Continue(this.frame, false);
        }
    }

    void HandleMouseDown(int sender, int e) {
        if (this.handle == 0) {
            return;
        }
        if (!this.sendMouseEvent(3, e, false)) {
            return;
        }
        if (this.frame != 0) {
            OS.DispatcherFrame_Continue(this.frame, false);
        }
    }

    void HandleMouseMove(int sender, int e) {
        if (this.handle == 0) {
            return;
        }
        if (!this.sendMouseEvent(5, e, false)) {
            return;
        }
        int pointCanvas = OS.MouseEventArgs_GetPosition(e, this.canvasHandle);
        int point = OS.Visual_PointToScreen(this.canvasHandle, pointCanvas);
        int newX = (int)OS.Point_X(point);
        int newY = (int)OS.Point_Y(point);
        OS.GCHandle_Free(pointCanvas);
        OS.GCHandle_Free(point);
        if (newX != this.oldX || newY != this.oldY) {
            Event event = new Event();
            event.x = newX;
            event.y = newY;
            if ((this.style & 0x10) != 0) {
                this.resizeRectangles(newX - this.oldX, newY - this.oldY);
                this.sendEvent(11, event);
                if (this.isDisposed()) {
                    this.cancelled = true;
                    if (this.frame != 0) {
                        OS.DispatcherFrame_Continue(this.frame, false);
                    }
                }
                this.drawRectangles();
                Point cursorPos = this.adjustResizeCursor();
                if (cursorPos != null) {
                    newX = cursorPos.x;
                    newY = cursorPos.y;
                }
            } else {
                this.moveRectangles(newX - this.oldX, newY - this.oldY);
                this.sendEvent(10, event);
                if (this.isDisposed()) {
                    this.cancelled = true;
                    if (this.frame != 0) {
                        OS.DispatcherFrame_Continue(this.frame, false);
                    }
                }
                this.drawRectangles();
            }
            this.oldX = newX;
            this.oldY = newY;
        }
    }

    void moveRectangles(int xChange, int yChange) {
        if (this.bounds == null) {
            return;
        }
        if (xChange < 0 && (this.style & 0x4000) == 0) {
            xChange = 0;
        }
        if (xChange > 0 && (this.style & 0x20000) == 0) {
            xChange = 0;
        }
        if (yChange < 0 && (this.style & 0x80) == 0) {
            yChange = 0;
        }
        if (yChange > 0 && (this.style & 0x400) == 0) {
            yChange = 0;
        }
        if (xChange == 0 && yChange == 0) {
            return;
        }
        this.bounds.x += xChange;
        this.bounds.y += yChange;
        int i = 0;
        while (i < this.rectangles.length) {
            this.rectangles[i].x += xChange;
            this.rectangles[i].y += yChange;
            ++i;
        }
    }

    public boolean open() {
        Point cursorPos;
        boolean mouseDown;
        int hStyle;
        this.checkWidget();
        if (this.rectangles == null) {
            return false;
        }
        if (this.rectangles.length == 0) {
            return false;
        }
        this.cancelled = false;
        int vStyle = this.style & 0x480;
        if (vStyle == 128 || vStyle == 1024) {
            this.cursorOrientation |= vStyle;
        }
        if ((hStyle = this.style & 0x24000) == 16384 || hStyle == 131072) {
            this.cursorOrientation |= hStyle;
        }
        this.jniRef = OS.NewGlobalRef(this);
        if (this.jniRef == 0) {
            this.error(2);
        }
        this.handle = OS.gcnew_Popup();
        if (this.handle == 0) {
            this.error(2);
        }
        OS.Popup_AllowsTransparency(this.handle, true);
        this.canvasHandle = OS.gcnew_Canvas();
        if (this.canvasHandle == 0) {
            this.error(2);
        }
        OS.Popup_Child(this.handle, this.canvasHandle);
        OS.UIElement_IsHitTestVisible(this.canvasHandle, false);
        OS.FrameworkElement_FocusVisualStyle(this.canvasHandle, 0);
        if (this.clientCursor != null) {
            OS.FrameworkElement_Cursor(this.canvasHandle, this.clientCursor.handle);
        }
        this.drawRectangles();
        OS.Popup_IsOpen(this.handle, true);
        OS.UIElement_Focusable(this.canvasHandle, true);
        OS.UIElement_Focus(this.canvasHandle);
        OS.UIElement_CaptureMouse(this.canvasHandle);
        boolean bl = mouseDown = OS.Mouse_LeftButton() == 1;
        if (mouseDown) {
            int pointCanvas = OS.Mouse_GetPosition(this.canvasHandle);
            int point = OS.Visual_PointToScreen(this.canvasHandle, pointCanvas);
            cursorPos = new Point((int)OS.Point_X(point), (int)OS.Point_Y(point));
            OS.GCHandle_Free(pointCanvas);
            OS.GCHandle_Free(point);
        } else {
            cursorPos = (this.style & 0x10) != 0 ? this.adjustResizeCursor() : this.adjustMoveCursor();
        }
        this.oldX = cursorPos.x;
        this.oldY = cursorPos.y;
        int handler = OS.gcnew_KeyEventHandler(this.jniRef, "HandleKeyDown");
        OS.UIElement_KeyDown(this.canvasHandle, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_KeyEventHandler(this.jniRef, "HandleKeyUp");
        OS.UIElement_KeyUp(this.canvasHandle, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_MouseEventHandler(this.jniRef, "HandleMouseMove");
        OS.UIElement_MouseMove(this.canvasHandle, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_MouseButtonEventHandler(this.jniRef, "HandleMouseUp");
        OS.UIElement_MouseUp(this.canvasHandle, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_MouseButtonEventHandler(this.jniRef, "HandleMouseDown");
        OS.UIElement_MouseDown(this.canvasHandle, handler);
        OS.GCHandle_Free(handler);
        this.frame = OS.gcnew_DispatcherFrame();
        OS.Dispatcher_PushFrame(this.frame);
        if (this.resizeCursor != 0) {
            OS.GCHandle_Free(this.resizeCursor);
            this.resizeCursor = 0;
        }
        OS.UIElement_ReleaseMouseCapture(this.canvasHandle);
        OS.Popup_IsOpen(this.handle, false);
        OS.GCHandle_Free(this.canvasHandle);
        OS.GCHandle_Free(this.handle);
        if (this.frame != 0) {
            OS.GCHandle_Free(this.frame);
        }
        OS.DeleteGlobalRef(this.jniRef);
        this.frame = 0;
        this.canvasHandle = 0;
        this.handle = 0;
        this.jniRef = 0;
        return !this.cancelled;
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(11, listener);
        this.eventTable.unhook(10, listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, listener);
        this.eventTable.unhook(1, listener);
    }

    void resizeRectangles(int xChange, int yChange) {
        Rectangle proportion;
        int i;
        if (this.bounds == null) {
            return;
        }
        if (xChange < 0 && (this.style & 0x4000) != 0 && (this.cursorOrientation & 0x20000) == 0) {
            this.cursorOrientation |= 0x4000;
        }
        if (xChange > 0 && (this.style & 0x20000) != 0 && (this.cursorOrientation & 0x4000) == 0) {
            this.cursorOrientation |= 0x20000;
        }
        if (yChange < 0 && (this.style & 0x80) != 0 && (this.cursorOrientation & 0x400) == 0) {
            this.cursorOrientation |= 0x80;
        }
        if (yChange > 0 && (this.style & 0x400) != 0 && (this.cursorOrientation & 0x80) == 0) {
            this.cursorOrientation |= 0x400;
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            if (xChange > this.bounds.width) {
                if ((this.style & 0x20000) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x20000;
                this.cursorOrientation &= 0xFFFFBFFF;
                this.bounds.x += this.bounds.width;
                xChange -= this.bounds.width;
                this.bounds.width = 0;
                if (this.proportions.length > 1) {
                    i = 0;
                    while (i < this.proportions.length) {
                        proportion = this.proportions[i];
                        proportion.x = 100 - proportion.x - proportion.width;
                        ++i;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x20000) != 0 && this.bounds.width < -xChange) {
            if ((this.style & 0x4000) == 0) {
                return;
            }
            this.cursorOrientation |= 0x4000;
            this.cursorOrientation &= 0xFFFDFFFF;
            xChange += this.bounds.width;
            this.bounds.width = 0;
            if (this.proportions.length > 1) {
                i = 0;
                while (i < this.proportions.length) {
                    proportion = this.proportions[i];
                    proportion.x = 100 - proportion.x - proportion.width;
                    ++i;
                }
            }
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            if (yChange > this.bounds.height) {
                if ((this.style & 0x400) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x400;
                this.cursorOrientation &= 0xFFFFFF7F;
                this.bounds.y += this.bounds.height;
                yChange -= this.bounds.height;
                this.bounds.height = 0;
                if (this.proportions.length > 1) {
                    i = 0;
                    while (i < this.proportions.length) {
                        proportion = this.proportions[i];
                        proportion.y = 100 - proportion.y - proportion.height;
                        ++i;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x400) != 0 && this.bounds.height < -yChange) {
            if ((this.style & 0x80) == 0) {
                return;
            }
            this.cursorOrientation |= 0x80;
            this.cursorOrientation &= 0xFFFFFBFF;
            yChange += this.bounds.height;
            this.bounds.height = 0;
            if (this.proportions.length > 1) {
                i = 0;
                while (i < this.proportions.length) {
                    proportion = this.proportions[i];
                    proportion.y = 100 - proportion.y - proportion.height;
                    ++i;
                }
            }
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            this.bounds.x += xChange;
            this.bounds.width -= xChange;
        } else if ((this.cursorOrientation & 0x20000) != 0) {
            this.bounds.width += xChange;
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            this.bounds.y += yChange;
            this.bounds.height -= yChange;
        } else if ((this.cursorOrientation & 0x400) != 0) {
            this.bounds.height += yChange;
        }
        Rectangle[] newRects = new Rectangle[this.rectangles.length];
        int i2 = 0;
        while (i2 < this.rectangles.length) {
            Rectangle proportion2 = this.proportions[i2];
            newRects[i2] = new Rectangle(proportion2.x * this.bounds.width / 100 + this.bounds.x, proportion2.y * this.bounds.height / 100 + this.bounds.y, proportion2.width * this.bounds.width / 100, proportion2.height * this.bounds.height / 100);
            ++i2;
        }
        this.rectangles = newRects;
    }

    public void setCursor(Cursor newCursor) {
        this.checkWidget();
        this.clientCursor = newCursor;
        if (this.canvasHandle != 0) {
            OS.FrameworkElement_Cursor(this.canvasHandle, this.clientCursor != null ? this.clientCursor.handle : 0);
        }
    }

    public void setRectangles(Rectangle[] rectangles) {
        this.checkWidget();
        if (rectangles == null) {
            this.error(4);
        }
        int length = rectangles.length;
        this.rectangles = new Rectangle[length];
        int i = 0;
        while (i < length) {
            Rectangle current = rectangles[i];
            if (current == null) {
                this.error(4);
            }
            this.rectangles[i] = new Rectangle(current.x, current.y, current.width, current.height);
            ++i;
        }
        this.proportions = this.computeProportions(rectangles);
    }

    public void setStippled(boolean stippled) {
        this.checkWidget();
        this.stippled = stippled;
    }
}

