/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Spinner
extends Composite {
    int textHandle;
    int upHandle;
    int downHandle;
    int increment;
    int pageIncrement;
    int digits;
    int max;
    int min;
    int value;
    public static final int LIMIT = Integer.MAX_VALUE;

    public Spinner(Composite parent, int style) {
        super(parent, Spinner.checkStyle(style));
    }

    Control[] _getChildren() {
        return new Control[0];
    }

    static int checkStyle(int style) {
        return style & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    int backgroundHandle() {
        return this.textHandle;
    }

    int backgroundProperty() {
        return OS.Control_BackgroundProperty();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        return super.computeSize(this.handle, wHint, hHint, changed);
    }

    int createArrow(int direction) {
        int geometry = OS.gcnew_StreamGeometry();
        int context = OS.StreamGeometry_Open(geometry);
        int start = 0;
        int point = 0;
        int end = 0;
        switch (direction) {
            case 1024: {
                start = OS.gcnew_Point(0.0, 0.0);
                point = OS.gcnew_Point(3.0, 3.0);
                end = OS.gcnew_Point(6.0, 0.0);
                break;
            }
            case 128: {
                start = OS.gcnew_Point(0.0, 3.0);
                point = OS.gcnew_Point(3.0, 0.0);
                end = OS.gcnew_Point(6.0, 3.0);
            }
        }
        OS.StreamGeometryContext_BeginFigure(context, start, true, true);
        OS.StreamGeometryContext_LineTo(context, point, true, true);
        OS.StreamGeometryContext_LineTo(context, end, true, true);
        OS.StreamGeometryContext_Close(context);
        int path = OS.gcnew_Path();
        OS.Path_Data(path, geometry);
        int padding = OS.gcnew_Thickness(3.0, 0.0, 3.0, 0.0);
        OS.FrameworkElement_Margin(path, padding);
        int brush = OS.Brushes_Black();
        OS.Path_Fill(path, brush);
        OS.FrameworkElement_HorizontalAlignment(path, 1);
        OS.FrameworkElement_VerticalAlignment(path, 1);
        OS.GCHandle_Free(padding);
        OS.GCHandle_Free(start);
        OS.GCHandle_Free(point);
        OS.GCHandle_Free(end);
        OS.GCHandle_Free(brush);
        OS.GCHandle_Free(context);
        OS.GCHandle_Free(geometry);
        return path;
    }

    void createHandle() {
        this.handle = OS.gcnew_Grid();
        if (this.handle == 0) {
            this.error(2);
        }
        int row0 = OS.gcnew_RowDefinition();
        int row1 = OS.gcnew_RowDefinition();
        int rows = OS.Grid_RowDefinitions(this.handle);
        OS.RowDefinitionCollection_Add(rows, row0);
        OS.RowDefinitionCollection_Add(rows, row1);
        int col0 = OS.gcnew_ColumnDefinition();
        int col1 = OS.gcnew_ColumnDefinition();
        int columns = OS.Grid_ColumnDefinitions(this.handle);
        OS.ColumnDefinitionCollection_Add(columns, col0);
        OS.ColumnDefinitionCollection_Add(columns, col1);
        int gridChildren = OS.Panel_Children(this.handle);
        this.textHandle = OS.gcnew_TextBox();
        if (this.textHandle == 0) {
            this.error(2);
        }
        OS.Grid_SetRowSpan(this.textHandle, 2);
        OS.UIElementCollection_Add(gridChildren, this.textHandle);
        if ((this.style & 8) != 0) {
            OS.TextBoxBase_IsReadOnly(this.textHandle, true);
        }
        this.upHandle = OS.gcnew_RepeatButton();
        if (this.upHandle == 0) {
            this.error(2);
        }
        int upArrow = this.createArrow(128);
        OS.ContentControl_Content(this.upHandle, upArrow);
        OS.Grid_SetColumn(this.upHandle, 1);
        OS.UIElementCollection_Add(gridChildren, this.upHandle);
        this.downHandle = OS.gcnew_RepeatButton();
        if (this.downHandle == 0) {
            this.error(2);
        }
        int downArrow = this.createArrow(1024);
        OS.ContentControl_Content(this.downHandle, downArrow);
        OS.Grid_SetColumn(this.downHandle, 1);
        OS.Grid_SetRow(this.downHandle, 1);
        OS.UIElementCollection_Add(gridChildren, this.downHandle);
        int colWidth0 = OS.gcnew_GridLength(10.0, 2);
        OS.ColumnDefinition_Width(col0, colWidth0);
        int colWidth1 = OS.gcnew_GridLength(1.0, 0);
        OS.ColumnDefinition_Width(col1, colWidth1);
        OS.GCHandle_Free(colWidth0);
        OS.GCHandle_Free(colWidth1);
        OS.GCHandle_Free(upArrow);
        OS.GCHandle_Free(downArrow);
        OS.GCHandle_Free(row0);
        OS.GCHandle_Free(row1);
        OS.GCHandle_Free(rows);
        OS.GCHandle_Free(col0);
        OS.GCHandle_Free(col1);
        OS.GCHandle_Free(columns);
        OS.GCHandle_Free(gridChildren);
    }

    void createWidget() {
        super.createWidget();
        this.increment = 1;
        this.pageIncrement = 10;
        this.digits = 0;
        this.max = 100;
        this.value = 0;
        int ptr = this.createDotNetString("0", false);
        OS.TextBox_Text(this.textHandle, ptr);
        OS.GCHandle_Free(ptr);
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    public void copy() {
        this.checkWidget();
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
    }

    public int getDigits() {
        this.checkWidget();
        return this.digits;
    }

    String getDecimalSeparator() {
        return ".";
    }

    public int getIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public int getMaximum() {
        this.checkWidget();
        return this.max;
    }

    public int getMinimum() {
        this.checkWidget();
        return this.min;
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public int getSelection() {
        this.checkWidget();
        return this.value;
    }

    int getSelectionText(boolean[] parseFail) {
        int textPtr = OS.TextBox_Text(this.textHandle);
        String string = Spinner.createJavaString(textPtr);
        OS.GCHandle_Free(textPtr);
        try {
            int value;
            if (this.digits > 0) {
                String decimalSeparator = this.getDecimalSeparator();
                int index = string.indexOf(decimalSeparator);
                if (index != -1) {
                    int startIndex = string.startsWith("+") || string.startsWith("-") ? 1 : 0;
                    String wholePart = startIndex != index ? string.substring(startIndex, index) : "0";
                    String decimalPart = string.substring(index + 1);
                    if (decimalPart.length() > this.digits) {
                        decimalPart = decimalPart.substring(0, this.digits);
                    } else {
                        int i = this.digits - decimalPart.length();
                        int j = 0;
                        while (j < i) {
                            decimalPart = String.valueOf(decimalPart) + "0";
                            ++j;
                        }
                    }
                    int wholeValue = Integer.parseInt(wholePart);
                    int decimalValue = Integer.parseInt(decimalPart);
                    int i = 0;
                    while (i < this.digits) {
                        wholeValue *= 10;
                        ++i;
                    }
                    value = wholeValue + decimalValue;
                    if (string.startsWith("-")) {
                        value = -value;
                    }
                } else {
                    value = Integer.parseInt(string);
                    int i = 0;
                    while (i < this.digits) {
                        value *= 10;
                        ++i;
                    }
                }
            } else {
                value = Integer.parseInt(string);
            }
            if (this.min <= value && value <= this.max) {
                return value;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        parseFail[0] = true;
        return -1;
    }

    public String getText() {
        this.checkWidget();
        int text = OS.TextBox_Text(this.textHandle);
        String string = Spinner.createJavaString(text);
        OS.GCHandle_Free(text);
        return string;
    }

    public int getTextLimit() {
        this.checkWidget();
        return OS.TextBox_MaxLength(this.textHandle);
    }

    void HandleDownClick(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        this.updateSelection(-this.increment);
    }

    void HandleLostKeyboardFocus(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        boolean[] parseFail = new boolean[1];
        this.getSelectionText(parseFail);
        if (parseFail[0]) {
            this.setSelection(this.value, false, true, false);
        }
        super.HandleLostKeyboardFocus(sender, e);
    }

    void HandlePreviewKeyDown(int sender, int e) {
        super.HandlePreviewKeyDown(sender, e);
        if (!this.checkEvent(e)) {
            return;
        }
        int key = OS.KeyEventArgs_Key(e);
        int delta = 0;
        switch (key) {
            case 6: {
                this.postEvent(14);
                break;
            }
            case 26: {
                delta -= this.increment;
                break;
            }
            case 24: {
                delta += this.increment;
                break;
            }
            case 20: {
                delta -= this.pageIncrement;
                break;
            }
            case 19: {
                delta += this.pageIncrement;
            }
        }
        if (delta != 0) {
            this.updateSelection(delta);
        }
    }

    void HandlePreviewTextInput(int sender, int e) {
        super.HandlePreviewTextInput(sender, e);
        if (!this.checkEvent(e)) {
            return;
        }
        int textPtr = OS.TextCompositionEventArgs_Text(e);
        String input = Spinner.createJavaString(textPtr);
        OS.GCHandle_Free(textPtr);
        int start = OS.TextBox_SelectionStart(this.textHandle);
        int end = start + OS.TextBox_SelectionLength(this.textHandle);
        String text = this.verifyText(input, start, end);
        if (text != null && !text.equals(input)) {
            textPtr = this.createDotNetString(text, false);
            OS.TextBox_SelectedText(this.textHandle, textPtr);
            OS.GCHandle_Free(textPtr);
            start = OS.TextBox_SelectionStart(this.textHandle);
            int length = OS.TextBox_SelectionLength(this.textHandle);
            OS.TextBox_Select(this.textHandle, start + length, 0);
            OS.TextBox_SelectionLength(this.textHandle, 0);
            text = null;
        }
        if (text == null) {
            OS.TextCompositionEventArgs_Handled(e, true);
        }
    }

    void HandleTextChanged(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        boolean[] parseFail = new boolean[1];
        int value = this.getSelectionText(parseFail);
        if (!parseFail[0] && this.value != value) {
            this.setSelection(value, true, false, true);
        }
        this.sendEvent(24);
    }

    void HandleUpClick(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        this.updateSelection(this.increment);
    }

    void hookEvents() {
        super.hookEvents();
        int handler = OS.gcnew_TextCompositionEventHandler(this.jniRef, "HandlePreviewTextInput");
        if (handler == 0) {
            this.error(2);
        }
        OS.UIElement_PreviewTextInput(this.textHandle, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_TextChangedEventHandler(this.jniRef, "HandleTextChanged");
        if (handler == 0) {
            this.error(2);
        }
        OS.TextBoxBase_TextChanged(this.textHandle, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_RoutedEventHandler(this.jniRef, "HandleDownClick");
        if (handler == 0) {
            this.error(2);
        }
        OS.ButtonBase_Click(this.downHandle, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_RoutedEventHandler(this.jniRef, "HandleUpClick");
        if (handler == 0) {
            this.error(2);
        }
        OS.ButtonBase_Click(this.upHandle, handler);
        OS.GCHandle_Free(handler);
    }

    public void paste() {
        this.checkWidget();
    }

    void releaseHandle() {
        super.releaseHandle();
        OS.GCHandle_Free(this.textHandle);
        OS.GCHandle_Free(this.upHandle);
        OS.GCHandle_Free(this.downHandle);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener);
    }

    public void setDigits(int value) {
        this.checkWidget();
        if (value < 0) {
            this.error(5);
        }
        this.digits = value;
        this.setSelection(this.value, false, true, false);
    }

    public void setIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        this.increment = value;
    }

    public void setMaximum(int value) {
        this.checkWidget();
        if (value <= this.min) {
            return;
        }
        this.max = value;
        if (this.value > value) {
            this.setSelection(value, true, true, false);
        }
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value >= this.max) {
            return;
        }
        this.min = value;
        if (this.value < value) {
            this.setSelection(value, true, true, false);
        }
    }

    public void setPageIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        this.pageIncrement = value;
    }

    public void setSelection(int value) {
        this.checkWidget();
        value = Math.min(Math.max(this.min, value), this.max);
        this.setSelection(value, true, true, false);
    }

    void setSelection(int value, boolean setPos, boolean setText, boolean notify) {
        if (setPos) {
            this.value = value;
        }
        if (setText) {
            String string;
            if (this.digits == 0) {
                string = String.valueOf(value);
            } else {
                string = String.valueOf(Math.abs(value));
                String decimalSeparator = this.getDecimalSeparator();
                int index = string.length() - this.digits;
                StringBuffer buffer = new StringBuffer();
                if (value < 0) {
                    buffer.append("-");
                }
                if (index > 0) {
                    buffer.append(string.substring(0, index));
                    buffer.append(decimalSeparator);
                    buffer.append(string.substring(index));
                } else {
                    buffer.append("0");
                    buffer.append(decimalSeparator);
                    while (index++ < 0) {
                        buffer.append("0");
                    }
                    buffer.append(string);
                }
                string = buffer.toString();
            }
            int ptr = this.createDotNetString(string, false);
            OS.TextBox_Text(this.textHandle, ptr);
            OS.GCHandle_Free(ptr);
        }
        if (notify) {
            this.postEvent(13);
        }
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            this.error(7);
        }
        OS.TextBox_MaxLength(this.textHandle, limit);
    }

    public void setValues(int selection, int minimum, int maximum, int digits, int increment, int pageIncrement) {
        this.checkWidget();
        if (maximum <= minimum) {
            return;
        }
        if (digits < 0) {
            return;
        }
        if (increment < 1) {
            return;
        }
        if (pageIncrement < 1) {
            return;
        }
        selection = Math.min(Math.max(minimum, selection), maximum);
        this.pageIncrement = pageIncrement;
        this.increment = increment;
        this.digits = digits;
        this.min = minimum;
        this.max = maximum;
        this.setSelection(selection, true, true, false);
    }

    void updateSelection(int delta) {
        boolean[] parseFail = new boolean[1];
        int value = this.getSelectionText(parseFail);
        if (parseFail[0]) {
            value = this.value;
        }
        int newValue = value + delta;
        if ((this.style & 0x40) != 0) {
            if (newValue < this.min) {
                newValue = this.max;
            }
            if (newValue > this.max) {
                newValue = this.min;
            }
        }
        if (value != (newValue = Math.min(Math.max(this.min, newValue), this.max))) {
            this.setSelection(newValue, true, true, true);
        }
    }

    String verifyText(String string, int start, int end) {
        Event event = new Event();
        event.text = string;
        event.start = start;
        event.end = end;
        if (string.length() == 1) {
            event.character = string.charAt(0);
            this.setInputState(event, 1, 0, 0);
        }
        int index = 0;
        if (this.digits > 0) {
            String decimalSeparator = this.getDecimalSeparator();
            index = string.indexOf(decimalSeparator);
            if (index != -1) {
                string = String.valueOf(string.substring(0, index)) + string.substring(index + 1);
            }
            index = 0;
        }
        if (string.length() > 0 && this.min < 0 && string.charAt(0) == '-') {
            ++index;
        }
        while (index < string.length()) {
            if (!Character.isDigit(string.charAt(index))) break;
            ++index;
        }
        event.doit = index == string.length();
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

