/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.wpf.OS;

public final class TextLayout
extends Resource {
    Font font;
    String text;
    String segmentsText;
    int lineSpacing = 0;
    int ascent = -1;
    int descent = -1;
    int alignment;
    int wrapWidth = -1;
    int orientation = 0x2000000;
    int indent;
    boolean justify;
    int[] tabs;
    int[] segments;
    StyleItem[] styles = new StyleItem[2];
    int string;
    int defaultTextProperties;
    int[] runs;
    int[] lines;
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';
    static final int TAB_COUNT = 32;

    public TextLayout(Device device) {
        super(device);
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.text = "";
        this.init();
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    void computeRuns() {
        if (this.lines != null) {
            return;
        }
        int jniRef = OS.NewGlobalRef(this);
        int textSource = OS.gcnew_SWTTextSource(jniRef);
        int formatter = OS.TextFormatter_Create();
        Font font = this.font != null ? this.font : this.device.systemFont;
        this.segmentsText = this.getSegmentsText();
        int length = this.segmentsText.length();
        char[] buffer = new char[length];
        this.segmentsText.getChars(0, length, buffer, 0);
        this.string = OS.gcnew_String(buffer, 0, length);
        int culture = OS.CultureInfo_CurrentUICulture();
        this.defaultTextProperties = OS.gcnew_SWTTextRunProperties(font.handle, font.size, font.size, 0, 0, 0, 3, culture);
        int i = 0;
        while (i < this.styles.length) {
            StyleItem run = this.styles[i];
            TextStyle style = run.style;
            if (style != null) {
                Font styleFont = style.font != null ? style.font : font;
                int fg = 0;
                if (style.foreground != null) {
                    fg = OS.gcnew_SolidColorBrush(style.foreground.handle);
                }
                int bg = 0;
                if (style.background != null) {
                    bg = OS.gcnew_SolidColorBrush(style.background.handle);
                }
                int decorations = 0;
                if (style.strikeout || style.underline) {
                    decorations = OS.gcnew_TextDecorationCollection(2);
                    if (style.strikeout) {
                        int pen = 0;
                        if (style.strikeoutColor != null) {
                            int color = style.strikeoutColor.handle;
                            int brush = OS.gcnew_SolidColorBrush(color);
                            pen = OS.gcnew_Pen(brush, 1.0);
                            OS.GCHandle_Free(brush);
                        }
                        int strikeout = OS.gcnew_TextDecoration(2, pen, 0.0, 0, 0);
                        OS.TextDecorationCollection_Add(decorations, strikeout);
                        OS.GCHandle_Free(strikeout);
                        if (pen != 0) {
                            OS.GCHandle_Free(pen);
                        }
                    }
                    if (style.underline) {
                        Color color = this.device.getSystemColor(2);
                        if (style.underlineColor != null) {
                            color = style.underlineColor;
                        } else if (style.foreground != null) {
                            color = style.foreground;
                        }
                        int brush = OS.gcnew_SolidColorBrush(color.handle);
                        int pen = OS.gcnew_Pen(brush, 1.0);
                        OS.GCHandle_Free(brush);
                        switch (style.underlineStyle) {
                            case 2: 
                            case 3: {
                                int dashStyle = OS.DashStyles_Dash();
                                OS.Pen_DashStyle(pen, dashStyle);
                                int underline = OS.gcnew_TextDecoration(0, pen, 0.0, 0, 0);
                                OS.TextDecorationCollection_Add(decorations, underline);
                                OS.GCHandle_Free(underline);
                                OS.GCHandle_Free(dashStyle);
                                break;
                            }
                            case 1: {
                                int underline = OS.gcnew_TextDecoration(0, pen, 1.0, 0, 0);
                                OS.TextDecorationCollection_Add(decorations, underline);
                                OS.GCHandle_Free(underline);
                            }
                            case 0: {
                                int underline = OS.gcnew_TextDecoration(0, pen, 0.0, 0, 0);
                                OS.TextDecorationCollection_Add(decorations, underline);
                                OS.GCHandle_Free(underline);
                            }
                        }
                        if (pen != 0) {
                            OS.GCHandle_Free(pen);
                        }
                    }
                }
                run.textProperties = OS.gcnew_SWTTextRunProperties(styleFont.handle, styleFont.size, styleFont.size, decorations, fg, bg, 3, culture);
                if (fg != 0) {
                    OS.GCHandle_Free(fg);
                }
                if (bg != 0) {
                    OS.GCHandle_Free(bg);
                }
                if (decorations != 0) {
                    OS.GCHandle_Free(decorations);
                }
            }
            ++i;
        }
        int textAlignment = 0;
        if (this.justify) {
            textAlignment = 3;
        } else {
            switch (this.alignment) {
                case 0x1000000: {
                    textAlignment = 2;
                    break;
                }
                case 131072: {
                    textAlignment = 1;
                }
            }
        }
        int flowDirection = (this.orientation & 0x4000000) != 0 ? 1 : 0;
        int textWrapping = this.wrapWidth != -1 ? 2 : 1;
        int tabCollection = 0;
        if (this.tabs != null) {
            int position = 0;
            int tabLength = Math.max(this.tabs.length, 32);
            tabCollection = OS.gcnew_TextTabPropertiesCollection(tabLength);
            int i2 = 0;
            while (i2 < this.tabs.length) {
                position = this.tabs[i2];
                int tab = OS.gcnew_TextTabProperties(0, position, 0, 0);
                OS.TextTabPropertiesCollection_Add(tabCollection, tab);
                OS.GCHandle_Free(tab);
                ++i2;
            }
            int width = this.tabs[this.tabs.length - 1];
            if (this.tabs.length > 1) {
                width -= this.tabs[this.tabs.length - 2];
            }
            if (width > 0) {
                while (i2 < length) {
                    int tab = OS.gcnew_TextTabProperties(0, position += width, 0, 0);
                    OS.TextTabPropertiesCollection_Add(tabCollection, tab);
                    OS.GCHandle_Free(tab);
                    ++i2;
                }
            }
        }
        int paragraphProperties = OS.gcnew_SWTTextParagraphProperties(flowDirection, textAlignment, false, this.defaultTextProperties, textWrapping, 0.0, 0.0, tabCollection);
        int firstParagraphProperties = OS.gcnew_SWTTextParagraphProperties(flowDirection, textAlignment, true, this.defaultTextProperties, textWrapping, 0.0, this.indent, tabCollection);
        int offset = 0;
        int index = 0;
        this.lines = new int[4];
        int lineBreak = 0;
        while (offset < length || offset == 0) {
            char ch;
            boolean firstLine = offset == 0 || (ch = this.segmentsText.charAt(offset - 1)) == '\r' || ch == '\n';
            int paragraphProps = firstLine ? firstParagraphProperties : paragraphProperties;
            int textLine = OS.TextFormatter_FormatLine(formatter, textSource, offset, this.wrapWidth != -1 ? this.wrapWidth : 0, paragraphProps, lineBreak);
            offset += OS.TextLine_Length(textLine);
            lineBreak = OS.TextLine_GetTextLineBreak(textLine);
            if (index == this.lines.length) {
                int[] tmpLines = new int[index + 4];
                System.arraycopy(this.lines, 0, tmpLines, 0, index);
                this.lines = tmpLines;
            }
            this.lines[index++] = textLine;
        }
        if (index != this.lines.length) {
            int[] tmpLines = new int[index];
            System.arraycopy(this.lines, 0, tmpLines, 0, index);
            this.lines = tmpLines;
        }
        if (tabCollection != 0) {
            OS.GCHandle_Free(tabCollection);
        }
        OS.GCHandle_Free(paragraphProperties);
        OS.GCHandle_Free(firstParagraphProperties);
        OS.GCHandle_Free(culture);
        OS.GCHandle_Free(formatter);
        OS.GCHandle_Free(textSource);
        OS.DeleteGlobalRef(jniRef);
    }

    void destroy() {
        this.freeRuns();
        this.font = null;
        this.text = null;
        this.segmentsText = null;
        this.tabs = null;
        this.styles = null;
    }

    public void draw(GC gc, int x, int y) {
        this.draw(gc, x, y, -1, -1, null, null);
    }

    public void draw(GC gc, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground) {
        this.draw(gc, x, y, selectionStart, selectionEnd, selectionForeground, selectionBackground, 0);
    }

    public void draw(GC gc, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground, int flags) {
        int length;
        this.checkLayout();
        this.computeRuns();
        if (gc == null) {
            SWT.error(4);
        }
        if (gc.isDisposed()) {
            SWT.error(5);
        }
        if (selectionForeground != null && selectionForeground.isDisposed()) {
            SWT.error(5);
        }
        if (selectionBackground != null && selectionBackground.isDisposed()) {
            SWT.error(5);
        }
        if ((length = this.text.length()) == 0 && flags == 0) {
            return;
        }
        gc.checkGC(1);
        int fg = OS.Pen_Brush(gc.data.pen);
        OS.SWTTextRunProperties_ForegroundBrush(this.defaultTextProperties, fg);
        int i = 0;
        while (i < this.styles.length) {
            StyleItem run = this.styles[i];
            if (run.style != null && run.style.foreground == null) {
                OS.SWTTextRunProperties_ForegroundBrush(run.textProperties, fg);
            }
            ++i;
        }
        int drawingContext = gc.handle;
        boolean hasSelection = selectionStart <= selectionEnd && selectionStart != -1 && selectionEnd != -1;
        int selBrush = 0;
        int selGeometry = 0;
        int geometries = 0;
        if (hasSelection || (flags & 0x100000) != 0) {
            selectionStart = Math.min(Math.max(0, selectionStart), length - 1);
            selectionEnd = Math.min(Math.max(0, selectionEnd), length - 1);
            selectionStart = this.translateOffset(selectionStart);
            selectionEnd = this.translateOffset(selectionEnd);
            selBrush = selectionBackground != null ? OS.gcnew_SolidColorBrush(selectionBackground.handle) : OS.Brushes_LightSkyBlue();
            selGeometry = OS.gcnew_GeometryGroup();
            geometries = OS.GeometryGroup_Children(selGeometry);
        }
        int lineStart = 0;
        int lineEnd = 0;
        double drawY = y;
        int i2 = 0;
        while (i2 < this.lines.length) {
            boolean partialSelection;
            double nextDrawY;
            int line = this.lines[i2];
            if (line == 0) break;
            lineStart = lineEnd;
            lineEnd = lineStart + OS.TextLine_Length(line);
            double selY = drawY;
            int lineHeight = (int)OS.TextLine_Height(line);
            if (this.ascent != -1 && this.descent != -1) {
                lineHeight = Math.max(lineHeight, this.ascent + this.descent);
                nextDrawY = drawY + (double)lineHeight + (double)this.lineSpacing;
                int baseline = (int)OS.TextLine_Baseline(line);
                if (this.ascent > baseline) {
                    drawY += (double)(this.ascent - baseline);
                }
            } else {
                nextDrawY = drawY + (double)lineHeight + (double)this.lineSpacing;
            }
            int point = OS.gcnew_Point(x, drawY);
            OS.TextLine_Draw(line, drawingContext, point, 0);
            OS.GCHandle_Free(point);
            boolean fullSelection = selectionStart <= lineStart && selectionEnd >= lineEnd;
            boolean bl = partialSelection = selectionStart <= lineEnd && lineStart <= selectionEnd;
            if (flags != 0 && (hasSelection || (flags & 0x100000) != 0)) {
                boolean extent = false;
                if (i2 == this.lines.length - 1 && (flags & 0x100000) != 0) {
                    extent = true;
                } else {
                    int breakLength = OS.TextLine_NewlineLength(line);
                    if (breakLength != 0) {
                        if (selectionStart <= lineEnd && lineEnd <= selectionEnd) {
                            extent = true;
                        }
                    } else if (selectionStart <= lineEnd && lineEnd < selectionEnd && (flags & 0x10000) != 0) {
                        extent = true;
                    }
                }
                if (extent) {
                    int extentWidth = (flags & 0x10000) != 0 ? 0x7FFFFFF : lineHeight / 3;
                    int textRect = OS.gcnew_Rect(OS.TextLine_WidthIncludingTrailingWhitespace(line) + (double)x, selY, extentWidth, lineHeight);
                    int geometry = OS.gcnew_RectangleGeometry(textRect);
                    OS.GeometryCollection_Add(geometries, geometry);
                    OS.GCHandle_Free(geometry);
                    OS.GCHandle_Free(textRect);
                }
            }
            if (hasSelection && (fullSelection || partialSelection)) {
                int selLineEnd;
                int selLineStart = Math.max(lineStart, selectionStart);
                int rects = OS.TextLine_GetTextBounds(line, selLineStart, (selLineEnd = Math.min(lineEnd, selectionEnd)) - selLineStart + 1);
                if (rects != 0) {
                    int enumerator = OS.TextBoundsCollection_GetEnumerator(rects);
                    while (OS.IEnumerator_MoveNext(enumerator)) {
                        int bounds = OS.TextBoundsCollection_Current(enumerator);
                        int textRect = OS.TextBounds_Rectangle(bounds);
                        OS.Rect_X(textRect, OS.Rect_X(textRect) + (double)x);
                        OS.Rect_Y(textRect, selY);
                        OS.Rect_Height(textRect, lineHeight);
                        int geometry = OS.gcnew_RectangleGeometry(textRect);
                        OS.GeometryCollection_Add(geometries, geometry);
                        OS.GCHandle_Free(geometry);
                        OS.GCHandle_Free(textRect);
                        OS.GCHandle_Free(bounds);
                    }
                    OS.GCHandle_Free(enumerator);
                }
                OS.GCHandle_Free(rects);
            }
            drawY = nextDrawY;
            ++i2;
        }
        i2 = 0;
        while (i2 < this.styles.length - 1) {
            StyleItem run = this.styles[i2];
            TextStyle style = run.style;
            if (!(style == null || style.borderStyle == 0 || i2 + 1 < this.styles.length && style.isAdherentBorder(this.styles[i2 + 1].style))) {
                int start = run.start;
                int end = this.styles[i2 + 1].start - 1;
                int j = i2;
                while (j > 0 && style.isAdherentBorder(this.styles[j - 1].style)) {
                    start = this.styles[j - 1].start;
                    --j;
                }
                Color color = style.borderColor;
                if (color == null) {
                    color = style.foreground;
                }
                if (color == null) {
                    color = gc.getForeground();
                }
                int brush = OS.gcnew_SolidColorBrush(color.handle);
                int pen = OS.gcnew_Pen(brush, 1.0);
                OS.GCHandle_Free(brush);
                int dashStyle = 0;
                switch (style.borderStyle) {
                    case 1: {
                        dashStyle = OS.DashStyles_Solid();
                        break;
                    }
                    case 4: {
                        dashStyle = OS.DashStyles_Dot();
                        break;
                    }
                    case 2: {
                        dashStyle = OS.DashStyles_Dash();
                    }
                }
                OS.Pen_DashStyle(pen, dashStyle);
                if (dashStyle != 0) {
                    OS.GCHandle_Free(dashStyle);
                }
                int lineY = y;
                lineEnd = 0;
                lineStart = 0;
                int j2 = 0;
                while (j2 < this.lines.length) {
                    lineStart = lineEnd;
                    int lineLength = OS.TextLine_Length(this.lines[j2]);
                    if (start < (lineEnd = lineStart + lineLength)) {
                        int rangLength;
                        if (end < lineStart) break;
                        int rangeStart = Math.max(start, lineStart);
                        int rects = OS.TextLine_GetTextBounds(this.lines[j2], rangeStart, rangLength = Math.min(end, lineEnd) - rangeStart + 1);
                        if (rects != 0) {
                            int enumerator = OS.TextBoundsCollection_GetEnumerator(rects);
                            while (OS.IEnumerator_MoveNext(enumerator)) {
                                int bounds = OS.TextBoundsCollection_Current(enumerator);
                                int textRect = OS.TextBounds_Rectangle(bounds);
                                OS.Rect_Y(textRect, OS.Rect_Y(textRect) + (double)lineY);
                                OS.Rect_X(textRect, OS.Rect_X(textRect) + (double)x);
                                OS.Rect_Width(textRect, OS.Rect_Width(textRect) - 1.0);
                                OS.Rect_Height(textRect, OS.Rect_Height(textRect) - 1.0);
                                OS.DrawingContext_DrawRectangle(drawingContext, 0, pen, textRect);
                                OS.GCHandle_Free(textRect);
                                OS.GCHandle_Free(bounds);
                            }
                            OS.GCHandle_Free(enumerator);
                        }
                        OS.GCHandle_Free(rects);
                    }
                    int lineHeight = (int)OS.TextLine_Height(this.lines[j2]);
                    if (this.ascent != -1 && this.descent != -1) {
                        lineHeight = Math.max(lineHeight, this.ascent + this.descent);
                    }
                    lineY += lineHeight + this.lineSpacing;
                    ++j2;
                }
                OS.GCHandle_Free(pen);
            }
            ++i2;
        }
        if (selGeometry != 0) {
            OS.DrawingContext_PushOpacity(drawingContext, 0.4);
            OS.DrawingContext_DrawGeometry(drawingContext, selBrush, 0, selGeometry);
            OS.DrawingContext_Pop(drawingContext);
            OS.GCHandle_Free(geometries);
            OS.GCHandle_Free(selGeometry);
        }
        if (selBrush != 0) {
            OS.GCHandle_Free(selBrush);
        }
        OS.GCHandle_Free(fg);
    }

    void freeRuns() {
        if (this.lines == null) {
            return;
        }
        int i = 0;
        while (i < this.lines.length) {
            if (this.lines[i] != 0) {
                OS.GCHandle_Free(this.lines[i]);
            }
            ++i;
        }
        this.lines = null;
        if (this.runs != null) {
            i = 0;
            while (i < this.runs.length) {
                if (this.runs[i] == 0) break;
                OS.GCHandle_Free(this.runs[i]);
                ++i;
            }
            this.runs = null;
        }
        i = 0;
        while (i < this.styles.length) {
            this.styles[i].free();
            ++i;
        }
        if (this.defaultTextProperties != 0) {
            OS.GCHandle_Free(this.defaultTextProperties);
        }
        if (this.string != 0) {
            OS.GCHandle_Free(this.string);
        }
        this.string = 0;
        this.defaultTextProperties = 0;
        this.segmentsText = null;
    }

    public int getAlignment() {
        this.checkLayout();
        return this.alignment;
    }

    public int getAscent() {
        this.checkLayout();
        return this.ascent;
    }

    public Rectangle getBounds() {
        this.checkLayout();
        this.computeRuns();
        double width = 0.0;
        double height = 0.0;
        int line = 0;
        while (line < this.lines.length) {
            if (this.wrapWidth == -1) {
                width = Math.max(width, OS.TextLine_WidthIncludingTrailingWhitespace(this.lines[line]));
            }
            int lineHeight = (int)OS.TextLine_Height(this.lines[line]);
            if (this.ascent != -1 && this.descent != -1) {
                lineHeight = Math.max(lineHeight, this.ascent + this.descent);
            }
            height += (double)(lineHeight + this.lineSpacing);
            ++line;
        }
        if (this.wrapWidth != -1) {
            width = this.wrapWidth;
        }
        return new Rectangle(0, 0, (int)width, (int)height);
    }

    public Rectangle getBounds(int start, int end) {
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (length == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (start > end) {
            return new Rectangle(0, 0, 0, 0);
        }
        start = Math.min(Math.max(0, start), length - 1);
        end = Math.min(Math.max(0, end), length - 1);
        start = this.translateOffset(start);
        end = this.translateOffset(end);
        int lineStart = 0;
        int lineEnd = 0;
        int lineY = 0;
        int rect = 0;
        int i = 0;
        while (i < this.lines.length) {
            lineStart = lineEnd;
            int lineLength = OS.TextLine_Length(this.lines[i]);
            if (start < (lineEnd = lineStart + lineLength)) {
                int rangLength;
                if (end < lineStart) break;
                int rangeStart = Math.max(start, lineStart);
                int rects = OS.TextLine_GetTextBounds(this.lines[i], rangeStart, rangLength = Math.min(end, lineEnd) - rangeStart + 1);
                if (rects != 0) {
                    int enumerator = OS.TextBoundsCollection_GetEnumerator(rects);
                    while (OS.IEnumerator_MoveNext(enumerator)) {
                        int bounds = OS.TextBoundsCollection_Current(enumerator);
                        int textRect = OS.TextBounds_Rectangle(bounds);
                        OS.Rect_Y(textRect, OS.Rect_Y(textRect) + (double)lineY);
                        if (rect != 0) {
                            OS.Rect_Union(rect, textRect);
                            OS.GCHandle_Free(textRect);
                        } else {
                            rect = textRect;
                        }
                        OS.GCHandle_Free(bounds);
                    }
                    OS.GCHandle_Free(enumerator);
                }
                OS.GCHandle_Free(rects);
            }
            int lineHeight = (int)OS.TextLine_Height(this.lines[i]);
            if (this.ascent != -1 && this.descent != -1) {
                lineHeight = Math.max(lineHeight, this.ascent + this.descent);
            }
            lineY += lineHeight + this.lineSpacing;
            ++i;
        }
        if (rect == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle result = new Rectangle((int)OS.Rect_X(rect), (int)OS.Rect_Y(rect), (int)OS.Rect_Width(rect), (int)OS.Rect_Height(rect));
        OS.GCHandle_Free(rect);
        return result;
    }

    public int getDescent() {
        this.checkLayout();
        return this.descent;
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    public int getIndent() {
        this.checkLayout();
        return this.indent;
    }

    public boolean getJustify() {
        this.checkLayout();
        return this.justify;
    }

    public int getLevel(int offset) {
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(6);
        }
        offset = this.translateOffset(offset);
        int level = (this.orientation & 0x4000000) != 0 ? 1 : 0;
        int i = 0;
        while (i < this.lines.length) {
            int lineLength = OS.TextLine_Length(this.lines[i]);
            if (lineLength > offset) {
                int runs = OS.TextLine_GetIndexedGlyphRuns(this.lines[i]);
                int enumerator = OS.IndexedGlyphRunCollection_GetEnumerator(runs);
                while (OS.IEnumerator_MoveNext(enumerator)) {
                    int indexedGlyphRun = OS.IndexedGlyphRunCollection_Current(enumerator);
                    int rangeStart = OS.IndexedGlyphRun_TextSourceCharacterIndex(indexedGlyphRun);
                    int rangeEnd = rangeStart + OS.IndexedGlyphRun_TextSourceLength(indexedGlyphRun);
                    int glyphRun = OS.IndexedGlyphRun_GlyphRun(indexedGlyphRun);
                    int bidiLevel = OS.GlyphRun_BidiLevel(glyphRun);
                    OS.GCHandle_Free(glyphRun);
                    OS.GCHandle_Free(indexedGlyphRun);
                    if (rangeStart > offset || offset >= rangeEnd) continue;
                    level = bidiLevel;
                    break;
                }
                OS.GCHandle_Free(enumerator);
                OS.GCHandle_Free(runs);
                break;
            }
            ++i;
        }
        return level;
    }

    public Rectangle getLineBounds(int lineIndex) {
        char ch;
        boolean firstLine;
        this.checkLayout();
        this.computeRuns();
        if (lineIndex < 0 || lineIndex >= this.runs.length) {
            SWT.error(6);
        }
        int offset = 0;
        double y = 0.0;
        int i = 0;
        while (i < lineIndex) {
            offset += OS.TextLine_Length(this.lines[i]);
            int lineHeight = (int)OS.TextLine_Height(this.lines[i]);
            if (this.ascent != -1 && this.descent != -1) {
                lineHeight = Math.max(lineHeight, this.ascent + this.descent);
            }
            y += (double)(lineHeight + this.lineSpacing);
            ++i;
        }
        int line = this.lines[lineIndex];
        double x = OS.TextLine_Start(line);
        double width = OS.TextLine_WidthIncludingTrailingWhitespace(line);
        double height = OS.TextLine_Height(line);
        if (this.ascent != -1 && this.descent != -1) {
            height = Math.max(height, (double)(this.ascent + this.descent));
        }
        boolean bl = firstLine = offset == 0 || (ch = this.segmentsText.charAt(offset - 1)) == '\r' || ch == '\n';
        if (firstLine) {
            x += (double)this.indent;
            width -= (double)this.indent;
        }
        return new Rectangle((int)x, (int)y, (int)width, (int)height);
    }

    public int getLineCount() {
        this.checkLayout();
        this.computeRuns();
        return this.lines.length;
    }

    public int getLineIndex(int offset) {
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(6);
        }
        offset = this.translateOffset(offset);
        int start = 0;
        int line = 0;
        while (line < this.lines.length) {
            int lineLength = OS.TextLine_Length(this.lines[line]);
            if (start + lineLength > offset) {
                return line;
            }
            start += lineLength;
            ++line;
        }
        return this.lines.length - 1;
    }

    public FontMetrics getLineMetrics(int lineIndex) {
        double baseline;
        double height;
        int length;
        this.checkLayout();
        this.computeRuns();
        if (lineIndex < 0 || lineIndex >= this.runs.length) {
            SWT.error(6);
        }
        if ((length = this.text.length()) == 0) {
            Font font = this.font != null ? this.font : this.device.systemFont;
            char[] cArray = new char[2];
            cArray[0] = 32;
            int str = OS.gcnew_String(cArray);
            int culture = OS.CultureInfo_CurrentUICulture();
            int direction = (this.orientation & 0x4000000) != 0 ? 1 : 0;
            int brush = OS.Brushes_White();
            int text = OS.gcnew_FormattedText(str, culture, direction, font.handle, font.size, brush);
            height = OS.FormattedText_Height(text);
            baseline = OS.FormattedText_Baseline(text);
            OS.GCHandle_Free(text);
            OS.GCHandle_Free(str);
            OS.GCHandle_Free(brush);
            OS.GCHandle_Free(culture);
        } else {
            baseline = OS.TextLine_Baseline(this.lines[lineIndex]);
            height = OS.TextLine_Height(this.lines[lineIndex]);
            if (this.ascent != -1 && this.descent != -1) {
                baseline = Math.max(baseline, (double)this.ascent);
                height = Math.max(height, (double)(this.ascent + this.descent));
            }
        }
        return FontMetrics.wpf_new((int)baseline, (int)height - (int)baseline, 0, 0, (int)height);
    }

    public int[] getLineOffsets() {
        this.checkLayout();
        this.computeRuns();
        int start = 0;
        int[] offsets = new int[this.lines.length + 1];
        int i = 0;
        while (i < this.lines.length) {
            offsets[i + 1] = this.untranslateOffset(start += OS.TextLine_Length(this.lines[i]));
            ++i;
        }
        return offsets;
    }

    public Point getLocation(int offset, boolean trailing) {
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(6);
        }
        offset = this.translateOffset(offset);
        double y = 0.0;
        int start = 0;
        int line = 0;
        while (line < this.lines.length) {
            int lineLength = OS.TextLine_Length(this.lines[line]);
            if (start + lineLength > offset) break;
            start += lineLength;
            int lineHeight = (int)OS.TextLine_Height(this.lines[line]);
            if (this.ascent != -1 && this.descent != -1) {
                lineHeight = Math.max(lineHeight, this.ascent + this.descent);
            }
            y += (double)(lineHeight + this.lineSpacing);
            ++line;
        }
        int characterHit = OS.gcnew_CharacterHit(offset, trailing ? 1 : 0);
        double x = OS.TextLine_GetDistanceFromCharacterHit(this.lines[line], characterHit);
        OS.GCHandle_Free(characterHit);
        return new Point((int)x, (int)y);
    }

    public int getNextOffset(int offset, int movement) {
        this.checkLayout();
        return this._getOffset(offset, movement, true);
    }

    int _getOffset(int offset, int movement, boolean forward) {
        int step;
        this.computeRuns();
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(6);
        }
        if (forward && offset == length) {
            return length;
        }
        if (!forward && offset == 0) {
            return 0;
        }
        int n = step = forward ? 1 : -1;
        if ((movement & 1) != 0) {
            return offset + step;
        }
        offset = this.translateOffset(offset);
        int lineStart = 0;
        int lineIndex = 0;
        while (lineIndex < this.lines.length) {
            int lineLength = OS.TextLine_Length(this.lines[lineIndex]);
            if (lineStart + lineLength > offset) break;
            lineStart += lineLength;
            ++lineIndex;
        }
        int line = this.lines[lineIndex];
        int lineLength = OS.TextLine_Length(line);
        int lineBreak = OS.TextLine_NewlineLength(line);
        block6: while (lineStart <= offset && offset <= lineStart + lineLength) {
            int lineEnd;
            int characterHit = OS.gcnew_CharacterHit(offset, 0);
            int resultCharHit = forward ? OS.TextLine_GetNextCaretCharacterHit(line, characterHit) : OS.TextLine_GetPreviousCaretCharacterHit(line, characterHit);
            int newOffset = OS.CharacterHit_FirstCharacterIndex(resultCharHit);
            int trailing = OS.CharacterHit_TrailingLength(resultCharHit);
            OS.GCHandle_Free(resultCharHit);
            OS.GCHandle_Free(characterHit);
            if (forward) {
                if (newOffset + trailing >= lineStart + lineLength - lineBreak) {
                    lineEnd = lineStart + lineLength;
                    if (trailing != 0) {
                        lineEnd -= lineBreak;
                    }
                    return this.untranslateOffset(Math.min(length, lineEnd));
                }
            } else if (newOffset + trailing == lineStart) {
                if (lineIndex == 0) {
                    return 0;
                }
                lineEnd = 0;
                if (newOffset + trailing == offset) {
                    lineEnd = OS.TextLine_NewlineLength(this.lines[lineIndex - 1]);
                }
                return this.untranslateOffset(Math.max(0, newOffset + trailing - lineEnd));
            }
            offset = newOffset + trailing;
            switch (movement) {
                case 2: {
                    return this.untranslateOffset(offset);
                }
                case 4: 
                case 16: {
                    boolean previousLetterOrDigit;
                    boolean letterOrDigit;
                    if (offset <= 0 || (letterOrDigit = Compatibility.isLetterOrDigit(this.segmentsText.charAt(offset))) == (previousLetterOrDigit = Compatibility.isLetterOrDigit(this.segmentsText.charAt(offset - 1))) && letterOrDigit || Compatibility.isWhitespace(this.segmentsText.charAt(offset))) continue block6;
                    return this.untranslateOffset(offset);
                }
                case 8: {
                    if (offset <= 0) break;
                    boolean isLetterOrDigit = Compatibility.isLetterOrDigit(this.segmentsText.charAt(offset));
                    boolean previousLetterOrDigit = Compatibility.isLetterOrDigit(this.segmentsText.charAt(offset - 1));
                    if (isLetterOrDigit || !previousLetterOrDigit) continue block6;
                    return this.untranslateOffset(offset);
                }
            }
        }
        return forward ? length : 0;
    }

    public int getOffset(Point point, int[] trailing) {
        this.checkLayout();
        if (point == null) {
            SWT.error(4);
        }
        return this.getOffset(point.x, point.y, trailing);
    }

    public int getOffset(int x, int y, int[] trailing) {
        this.checkLayout();
        this.computeRuns();
        if (trailing != null && trailing.length < 1) {
            SWT.error(5);
        }
        double lineY = 0.0;
        int line = 0;
        while (line < this.lines.length) {
            double lineHeight = OS.TextLine_Length(this.lines[line]);
            if (lineY + lineHeight > (double)y) break;
            lineY += lineHeight;
            ++line;
        }
        if (line >= this.lines.length) {
            line = this.lines.length - 1;
        }
        int characterHit = OS.TextLine_GetCharacterHitFromDistance(this.lines[line], x);
        int offset = OS.CharacterHit_FirstCharacterIndex(characterHit);
        if (trailing != null) {
            trailing[0] = OS.CharacterHit_TrailingLength(characterHit);
        }
        OS.GCHandle_Free(characterHit);
        return this.untranslateOffset(offset);
    }

    public int getOrientation() {
        this.checkLayout();
        return this.orientation;
    }

    public int getPreviousOffset(int offset, int movement) {
        this.checkLayout();
        return this._getOffset(offset, movement, false);
    }

    public int[] getRanges() {
        this.checkLayout();
        int[] result = new int[this.styles.length * 2];
        int count = 0;
        int i = 0;
        while (i < this.styles.length - 1) {
            if (this.styles[i].style != null) {
                result[count++] = this.styles[i].start;
                result[count++] = this.styles[i + 1].start - 1;
            }
            ++i;
        }
        if (count != result.length) {
            int[] newResult = new int[count];
            System.arraycopy(result, 0, newResult, 0, count);
            result = newResult;
        }
        return result;
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    String getSegmentsText() {
        if (this.segments == null) {
            return this.text;
        }
        int nSegments = this.segments.length;
        if (nSegments <= 1) {
            return this.text;
        }
        int length = this.text.length();
        if (length == 0) {
            return this.text;
        }
        if (nSegments == 2 && this.segments[0] == 0 && this.segments[1] == length) {
            return this.text;
        }
        char[] oldChars = new char[length];
        this.text.getChars(0, length, oldChars, 0);
        char[] newChars = new char[length + nSegments];
        int charCount = 0;
        int segmentCount = 0;
        int separator = this.orientation == 0x4000000 ? 8207 : 8206;
        while (charCount < length) {
            if (segmentCount < nSegments && charCount == this.segments[segmentCount]) {
                newChars[charCount + segmentCount++] = separator;
                continue;
            }
            newChars[charCount + segmentCount] = oldChars[charCount++];
        }
        if (segmentCount < nSegments) {
            this.segments[segmentCount] = charCount;
            newChars[charCount + segmentCount++] = separator;
        }
        return new String(newChars, 0, Math.min(charCount + segmentCount, newChars.length));
    }

    public int getSpacing() {
        this.checkLayout();
        return this.lineSpacing;
    }

    public TextStyle getStyle(int offset) {
        this.checkLayout();
        int length = this.text.length();
        if (offset < 0 || offset >= length) {
            SWT.error(6);
        }
        int i = 1;
        while (i < this.styles.length) {
            if (this.styles[i].start > offset) {
                return this.styles[i - 1].style;
            }
            ++i;
        }
        return null;
    }

    public TextStyle[] getStyles() {
        this.checkLayout();
        TextStyle[] result = new TextStyle[this.styles.length];
        int count = 0;
        int i = 0;
        while (i < this.styles.length) {
            if (this.styles[i].style != null) {
                result[count++] = this.styles[i].style;
            }
            ++i;
        }
        if (count != result.length) {
            TextStyle[] newResult = new TextStyle[count];
            System.arraycopy(result, 0, newResult, 0, count);
            result = newResult;
        }
        return result;
    }

    public int[] getTabs() {
        this.checkLayout();
        return this.tabs;
    }

    int GetTextRun(int textSourceCharacterIndex) {
        int length;
        if (this.runs == null) {
            this.runs = new int[4];
        }
        int index = 0;
        while (index < this.runs.length && this.runs[index] != 0) {
            ++index;
        }
        if (index == this.runs.length) {
            int[] tmpRuns = new int[index + 4];
            System.arraycopy(this.runs, 0, tmpRuns, 0, index);
            this.runs = tmpRuns;
        }
        if (textSourceCharacterIndex >= (length = OS.String_Length(this.string))) {
            this.runs[index] = OS.gcnew_TextEndOfParagraph(1, this.defaultTextProperties);
        } else {
            int styleIndex = 1;
            while (styleIndex < this.styles.length && this.styles[styleIndex].start <= textSourceCharacterIndex) {
                ++styleIndex;
            }
            TextStyle textStyle = this.styles[styleIndex - 1].style;
            int textProperties = this.styles[styleIndex - 1].textProperties;
            if (textProperties == 0) {
                textProperties = this.defaultTextProperties;
            }
            int end = this.styles[styleIndex].start;
            if (textStyle != null && textStyle.metrics != null) {
                GlyphMetrics metrics = textStyle.metrics;
                this.runs[index] = OS.gcnew_SWTTextEmbeddedObject(textProperties, end - textSourceCharacterIndex, metrics.width, metrics.ascent + metrics.descent, metrics.ascent);
            } else {
                char ch = this.segmentsText.charAt(textSourceCharacterIndex);
                if (ch == '\n' || ch == '\r') {
                    int breakLength = 1;
                    if (ch == '\r' && textSourceCharacterIndex + 1 < end && this.segmentsText.charAt(textSourceCharacterIndex + 1) == '\n') {
                        ++breakLength;
                    }
                    this.runs[index] = OS.gcnew_TextEndOfLine(breakLength, textProperties);
                } else {
                    int i = textSourceCharacterIndex;
                    while (i < end && (ch = this.segmentsText.charAt(i)) != '\n' && ch != '\r') {
                        ++i;
                    }
                    this.runs[index] = OS.gcnew_TextCharacters(this.string, textSourceCharacterIndex, i - textSourceCharacterIndex, textProperties);
                }
            }
        }
        return this.runs[index];
    }

    int GetPrecedingText(int textSourceCharacterIndexLimit) {
        return 0;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getWidth() {
        this.checkLayout();
        return this.wrapWidth;
    }

    public boolean isDisposed() {
        return this.device == null;
    }

    public void setAlignment(int alignment) {
        this.checkLayout();
        int mask = 16924672;
        if ((alignment &= mask) == 0) {
            return;
        }
        if ((alignment & 0x4000) != 0) {
            alignment = 16384;
        }
        if ((alignment & 0x20000) != 0) {
            alignment = 131072;
        }
        if (this.alignment == alignment) {
            return;
        }
        this.freeRuns();
        this.alignment = alignment;
    }

    public void setAscent(int ascent) {
        this.checkLayout();
        if (ascent < -1) {
            SWT.error(5);
        }
        if (this.ascent == ascent) {
            return;
        }
        this.freeRuns();
        this.ascent = ascent;
    }

    public void setDescent(int descent) {
        this.checkLayout();
        if (descent < -1) {
            SWT.error(5);
        }
        if (this.descent == descent) {
            return;
        }
        this.freeRuns();
        this.descent = descent;
    }

    public void setFont(Font font) {
        Font oldFont;
        this.checkLayout();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if ((oldFont = this.font) == font) {
            return;
        }
        this.font = font;
        if (oldFont != null && oldFont.equals(font)) {
            return;
        }
        this.freeRuns();
    }

    public void setIndent(int indent) {
        this.checkLayout();
        if (indent < 0) {
            return;
        }
        if (this.indent == indent) {
            return;
        }
        this.freeRuns();
        this.indent = indent;
    }

    public void setJustify(boolean justify) {
        this.checkLayout();
        if (this.justify == justify) {
            return;
        }
        this.freeRuns();
        this.justify = justify;
    }

    public void setOrientation(int orientation) {
        this.checkLayout();
        int mask = 0x6000000;
        if ((orientation &= mask) == 0) {
            return;
        }
        if ((orientation & 0x2000000) != 0) {
            orientation = 0x2000000;
        }
        if (this.orientation == orientation) {
            return;
        }
        this.orientation = orientation;
        this.freeRuns();
    }

    public void setSegments(int[] segments) {
        this.checkLayout();
        if (this.segments == null && segments == null) {
            return;
        }
        if (this.segments != null && segments != null && this.segments.length == segments.length) {
            int i = 0;
            while (i < segments.length) {
                if (this.segments[i] != segments[i]) break;
                ++i;
            }
            if (i == segments.length) {
                return;
            }
        }
        this.freeRuns();
        this.segments = segments;
    }

    public void setSpacing(int spacing) {
        this.checkLayout();
        if (spacing < 0) {
            SWT.error(5);
        }
        if (this.lineSpacing == spacing) {
            return;
        }
        this.freeRuns();
        this.lineSpacing = spacing;
    }

    public void setStyle(TextStyle style, int start, int end) {
        int modifyStart;
        this.checkLayout();
        int length = this.text.length();
        if (length == 0) {
            return;
        }
        if (start > end) {
            return;
        }
        start = Math.min(Math.max(0, start), length - 1);
        end = Math.min(Math.max(0, end), length - 1);
        int low = -1;
        int high = this.styles.length;
        while (high - low > 1) {
            int index = (high + low) / 2;
            if (this.styles[index + 1].start > start) {
                high = index;
                continue;
            }
            low = index;
        }
        if (high >= 0 && high < this.styles.length) {
            StyleItem item = this.styles[high];
            if (item.start == start && this.styles[high + 1].start - 1 == end && (style == null ? item.style == null : style.equals(item.style))) {
                return;
            }
        }
        this.freeRuns();
        int modifyEnd = modifyStart = high;
        while (modifyEnd < this.styles.length) {
            if (this.styles[modifyEnd + 1].start > end) break;
            ++modifyEnd;
        }
        if (modifyStart == modifyEnd) {
            int styleStart = this.styles[modifyStart].start;
            int styleEnd = this.styles[modifyEnd + 1].start - 1;
            if (styleStart == start && styleEnd == end) {
                this.styles[modifyStart].style = style;
                return;
            }
            if (styleStart != start && styleEnd != end) {
                StyleItem[] newStyles = new StyleItem[this.styles.length + 2];
                System.arraycopy(this.styles, 0, newStyles, 0, modifyStart + 1);
                StyleItem item = new StyleItem();
                item.start = start;
                item.style = style;
                newStyles[modifyStart + 1] = item;
                item = new StyleItem();
                item.start = end + 1;
                item.style = this.styles[modifyStart].style;
                newStyles[modifyStart + 2] = item;
                System.arraycopy(this.styles, modifyEnd + 1, newStyles, modifyEnd + 3, this.styles.length - modifyEnd - 1);
                this.styles = newStyles;
                return;
            }
        }
        if (start == this.styles[modifyStart].start) {
            --modifyStart;
        }
        if (end == this.styles[modifyEnd + 1].start - 1) {
            ++modifyEnd;
        }
        int newLength = this.styles.length + 1 - (modifyEnd - modifyStart - 1);
        StyleItem[] newStyles = new StyleItem[newLength];
        System.arraycopy(this.styles, 0, newStyles, 0, modifyStart + 1);
        StyleItem item = new StyleItem();
        item.start = start;
        item.style = style;
        newStyles[modifyStart + 1] = item;
        this.styles[modifyEnd].start = end + 1;
        System.arraycopy(this.styles, modifyEnd, newStyles, modifyStart + 2, this.styles.length - modifyEnd);
        this.styles = newStyles;
    }

    public void setTabs(int[] tabs) {
        this.checkLayout();
        if (this.tabs == null && tabs == null) {
            return;
        }
        if (this.tabs != null && tabs != null && this.tabs.length == tabs.length) {
            int i = 0;
            while (i < tabs.length) {
                if (this.tabs[i] != tabs[i]) break;
                ++i;
            }
            if (i == tabs.length) {
                return;
            }
        }
        this.freeRuns();
        this.tabs = tabs;
    }

    public void setText(String text) {
        this.checkLayout();
        if (text == null) {
            SWT.error(4);
        }
        if (text.equals(this.text)) {
            return;
        }
        this.freeRuns();
        this.text = text;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.styles[1].start = text.length();
    }

    public void setWidth(int width) {
        this.checkLayout();
        if (width < -1 || width == 0) {
            SWT.error(5);
        }
        if (this.wrapWidth == width) {
            return;
        }
        this.freeRuns();
        this.wrapWidth = width;
    }

    int validadeOffset(int offset, int step) {
        offset += step;
        if (this.segments != null && this.segments.length > 2) {
            int i = 0;
            while (i < this.segments.length) {
                if (this.translateOffset(this.segments[i]) - 1 == offset) {
                    offset += step;
                    break;
                }
                ++i;
            }
        }
        return offset;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "TextLayout {*DISPOSED*}";
        }
        return "TextLayout {}";
    }

    int translateOffset(int offset) {
        if (this.segments == null) {
            return offset;
        }
        int nSegments = this.segments.length;
        if (nSegments <= 1) {
            return offset;
        }
        int length = this.text.length();
        if (length == 0) {
            return offset;
        }
        if (nSegments == 2 && this.segments[0] == 0 && this.segments[1] == length) {
            return offset;
        }
        int i = 0;
        while (i < nSegments && offset - i >= this.segments[i]) {
            ++offset;
            ++i;
        }
        return offset;
    }

    int untranslateOffset(int offset) {
        if (this.segments == null) {
            return offset;
        }
        int nSegments = this.segments.length;
        if (nSegments <= 1) {
            return offset;
        }
        int length = this.text.length();
        if (length == 0) {
            return offset;
        }
        if (nSegments == 2 && this.segments[0] == 0 && this.segments[1] == length) {
            return offset;
        }
        int i = 0;
        while (i < nSegments && offset > this.segments[i]) {
            --offset;
            ++i;
        }
        return offset;
    }

    class StyleItem {
        TextStyle style;
        int start;
        int length;
        int textProperties;

        StyleItem() {
        }

        void free() {
            if (this.textProperties != 0) {
                OS.GCHandle_Free(this.textProperties);
            }
            this.textProperties = 0;
        }

        public String toString() {
            return "StyleItem {" + this.start + ", " + this.style + "}";
        }
    }
}

