/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.wpf.OS;

public class HTMLTransfer
extends ByteArrayTransfer {
    private static HTMLTransfer _instance = new HTMLTransfer();
    private static int TYPEID = HTMLTransfer.getTypeId();

    public static HTMLTransfer getInstance() {
        return _instance;
    }

    static int getTypeId() {
        int format = OS.DataFormats_Html();
        String name = HTMLTransfer.createJavaString(format);
        OS.GCHandle_Free(format);
        return HTMLTransfer.registerType(name);
    }

    private HTMLTransfer() {
    }

    boolean checkHTML(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkHTML(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        transferData.pValue = HTMLTransfer.createDotNetString((String)object);
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pValue == 0) {
            return null;
        }
        return HTMLTransfer.createJavaString(transferData.pValue);
    }
}

