/* Filename: UnknownIndicationTypeProblem.java
 * Creator: Raquel Hervas
 * Format: Java 2 v1.6.0
 * Date created: 02/11/2009
 */
package nil.ucm.indications2.core.rep.problems;

import java.util.Collection;
import java.util.Collections;

import nil.ucm.indications2.core.rep.IndicationStructureRep;

import org.eclipse.core.resources.IMarker;

import edu.mit.story.core.build.StoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since nil.ucm.indications2.core 1.0.0
 */
public class UnusedTokensProblem extends StoryProblem {
	
	public static final String ID = "nil.ucm.indications2.core.problem.unusedTokens";
	
	public UnusedTokensProblem(IDesc desc, String buildRuleID) {
		this(Collections.singleton(desc), buildRuleID);
	}

	public UnusedTokensProblem(Collection<? extends IDesc> descs, String buildRuleID) {
		super(IndicationStructureRep.getInstance(), buildRuleID);
		setID(ID);
		setName("unused tokens");
		setSeverity(IMarker.SEVERITY_WARNING);
		setDescs(descs);
		IDescSet ds = getDescs().getDescriptions(IndicationStructureRep.getInstance());
		if(ds.isEmpty()) throw new IllegalArgumentException();
		
		boolean single = ds.size() == 1;
		String start = single ? "There is " : "There are ";
		String end = single ? " indication with unused tokens" : " indications with unused tokens";
		setDescription(start + Integer.toString(ds.size()) + end + (single ? "" : " (only first shown)"));
		setPosition(ds.first());
	}

}
