/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.dialogs;

import edu.mit.jverbnet.data.IMember;
import edu.mit.jverbnet.data.IVerbClass;
import edu.mit.jverbnet.data.IWordnetKey;
import edu.mit.jverbnet.index.IVerbIndex;
import edu.mit.semantics.core.SemanticsPlugin;
import edu.mit.semantics.core.verbnet.IVerbnetManager;
import edu.mit.semantics.core.verbnet.IWorkbenchVerbIndex;
import edu.mit.semantics.ui.SemanticsUIPlugin;
import edu.mit.semantics.ui.label.MemberDisplayLabelProvider;
import edu.mit.semantics.ui.label.RoleDisplayLabelProvider;
import edu.mit.semantics.ui.label.VerbClassExampleLabelProvider;
import edu.mit.semantics.ui.label.VerbClassLabelProvider;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.viewers.StyledTextViewer;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

public class VerbClassSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = VerbClassSelectionDialog.class.getCanonicalName();
    private Comparator itemComparator;
    protected IVerbIndex verbIndex;
    protected StyledTextViewer roleViewer;
    protected StyledTextViewer memberViewer;
    protected StyledTextViewer exampleViewer;

    public VerbClassSelectionDialog(Shell parent, IVerbIndex index) {
        super(parent);
        if (index == null) {
            throw new NullPointerException();
        }
        this.setTitle("Select Verb Class");
        this.setMessage("Enter a string by which to filter (? = any character, * = any string):");
        this.setListLabelProvider((ILabelProvider)VerbClassLabelProvider.getInstance());
        this.setDetailsLabelProvider((ILabelProvider)VerbClassLabelProvider.getInstance());
        this.verbIndex = index;
    }

    protected void setInitialSelection(IVerbClass vc) {
        this.setInitialElementSelections(Collections.singletonList(vc));
    }

    protected void setVerbIndex(IVerbIndex newIndex) {
        if (newIndex == null) {
            throw new NullPointerException();
        }
        this.verbIndex = newIndex;
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                VerbClassSelectionDialog.this.refresh();
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        SashForm horzSash = new SashForm(dialogArea, 256);
        horzSash.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite control = (Composite)dialogArea.getChildren()[0];
        control.setParent((Composite)horzSash);
        SashForm vertSash = new SashForm((Composite)horzSash, 512);
        Composite roles = new Composite((Composite)vertSash, 0);
        roles.setLayout((Layout)new GridLayout());
        Label label = new Label(roles, 0);
        label.setText("Roles:");
        this.roleViewer = new StyledTextViewer(roles, 2816);
        this.roleViewer.getControl().setEditable(false);
        this.roleViewer.getControl().setWordWrap(true);
        this.roleViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.roleViewer.getControl().setBackground(StoryUIPlugin.getDefault().getColorManager().get((Object)"WHITE"));
        this.roleViewer.setLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)RoleDisplayLabelProvider.getInstance());
        Composite examples = new Composite((Composite)vertSash, 0);
        examples.setLayout((Layout)new GridLayout());
        label = new Label(examples, 0);
        label.setText("Examples:");
        this.exampleViewer = new StyledTextViewer(examples, 2816);
        this.exampleViewer.getControl().setEditable(false);
        this.exampleViewer.getControl().setWordWrap(true);
        this.exampleViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.exampleViewer.getControl().setBackground(StoryUIPlugin.getDefault().getColorManager().get((Object)"WHITE"));
        this.exampleViewer.setLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)VerbClassExampleLabelProvider.getInstance());
        vertSash.setWeights(new int[]{2, 1});
        Composite members = new Composite((Composite)horzSash, 0);
        members.setLayout((Layout)new GridLayout());
        label = new Label(members, 0);
        label.setText("Members:");
        this.memberViewer = new StyledTextViewer(members, 2816);
        this.memberViewer.getControl().setEditable(false);
        this.memberViewer.getControl().setWordWrap(true);
        this.memberViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.memberViewer.getControl().setBackground(StoryUIPlugin.getDefault().getColorManager().get((Object)"WHITE"));
        this.memberViewer.setLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)MemberDisplayLabelProvider.getInstance());
        return dialogArea;
    }

    protected void handleSelected(StructuredSelection selection) {
        IVerbClass verb = (IVerbClass)SelectionUtils.extractSingle((ISelection)selection, IVerbClass.class);
        this.roleViewer.setInput((Object)verb);
        this.memberViewer.setInput((Object)verb);
        this.exampleViewer.setInput((Object)verb);
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider cp, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor pm) throws CoreException {
        IVerbnetManager verbnetManager = SemanticsPlugin.getDefault().getVerbnetManager();
        IWorkbenchVerbIndex index = verbnetManager.getLatestIndex();
        pm.beginTask("Searching...", 270);
        for (IVerbClass vc : index) {
            cp.add((Object)vc, itemsFilter);
            pm.worked(1);
        }
        pm.done();
    }

    public String getElementName(Object item) {
        if (item instanceof IVerbClass) {
            IVerbClass vc = (IVerbClass)item;
            return vc.getID();
        }
        throw new IllegalArgumentException();
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new VerbClassFilter();
    }

    protected Comparator getItemsComparator() {
        if (this.itemComparator == null) {
            this.itemComparator = new VerbClassComparator();
        }
        return this.itemComparator;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = SemanticsUIPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = SemanticsUIPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    public static IVerbClass selectVerbClass(Shell shell, IVerbIndex index, IVerbClass initial) {
        return VerbClassSelectionDialog.selectVerbClass(shell, index, initial, null);
    }

    public static IVerbClass selectVerbClass(Shell shell, IVerbIndex index, IVerbClass initial, String pattern) {
        int code;
        VerbClassSelectionDialog dialog = new VerbClassSelectionDialog(shell, index);
        dialog.setBlockOnOpen(true);
        if (initial != null) {
            dialog.setInitialSelection(initial);
        }
        if (pattern != null) {
            dialog.setInitialPattern(pattern, 2);
        }
        if ((code = dialog.open()) == 1) {
            return null;
        }
        Object[] result = dialog.getResult();
        if (result == null || result.length == 0) {
            return null;
        }
        return (IVerbClass)result[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class VerbClassComparator
    implements Comparator<IVerbClass> {
        protected VerbClassComparator() {
        }

        @Override
        public int compare(IVerbClass o1, IVerbClass o2) {
            return o1.getID().compareTo(o2.getID());
        }
    }

    protected class VerbClassFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        public VerbClassFilter() {
            super((FilteredItemsSelectionDialog)VerbClassSelectionDialog.this);
            String pattern = this.patternMatcher.getPattern();
            if (!pattern.startsWith("*")) {
                this.patternMatcher.setPattern("*" + pattern);
            }
        }

        public boolean matchItem(Object item) {
            if (!(item instanceof IVerbClass)) {
                return false;
            }
            IVerbClass vc = (IVerbClass)item;
            if (this.patternMatcher.matches(vc.getID())) {
                return true;
            }
            for (IMember m : vc.getMembers()) {
                if (this.patternMatcher.matches(m.getName())) {
                    return true;
                }
                for (IWordnetKey k : m.getWordnetTypes().keySet()) {
                    if (!this.patternMatcher.matches(k.getLemma())) continue;
                    return true;
                }
                for (String g : m.getGroupings()) {
                    if (!this.patternMatcher.matches(g)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isConsistentItem(Object item) {
            return false;
        }
    }
}

