/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.content;

import edu.mit.semantics.core.rep.semrole.ISemArg;
import edu.mit.semantics.core.rep.semrole.ISemRole;
import edu.mit.semantics.core.rep.semrole.SemRoleRep;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.ui.content.StoryEditorContentProvider;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.Viewer;

public class SemRoleContentProvider
extends StoryEditorContentProvider {
    public static final int CHILD_TYPE_FEATURES = 1;
    public static final int CHILD_TYPE_ACTIVE = 2;
    public static final int CHILD_TYPE_THIRDPERSON = 3;
    private Viewer viewer = null;
    private boolean showFeatures = true;

    public SemRoleContentProvider(IStoryEditor editor) {
        this(editor, true);
    }

    public SemRoleContentProvider(IStoryEditor editor, boolean showFeatures) {
        super(SemRoleRep.getInstance(), editor, "(no semantic roles)");
        this.showFeatures = showFeatures;
    }

    public boolean isShowingFeatures() {
        return this.showFeatures;
    }

    public void setShowFeatures(boolean value) {
        if (this.showFeatures == value) {
            return;
        }
        this.showFeatures = value;
        this.inputChanged(this.viewer, this.getStoryEditor(), this.getStoryEditor());
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        super.inputChanged(viewer, oldInput, newInput);
        if (viewer != null) {
            viewer.refresh();
        }
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IDesc) {
            return true;
        }
        if (element instanceof IDescSet) {
            return true;
        }
        if (element instanceof ISemRole) {
            return true;
        }
        if (SemRoleContentProvider.isElement((Object)element, (int)1)) {
            return true;
        }
        return super.hasChildren(element);
    }

    public Object[] getChildren(Object parent) {
        Object[] defaultChildren = super.getChildren(parent);
        if (parent instanceof IDescSet) {
            IDescSet ds = (IDescSet)parent;
            return ds.toArray();
        }
        Object data = parent;
        if (parent instanceof IDesc) {
            IDesc desc = (IDesc)parent;
            data = (ISemRole)desc.getData();
        }
        if (data instanceof ISemRole) {
            ISemRole semrole = (ISemRole)data;
            List argList = semrole.getArguments();
            ArrayList<Object> results = new ArrayList<Object>(argList.size() + 1 + (this.showFeatures ? 5 : 0));
            for (ISemArg arg : argList) {
                results.add(SemRoleContentProvider.makeChild((Object)parent, (Object)arg));
            }
            if (this.showFeatures) {
                results.add(SemRoleContentProvider.makeChild((int)2, (Object)parent, (Object)semrole.isActive()));
                results.add(SemRoleContentProvider.makeChild((int)3, (Object)parent, (Object)semrole.isThirdPerson()));
                results.add(SemRoleContentProvider.makeChild((Object)parent, (Object)semrole.getTense()));
                results.add(SemRoleContentProvider.makeChild((Object)parent, (Object)semrole.getAspect()));
                results.add(SemRoleContentProvider.makeChild((Object)parent, (Object)semrole.getForm()));
            }
            if (defaultChildren != null) {
                Object[] objectArray = defaultChildren;
                int n = defaultChildren.length;
                int n2 = 0;
                while (n2 < n) {
                    Object dc = objectArray[n2];
                    results.add(dc);
                    ++n2;
                }
            }
            return results.toArray();
        }
        return defaultChildren;
    }
}

