/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.equinox.internal.p2.ui.PlanStatusHelper;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.director.PlannerHelper;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.equinox.internal.provisional.p2.ui.IProfileChooser;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.actions.ProfileModificationAction;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.InstallWizard;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policies;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class InstallAction
extends ProfileModificationAction {
    public static ProvisioningPlan computeProvisioningPlan(IInstallableUnit[] ius, String targetProfileId, IProgressMonitor monitor) throws ProvisionException {
        MultiStatus additionalStatus = PlanStatusHelper.getProfileChangeAlteredStatus();
        ProfileChangeRequest request = ProfileChangeRequest.createByProfileId((String)targetProfileId);
        IProfile profile = ProvisioningUtil.getProfile(targetProfileId);
        int i = 0;
        while (i < ius.length) {
            Collector alreadyInstalled;
            if (Boolean.toString(true).equals(ius[i].getProperty("org.eclipse.equinox.p2.type.patch"))) {
                request.setInstallableUnitInclusionRules(ius[i], PlannerHelper.createOptionalInclusionRule((IInstallableUnit)ius[i]));
            }
            if ((alreadyInstalled = profile.query((Query)new InstallableUnitQuery(ius[i].getId()), new Collector(), null)).size() > 0) {
                IInstallableUnit installedIU = (IInstallableUnit)alreadyInstalled.iterator().next();
                int compareTo = ius[i].getVersion().compareTo((Object)installedIU.getVersion());
                if (compareTo > 0) {
                    request.addInstallableUnits(new IInstallableUnit[]{ius[i]});
                    request.removeInstallableUnits(new IInstallableUnit[]{installedIU});
                    if (!Boolean.toString(true).equals(profile.getInstallableUnitProperty(installedIU, "org.eclipse.equinox.p2.type.root"))) {
                        request.setInstallableUnitProfileProperty(ius[i], "org.eclipse.equinox.p2.type.root", (Object)Boolean.toString(true));
                    }
                    additionalStatus.merge(PlanStatusHelper.getStatus(10002, ius[i]));
                } else if (compareTo < 0) {
                    additionalStatus.merge(PlanStatusHelper.getStatus(10003, ius[i]));
                } else if (Boolean.toString(true).equals(profile.getInstallableUnitProperty(installedIU, "org.eclipse.equinox.p2.type.root"))) {
                    additionalStatus.merge(PlanStatusHelper.getStatus(10004, ius[i]));
                } else {
                    request.setInstallableUnitProfileProperty(ius[i], "org.eclipse.equinox.p2.type.root", (Object)Boolean.toString(true));
                }
            } else {
                request.addInstallableUnits(new IInstallableUnit[]{ius[i]});
                request.setInstallableUnitProfileProperty(ius[i], "org.eclipse.equinox.p2.type.root", (Object)Boolean.toString(true));
            }
            ++i;
        }
        ProvisioningPlan plan = ProvisioningUtil.getProvisioningPlan(request, new ProvisioningContext(), monitor);
        if (additionalStatus.getChildren().length > 0) {
            additionalStatus.merge(plan.getStatus());
            plan = new ProvisioningPlan((IStatus)additionalStatus, plan.getOperands());
        }
        return new ProvisioningPlan(PlanStatusHelper.computeStatus(plan, ius), plan.getOperands());
    }

    public InstallAction(ISelectionProvider selectionProvider, String profileId, IProfileChooser chooser, Policies policies, Shell shell) {
        super(ProvUI.INSTALL_COMMAND_LABEL, selectionProvider, profileId, chooser, policies, shell);
        this.setToolTipText(ProvUI.INSTALL_COMMAND_TOOLTIP);
    }

    protected boolean isEnabledFor(Object[] selectionArray) {
        if (selectionArray.length == 0) {
            return false;
        }
        int i = 0;
        while (i < selectionArray.length) {
            IInstallableUnit iu = this.getIU(selectionArray[i]);
            if (iu != null && !ProvisioningUtil.isCategory(iu)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected String getTaskName() {
        return ProvUIMessages.InstallIUProgress;
    }

    protected int performOperation(IInstallableUnit[] ius, String targetProfileId, ProvisioningPlan plan) {
        InstallWizard wizard = new InstallWizard(targetProfileId, ius, plan, this.getLicenseManager());
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.create();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.equinox.p2.ui.install_wizard_context");
        return dialog.open();
    }

    protected ProvisioningPlan getProvisioningPlan(IInstallableUnit[] ius, String targetProfileId, IProgressMonitor monitor) throws ProvisionException {
        return InstallAction.computeProvisioningPlan(ius, targetProfileId, monitor);
    }
}

