/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.core.rep.sense;

import edu.mit.jwi.item.IWord;
import edu.mit.jwi.item.IWordID;
import edu.mit.jwi.item.WordID;
import edu.mit.parsing.core.rep.colloc.CollocRep;
import edu.mit.parsing.core.rep.pos.IPosData;
import edu.mit.parsing.core.rep.pos.POSRep;
import edu.mit.parsing.core.rep.stem.StemRep;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.factory.IDescFactory;
import edu.mit.story.core.manager.IManager;
import edu.mit.story.core.mappers.BlockMapper;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.property.ConfigDescriptor;
import edu.mit.story.core.property.IConfigDescriptor;
import edu.mit.story.core.property.IConfiguration;
import edu.mit.story.core.rep.AbstractRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import edu.mit.story.core.validation.IValidator;
import edu.mit.story.core.validation.ManagerBackedListValidator;
import edu.mit.story.core.validation.PreferenceStoreBackedPropertyDescriptor;
import edu.mit.wordnet.core.WordnetMessages;
import edu.mit.wordnet.core.WordnetPlugin;
import edu.mit.wordnet.core.rep.sense.ISense;
import edu.mit.wordnet.core.rep.sense.Sense;
import edu.mit.wordnet.core.rep.sense.algorithm.ISenseTagger;
import edu.mit.wordnet.core.rep.sense.changes.GenerateSenseModelChange;
import edu.mit.wordnet.core.rep.sense.dict.IExtendedDictionary;
import edu.mit.wordnet.core.rep.sense.evidence.Evidence;
import edu.mit.wordnet.core.rep.sense.evidence.IEvidence;
import edu.mit.wordnet.core.rep.sense.evidence.TypedEvidence;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SenseRep
extends AbstractRep {
    public static final String ID = "edu.mit.wordnet.sense";
    public static final String NO_SENSE = "NO_SENSE";
    private static final long serialVersionUID = 1L;
    private static IRep fInstance = null;

    public static IRep getInstance() {
        if (fInstance == null) {
            fInstance = StoryPlugin.getDefault().getRepManager().getRep(ID);
        }
        return fInstance;
    }

    public SenseRep() {
        super(ISense.class, 1);
    }

    protected void initAntecedentsInternal(IRepSet container) {
        container.add((Object)TokenRep.getInstance());
        container.add((Object)CollocRep.getInstance());
        container.add((Object)POSRep.getInstance());
        container.add((Object)StemRep.getInstance());
    }

    public String serialize(IData data) {
        ISense sense = (ISense)data;
        ArrayList<String> fields = new ArrayList<String>(5);
        String field = sense.getSense() == null ? NO_SENSE : ((IWordID)sense.getSense().getID()).toString();
        fields.add(field);
        field = sense.getEvidence() == null ? "" : TypedEvidence.serialize(sense.getEvidence());
        fields.add(field);
        IDesc token = sense.getWord();
        fields.add(Long.toString(token.getID()));
        IDesc pos = sense.getPOSDesc();
        fields.add(pos == null ? "" : Long.toString(pos.getID()));
        IDesc stem = sense.getStemDesc();
        fields.add(stem == null ? "" : Long.toString(stem.getID()));
        return BlockMapper.COMMA.serialize(fields);
    }

    public Sense reconstitute(IHasPosition p, String data, IStoryModel model) {
        IWordID wid;
        List fields = BlockMapper.COMMA.reconstitute(data);
        if (fields == null) {
            this.hashCode();
        }
        if (fields == null || fields.size() == 2) {
            return this.legacyReconsitute(fields, p, model);
        }
        IExtendedDictionary dict = SenseRep.getDictionary(model.getData());
        IWord sense = null;
        String senseID = (String)fields.get(0);
        if (!NO_SENSE.equals(senseID) && (wid = WordID.parseWordID((String)senseID)) != null) {
            sense = dict.getWord(wid);
        }
        IEvidence evidence = Evidence.reconstitute((String)fields.get(1));
        long id = -1L;
        try {
            id = Long.parseLong((String)fields.get(2));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        IDesc token = model.getData().getDescriptions(TokenRep.getInstance()).getDescription(id);
        if (token == null) {
            token = model.getData().getDescriptions(CollocRep.getInstance()).getDescription(id);
        }
        if (token == null) {
            return null;
        }
        IDesc pos = null;
        if (((String)fields.get(3)).length() > 0) {
            try {
                id = Long.parseLong((String)fields.get(3));
                pos = model.getData().getDescriptions(POSRep.getInstance()).getDescription(id);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        IDesc stem = null;
        if (((String)fields.get(4)).length() > 0) {
            try {
                id = Long.parseLong((String)fields.get(4));
                stem = model.getData().getDescriptions(StemRep.getInstance()).getDescription(id);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return new Sense(token, stem, pos, sense, evidence);
    }

    protected Sense legacyReconsitute(List<String> fields, IHasPosition p, IStoryModel model) {
        IExtendedDictionary dict = SenseRep.getDictionary(model.getData());
        IWord word = null;
        IEvidence evidence = null;
        if (fields != null && fields.size() == 2) {
            IWordID wid;
            String id = fields.get(0);
            if (!id.equals(NO_SENSE) && (wid = WordID.parseWordID((String)id)) != null) {
                word = dict.getWord(wid);
            }
            evidence = Evidence.reconstitute(fields.get(1));
        }
        IDesc token = null;
        IDescSet descs = model.getData().getDescriptions(TokenRep.getInstance()).matchSet(p);
        if (descs.isEmpty()) {
            descs = model.getData().getDescriptions(CollocRep.getInstance()).matchSet(p);
        }
        if (descs.size() == 1) {
            token = (IDesc)descs.first();
        }
        if (token == null) {
            return null;
        }
        IDesc pos = null;
        descs = model.getData().getDescriptions(POSRep.getInstance()).matchSet(p);
        if (descs.size() == 1) {
            pos = (IDesc)descs.first();
        }
        IDesc stem = null;
        descs = model.getData().getDescriptions(StemRep.getInstance()).matchSet(p);
        if (descs.size() == 1) {
            stem = (IDesc)descs.first();
        }
        return new Sense(token, stem, pos, word, evidence);
    }

    public IModelChange getBatchModelChange() {
        return new GenerateSenseModelChange();
    }

    public static String getDictionaryID(IStoryData data) {
        IConfiguration config = data.getConfiguration(SenseRep.getInstance());
        return (String)config.get((Object)"wordnet");
    }

    public static IExtendedDictionary getDictionary(IStoryData data) {
        String wordnetID = SenseRep.getDictionaryID(data);
        return wordnetID == null ? null : (IExtendedDictionary)WordnetPlugin.getDefault().getDictionaryManager().create(wordnetID);
    }

    public static boolean setDictionary(String dictID, IStoryData data) {
        IConfiguration config = data.getConfiguration(SenseRep.getInstance());
        config.put((Object)"wordnet", (Object)dictID);
        return true;
    }

    public static ISenseTagger getSenseTagger(IStoryModel model) {
        if (!model.supports(SenseRep.getInstance())) {
            return null;
        }
        IDescFactory factory = model.getFactory(SenseRep.getInstance());
        if (factory == null) {
            return null;
        }
        IConfiguration config = factory.getConfiguration();
        if (config == null) {
            return null;
        }
        String taggerID = (String)config.get((Object)"senseTagger");
        if (taggerID == null) {
            return null;
        }
        return (ISenseTagger)WordnetPlugin.getDefault().getSenseTaggerManager().create(taggerID);
    }

    public static boolean isSenseTaggable(IPosData tag) {
        if (tag.isAuxiliary()) {
            return false;
        }
        return tag.getTag().isOpenClass();
    }

    protected IConfigDescriptor createConfigurationDescriptor(String id, String name, String desc) {
        return new SenseRepConfigDescriptor(id, name, desc);
    }

    public static class SenseRepConfigDescriptor
    extends ConfigDescriptor {
        private static final long serialVersionUID = 1L;

        public SenseRepConfigDescriptor(String id, String name, String desc) {
            this();
            this.setID(id);
            this.setName(name);
            this.setDescription(desc);
        }

        public SenseRepConfigDescriptor() {
            PreferenceStoreBackedPropertyDescriptor d = new PreferenceStoreBackedPropertyDescriptor("wordnet", WordnetMessages.PARAM_Wordnet_name, WordnetMessages.PARAM_Wordnet_desc, (IValidator)new ManagerBackedListValidator((IManager)WordnetPlugin.getDefault().getDictionaryManager()), false, "DefaultWordnetID", WordnetPlugin.getDefault().getPreferenceStore());
            this.put(d.getID(), d);
        }
    }
}

