/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.valence;

import edu.mit.semantics.core.rep.event.EventRep;
import edu.mit.semantics.core.rep.event.IEvent;
import edu.mit.semantics.core.rep.valence.IEventValence;
import edu.mit.semantics.core.rep.valence.Valence;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.IHasRep;

public class EventValence
implements IEventValence {
    private final IDesc event;
    private final Valence valence;

    public EventValence(Valence valence, IDesc event) {
        if (!EventRep.getInstance().isType((IHasRep)event)) {
            throw new IllegalArgumentException();
        }
        if (valence == null) {
            throw new NullPointerException();
        }
        this.event = event;
        this.valence = valence;
    }

    public IDesc getEvent() {
        return this.event;
    }

    public Valence getValence() {
        return this.valence;
    }

    public IHasPosition calculatePosition() {
        return this.event;
    }

    public IHasPosition getDisplayPosition() {
        IEvent e = (IEvent)this.event.getData();
        return e.getDisplayPosition();
    }

    public IStructuredData recalculate(IDesc container, IStoryModel model) {
        IDesc newEvent = model.getData().getDescriptions(EventRep.getInstance()).getDescription(this.event.getID());
        if (newEvent == this.event) {
            return this;
        }
        if (newEvent == null) {
            return null;
        }
        return new EventValence(this.valence, newEvent);
    }

    public boolean equals(IData tgtData, IAlignedStoryModel model) {
        IEventValence that = (IEventValence)tgtData;
        if (this.getValence() != that.getValence()) {
            return false;
        }
        return Desc.equals((IDesc)this.getEvent(), (IDesc)that.getEvent(), (IAlignedStoryModel)model);
    }
}

