/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.timelink;

import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.semantics.core.rep.event.EventRep;
import edu.mit.semantics.core.rep.timelink.GenerateTimelinkModelChange;
import edu.mit.semantics.core.rep.timelink.IRelType;
import edu.mit.semantics.core.rep.timelink.ITimeLink;
import edu.mit.semantics.core.rep.timelink.LinkType;
import edu.mit.semantics.core.rep.timelink.TimeLink;
import edu.mit.semantics.core.rep.timex3.Timex3Rep;
import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.desc.Segment;
import edu.mit.story.core.mappers.BlockMapper;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.AbstractRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import java.util.ArrayList;
import java.util.List;

public class TimeLinkRep
extends AbstractRep {
    public static final String ID = "edu.mit.semantics.rep.timelink";
    private static IRep instance;

    public static IRep getInstance() {
        if (instance == null) {
            instance = StoryPlugin.getDefault().getRepManager().getRep(ID);
        }
        return instance;
    }

    public TimeLinkRep() {
        super(ITimeLink.class);
    }

    protected void initAntecedentsInternal(IRepSet container) {
        container.add((Object)TokenRep.getInstance());
        container.add((Object)EventRep.getInstance());
        container.add((Object)Timex3Rep.getInstance());
    }

    public String serialize(IData data) {
        ITimeLink link = (ITimeLink)data;
        ArrayList<String> fields = new ArrayList<String>(5);
        fields.add(link.getRelationType().getType().name());
        fields.add(link.getRelationType().name());
        fields.add(Long.toString(link.getSource().getID()));
        fields.add(Long.toString(link.getRelated().getID()));
        fields.add(link.getSignal() == null ? "" : Segment.serialize((ISegment)link.getSignal()));
        return BlockMapper.PIPE.serialize(fields);
    }

    public TimeLink reconstitute(IHasPosition p, String description, IStoryModel model) {
        List fields = BlockMapper.PIPE.reconstitute(description);
        LinkType linkType = LinkType.valueOf((String)fields.get(0));
        IRelType relType = (IRelType)Enum.valueOf(linkType.getUnspecifiedRelation().getClass(), (String)fields.get(1));
        IDesc source = model.getData().getDescription(Long.parseLong((String)fields.get(2)));
        IDesc related = model.getData().getDescription(Long.parseLong((String)fields.get(3)));
        ISegment signal = ((String)fields.get(4)).length() == 0 ? null : Segment.reconstitute((String)((String)fields.get(4)), (IRep)TokenRep.getInstance(), (IStoryData)model.getData());
        return new TimeLink(relType, source, related, signal);
    }

    public IModelChange getBatchModelChange() {
        return new GenerateTimelinkModelChange();
    }
}

