/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.io.ExtensionFileFilter;
import edu.stanford.nlp.util.FileProcessor;
import java.io.File;
import java.io.FileFilter;

public class FilePathProcessor {
    public static void processPath(String pathStr, String suffix, boolean recursively, FileProcessor processor) {
        FilePathProcessor.processPath(new File(pathStr), new ExtensionFileFilter(suffix, recursively), processor);
    }

    public static void processPath(File path, String suffix, boolean recursively, FileProcessor processor) {
        FilePathProcessor.processPath(path, new ExtensionFileFilter(suffix, recursively), processor);
    }

    public static void processPath(File path, FileFilter filter, FileProcessor processor) {
        if (path.isDirectory()) {
            File[] directoryListing = path.listFiles(filter);
            if (directoryListing == null) {
                throw new IllegalArgumentException("Directory access problem for: " + path);
            }
            for (int i = 0; i < directoryListing.length; ++i) {
                FilePathProcessor.processPath(directoryListing[i], filter, processor);
            }
        } else {
            processor.processFile(path);
        }
    }
}

