/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.tagger.maxent.Extractor;
import edu.stanford.nlp.tagger.maxent.ExtractorFrames;
import edu.stanford.nlp.tagger.maxent.GlobalHolder;
import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.TestSentence;
import java.util.HashMap;

class ExtractorVerbal_VB
extends Extractor {
    private static final String mdTag = "MD";
    private static final String vbTag = "VB";
    private static final String vbpTag = "VBP";
    private static final String naWord = "NA";
    private static String andWord = TestSentence.toSt("and");
    private static HashMap v = new HashMap();
    private static String bar = "|";
    private static String vb = "VB";
    private static String to = "TO";
    private static String oneSt = "1";
    private static String zeroSt = "0";
    private static int unRec = 0;
    private static int total = 0;
    private static int notUsual = 0;
    private static final boolean DBG = false;
    private final int bound;
    private static final long serialVersionUID = 3441425711549364480L;

    public ExtractorVerbal_VB() {
        this(8);
    }

    public ExtractorVerbal_VB(int bound) {
        this.bound = bound;
    }

    public boolean Precondition(String tag) {
        return tag.equals(vbTag) || tag.equals(vbpTag);
    }

    String extract(History h) {
        String cword = ExtractorFrames.cWord.extract(h);
        int start = h.start;
        int allCount = GlobalHolder.dict.sum(cword);
        int vBCount = GlobalHolder.dict.getCount(cword, vbTag);
        int vBPCount = GlobalHolder.dict.getCount(cword, vbpTag);
        if (allCount > 0 && vBCount + vBPCount <= allCount / 100) {
            return "0";
        }
        String lastverb = naWord;
        String lastvtag = "";
        int current = h.current;
        int index = current - 1;
        while (index >= start && index >= current - this.bound) {
            String tag = GlobalHolder.pairs.get(index, true);
            if (tag.equals(mdTag) || tag.startsWith(vb) || tag.startsWith(to)) {
                lastverb = GlobalHolder.pairs.get(index, false);
                lastvtag = tag;
                break;
            }
            if (tag.equals("CC")) break;
            --index;
        }
        if (this.isForVB(h, lastverb, lastvtag)) {
            return oneSt;
        }
        return zeroSt;
    }

    boolean isForVB(History h, String verb, String tag) {
        String verbnice = TestSentence.toNice(verb).toLowerCase();
        if (tag.equals(mdTag)) {
            return true;
        }
        if (tag.equals("TO")) {
            return true;
        }
        if (verbnice.equals("do")) {
            return true;
        }
        if (verbnice.equals("did")) {
            return true;
        }
        if (verbnice.equals("does")) {
            return true;
        }
        if (verbnice.startsWith("help")) {
            return true;
        }
        if (verbnice.startsWith("let")) {
            return true;
        }
        if (verbnice.startsWith("make")) {
            return true;
        }
        if (verbnice.equals("made")) {
            return true;
        }
        if (verbnice.equals("making")) {
            return true;
        }
        String prevWord = ExtractorFrames.prevWord.extract(h);
        if (prevWord.equals(naWord) || prevWord.startsWith("``") || prevWord.startsWith("-LRB-") || prevWord.startsWith("--")) {
            return true;
        }
        return prevWord.equals(andWord) && tag.equals(vbTag);
    }
}

