/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.tagger.maxent.TaggerOutputHolder;

public class CollectionTaggerOutputs {
    int numTaggers;
    static int baseToken = 0;
    private TaggerOutputHolder[] taggers;

    public CollectionTaggerOutputs(int num) {
        this.numTaggers = num;
        this.taggers = new TaggerOutputHolder[this.numTaggers];
    }

    public void readOutput(int nO, String filename, boolean probs) {
        this.taggers[nO] = new TaggerOutputHolder(filename, probs);
    }

    public String getTag(int numTagger, int numToken) {
        return this.taggers[numTagger].getTag(numToken + baseToken);
    }

    public CollectionTaggerOutputs(String[] args) {
        int num = new Integer(args[0]);
        if (args.length != 2 * num + 1) {
            System.out.println("Error " + args);
            System.exit(1);
        }
        this.numTaggers = num;
        this.taggers = new TaggerOutputHolder[this.numTaggers];
        int i = 0;
        while (i < num) {
            String filename = args[i * 2 + 1];
            boolean prb = args[i * 2 + 2].equals("t");
            this.readOutput(i, filename, prb);
            ++i;
        }
    }
}

