/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.UnaryRule;
import edu.stanford.nlp.util.Numberer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnaryGrammar
implements Serializable,
Iterable<UnaryRule> {
    private int numStates = -1;
    private String stateSpace;
    private transient List<UnaryRule>[] rulesWithParent = null;
    private transient List<UnaryRule>[] rulesWithChild = null;
    private transient List<UnaryRule>[] closedRulesWithParent = null;
    private transient List<UnaryRule>[] closedRulesWithChild = null;
    private transient UnaryRule[][] closedRulesWithP = null;
    private transient UnaryRule[][] closedRulesWithC = null;
    private Map<UnaryRule, UnaryRule> coreRules = null;
    private transient Map<UnaryRule, UnaryRule> bestRulesUnderMax = null;
    private transient Map<UnaryRule, Integer> backTrace = null;
    private static final UnaryRule[] EMPTY_UNARY_RULE_ARRAY = new UnaryRule[0];
    private static final long serialVersionUID = 1L;

    public int numClosedRules() {
        return this.bestRulesUnderMax.keySet().size();
    }

    public Iterator<UnaryRule> closedRuleIterator() {
        return this.bestRulesUnderMax.keySet().iterator();
    }

    public int numRules() {
        return this.coreRules.keySet().size();
    }

    @Override
    public Iterator<UnaryRule> iterator() {
        return this.ruleIterator();
    }

    public Iterator<UnaryRule> ruleIterator() {
        return this.coreRules.keySet().iterator();
    }

    public List<UnaryRule> rules() {
        return new ArrayList<UnaryRule>(this.coreRules.keySet());
    }

    public void purgeRules() {
        HashMap<UnaryRule, UnaryRule> bR = new HashMap<UnaryRule, UnaryRule>();
        for (UnaryRule ur : this.bestRulesUnderMax.keySet()) {
            if (ur.parent == ur.child) continue;
            bR.put(ur, ur);
        }
        this.bestRulesUnderMax = bR;
    }

    public List<Integer> getBestPath(int parent, int child) {
        ArrayList<Integer> path = new ArrayList<Integer>();
        UnaryRule tempR = new UnaryRule();
        tempR.parent = parent;
        tempR.child = child;
        int loc = parent;
        while (loc != child) {
            path.add(new Integer(loc));
            tempR.parent = loc;
            Integer nextInt = this.backTrace.get(tempR);
            loc = nextInt == null ? child : nextInt;
            if (path.size() <= 10) continue;
            throw new RuntimeException("UnaryGrammar path > 10");
        }
        path.add(new Integer(child));
        return path;
    }

    private void closeRulesUnderMax(UnaryRule ur) {
        for (int i = 0; i < this.closedRulesWithChild[ur.parent].size(); ++i) {
            UnaryRule pr = this.closedRulesWithChild[ur.parent].get(i);
            for (int j = 0; j < this.closedRulesWithParent[ur.child].size(); ++j) {
                UnaryRule cr = this.closedRulesWithParent[ur.child].get(j);
                UnaryRule resultR = new UnaryRule();
                resultR.parent = pr.parent;
                resultR.child = cr.child;
                resultR.score = pr.score + cr.score + ur.score;
                if (!this.relaxRule(resultR)) continue;
                if (resultR.parent != ur.parent) {
                    this.backTrace.put(resultR, new Integer(ur.parent));
                    continue;
                }
                this.backTrace.put(resultR, new Integer(ur.child));
            }
        }
    }

    private boolean relaxRule(UnaryRule ur) {
        UnaryRule bestR = this.bestRulesUnderMax.get(ur);
        if (bestR == null) {
            this.bestRulesUnderMax.put(ur, ur);
            this.closedRulesWithParent[ur.parent].add(ur);
            this.closedRulesWithChild[ur.child].add(ur);
            return true;
        }
        if (bestR.score < ur.score) {
            bestR.score = ur.score;
            return true;
        }
        return false;
    }

    public double scoreRule(UnaryRule ur) {
        UnaryRule bestR = this.bestRulesUnderMax.get(ur);
        return bestR != null ? (double)bestR.score : Double.NEGATIVE_INFINITY;
    }

    public void addRule(UnaryRule ur) {
        this.closeRulesUnderMax(ur);
        this.coreRules.put(ur, ur);
        this.rulesWithParent[ur.parent].add(ur);
        this.rulesWithChild[ur.child].add(ur);
    }

    void makeCRArrays() {
        this.closedRulesWithP = new UnaryRule[this.numStates][];
        this.closedRulesWithC = new UnaryRule[this.numStates][];
        for (int i = 0; i < this.numStates; ++i) {
            this.closedRulesWithP[i] = this.closedRulesWithParent[i].toArray(EMPTY_UNARY_RULE_ARRAY);
            this.closedRulesWithC[i] = this.closedRulesWithChild[i].toArray(EMPTY_UNARY_RULE_ARRAY);
        }
    }

    public UnaryRule[] closedRulesByParent(int state) {
        if (this.closedRulesWithP == null) {
            this.makeCRArrays();
        }
        if (state >= this.closedRulesWithP.length) {
            return EMPTY_UNARY_RULE_ARRAY;
        }
        return this.closedRulesWithP[state];
    }

    public UnaryRule[] closedRulesByChild(int state) {
        if (this.closedRulesWithC == null) {
            this.makeCRArrays();
        }
        if (state >= this.closedRulesWithC.length) {
            return EMPTY_UNARY_RULE_ARRAY;
        }
        return this.closedRulesWithC[state];
    }

    public Iterator<UnaryRule> closedRuleIteratorByParent(int state) {
        if (state >= this.closedRulesWithParent.length) {
            List lur = Collections.emptyList();
            return lur.iterator();
        }
        return this.closedRulesWithParent[state].iterator();
    }

    public Iterator<UnaryRule> closedRuleIteratorByChild(int state) {
        if (state >= this.closedRulesWithChild.length) {
            List lur = Collections.emptyList();
            return lur.iterator();
        }
        return this.closedRulesWithChild[state].iterator();
    }

    public Iterator<UnaryRule> ruleIteratorByParent(int state) {
        if (state >= this.rulesWithParent.length) {
            List lur = Collections.emptyList();
            return lur.iterator();
        }
        return this.rulesWithParent[state].iterator();
    }

    public Iterator<UnaryRule> ruleIteratorByChild(int state) {
        if (state >= this.rulesWithChild.length) {
            List lur = Collections.emptyList();
            return lur.iterator();
        }
        return this.rulesWithChild[state].iterator();
    }

    public List<UnaryRule> rulesByParent(int state) {
        if (state >= this.rulesWithParent.length) {
            List<UnaryRule> lur = Collections.emptyList();
            return lur;
        }
        return this.rulesWithParent[state];
    }

    public List<UnaryRule> rulesByChild(int state) {
        if (state >= this.rulesWithChild.length) {
            List<UnaryRule> lur = Collections.emptyList();
            return lur;
        }
        return this.rulesWithChild[state];
    }

    public List[] rulesWithParent() {
        return this.rulesWithParent;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        HashSet<UnaryRule> allRules = new HashSet<UnaryRule>(this.coreRules.keySet());
        this.init();
        for (UnaryRule ur : allRules) {
            this.addRule(ur);
        }
        this.purgeRules();
    }

    private void init() {
        this.coreRules = new HashMap<UnaryRule, UnaryRule>();
        this.rulesWithParent = new List[this.numStates];
        this.rulesWithChild = new List[this.numStates];
        this.closedRulesWithParent = new List[this.numStates];
        this.closedRulesWithChild = new List[this.numStates];
        this.bestRulesUnderMax = new HashMap<UnaryRule, UnaryRule>();
        this.backTrace = new HashMap<UnaryRule, Integer>();
        for (int s = 0; s < this.numStates; ++s) {
            this.rulesWithParent[s] = new ArrayList<UnaryRule>();
            this.rulesWithChild[s] = new ArrayList<UnaryRule>();
            this.closedRulesWithParent[s] = new ArrayList<UnaryRule>();
            this.closedRulesWithChild[s] = new ArrayList<UnaryRule>();
            UnaryRule selfR = new UnaryRule(s, s, 0.0);
            this.relaxRule(selfR);
        }
    }

    public UnaryGrammar(int numStates) {
        this(numStates, "states");
    }

    public UnaryGrammar(int numStates, String stateSpace) {
        this.numStates = numStates;
        this.stateSpace = stateSpace;
        this.init();
    }

    public void readData(BufferedReader in) throws IOException {
        int lineNum = 1;
        Numberer n = Numberer.getGlobalNumberer(this.stateSpace);
        String line = in.readLine();
        while (line != null && line.length() > 0) {
            try {
                this.addRule(new UnaryRule(line, n));
            }
            catch (Exception e) {
                throw new IOException("Error on line " + lineNum);
            }
            ++lineNum;
            line = in.readLine();
        }
        this.purgeRules();
    }

    public void writeData(Writer w) throws IOException {
        PrintWriter out2 = new PrintWriter(w);
        Iterator<UnaryRule> rI = this.ruleIterator();
        while (rI.hasNext()) {
            out2.println(((Object)rI.next()).toString());
        }
        out2.flush();
    }

    public String toString() {
        StringWriter w = new StringWriter();
        try {
            this.writeData(w);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ((Object)w).toString();
    }
}

