/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling;

import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.ling.TaggedWordFactory;
import edu.stanford.nlp.ling.Word;

public class TaggedWord
extends Word
implements HasTag {
    private String tag;
    private static String divider = "/";

    public TaggedWord() {
    }

    public TaggedWord(String word) {
        super(word);
    }

    public TaggedWord(String word, String tag) {
        super(word);
        this.tag = tag;
    }

    public TaggedWord(Label oldLabel) {
        super(oldLabel.value());
        if (oldLabel instanceof HasTag) {
            this.tag = ((HasTag)((Object)oldLabel)).tag();
        }
    }

    public TaggedWord(Label word, Label tag) {
        super(word);
        this.tag = tag.value();
    }

    public String tag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String toString() {
        return this.word() + divider + this.tag;
    }

    public static void setDivider(String divider) {
        TaggedWord.divider = divider;
    }

    public void setFromString(String taggedWord) {
        int where = taggedWord.lastIndexOf(divider);
        if (where >= 0) {
            this.setWord(taggedWord.substring(0, where));
            this.setTag(taggedWord.substring(where + 1));
        } else {
            this.setWord(taggedWord);
            this.setTag(null);
        }
    }

    public LabelFactory labelFactory() {
        return LabelFactoryHolder.lf;
    }

    public static LabelFactory factory() {
        return LabelFactoryHolder.lf;
    }

    private static class LabelFactoryHolder {
        private static final LabelFactory lf = new TaggedWordFactory();

        private LabelFactoryHolder() {
        }
    }
}

