/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.item;

import edu.mit.jwi.item.ILexFile;
import edu.mit.jwi.item.ISenseKey;
import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.LexFile;
import edu.mit.jwi.item.POS;
import edu.mit.jwi.item.Word;

public class SenseKey
implements ISenseKey {
    private final String lemma;
    private final int lexID;
    private final POS pos;
    private final boolean isAdjSat;
    private final ILexFile lexFile;
    private boolean isHeadSet;
    private String headLemma = null;
    private int headLexID = -1;
    private String toString;
    private static final char colon = ':';
    private static final char percent = '%';
    private static final String unknown = "??";

    public SenseKey(String lemma, int lexID, ISynset synset) {
        this(lemma, lexID, synset.getPOS(), synset.isAdjectiveSatellite(), synset.getLexicalFile());
    }

    public SenseKey(String lemma, int lexID, POS pos, boolean isAdjSat, ILexFile lexFile) {
        if (pos == null || lexFile == null) {
            throw new NullPointerException();
        }
        this.lemma = lemma.toLowerCase();
        this.lexID = lexID;
        this.pos = pos;
        this.isAdjSat = isAdjSat;
        this.lexFile = lexFile;
        this.isHeadSet = !isAdjSat;
    }

    public SenseKey(String lemma, int lexID, POS pos, boolean isAdjSat, ILexFile lexFile, String originalKey) {
        this(lemma, lexID, pos, isAdjSat, lexFile);
        if (originalKey == null) {
            throw new NullPointerException();
        }
        this.toString = originalKey;
    }

    public SenseKey(String lemma, int lexID, POS pos, ILexFile lexFile, String headLemma, int headLexID, String originalKey) {
        this(lemma, lexID, pos, headLemma != null, lexFile);
        if (headLemma == null) {
            this.isHeadSet = true;
        } else {
            this.setHead(headLemma, headLexID);
        }
        if (originalKey == null) {
            throw new NullPointerException();
        }
        this.toString = originalKey;
    }

    public String getLemma() {
        return this.lemma;
    }

    public int getLexicalID() {
        return this.lexID;
    }

    public POS getPOS() {
        return this.pos;
    }

    public int getSynsetType() {
        return this.isAdjSat ? 5 : this.pos.getNumber();
    }

    public boolean isAdjectiveSatellite() {
        return this.isAdjSat;
    }

    public ILexFile getLexicalFile() {
        return this.lexFile;
    }

    public void setHead(String headLemma, int headLexID) {
        if (this.isHeadSet) {
            throw new IllegalStateException();
        }
        Word.checkLexicalID(headLexID);
        if (headLemma.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.headLemma = headLemma;
        this.headLexID = headLexID;
        this.isHeadSet = true;
    }

    public String getHeadWord() {
        if (!this.isHeadSet) {
            throw new IllegalStateException("Head word and id not yet set");
        }
        return this.headLemma;
    }

    public int getHeadID() {
        if (!this.isHeadSet) {
            throw new IllegalStateException("Head word and id not yet set");
        }
        return this.headLexID;
    }

    public boolean needsHeadSet() {
        return !this.isHeadSet;
    }

    public int compareTo(ISenseKey key) {
        int cmp = this.getLemma().compareTo(key.getLemma());
        if (cmp != 0) {
            return cmp;
        }
        cmp = Float.compare(this.getSynsetType(), key.getSynsetType());
        if (cmp != 0) {
            return cmp;
        }
        cmp = Float.compare(this.getLexicalFile().getNumber(), key.getLexicalFile().getNumber());
        if (cmp != 0) {
            return cmp;
        }
        cmp = Float.compare(this.getLexicalID(), key.getLexicalID());
        if (cmp != 0) {
            return cmp;
        }
        if (!this.isAdjectiveSatellite() && !key.isAdjectiveSatellite()) {
            return 0;
        }
        if (!this.isAdjectiveSatellite() & key.isAdjectiveSatellite()) {
            return -1;
        }
        if (this.isAdjectiveSatellite() & !key.isAdjectiveSatellite()) {
            return 1;
        }
        cmp = this.getHeadWord().compareTo(key.getHeadWord());
        if (cmp != 0) {
            return cmp;
        }
        return Float.compare(this.getHeadID(), key.getHeadID());
    }

    public String toString() {
        if (!this.isHeadSet) {
            throw new IllegalStateException("Head word and id not yet set");
        }
        if (this.toString == null) {
            this.toString = SenseKey.toString(this);
        }
        return this.toString;
    }

    public static String toString(ISenseKey key) {
        int size = key.getLemma().length() + 10;
        if (key.isAdjectiveSatellite()) {
            size += key.getHeadWord().length() + 2;
        }
        StringBuilder sb = new StringBuilder(size);
        sb.append(key.getLemma().toLowerCase());
        sb.append('%');
        sb.append(key.getSynsetType());
        sb.append(':');
        sb.append(LexFile.getLexicalFileNumberString(key.getLexicalFile().getNumber()));
        sb.append(':');
        sb.append(Word.getLexicalIDForSenseKey(key.getLexicalID()));
        sb.append(':');
        if (key.isAdjectiveSatellite()) {
            if (key.needsHeadSet()) {
                sb.append(unknown);
            } else {
                sb.append(key.getHeadWord());
            }
        }
        sb.append(':');
        if (key.isAdjectiveSatellite()) {
            if (key.needsHeadSet()) {
                sb.append(unknown);
            } else {
                sb.append(Word.getLexicalIDForSenseKey(key.getHeadID()));
            }
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.lemma.hashCode();
        result = 31 * result + this.lexID;
        result = 31 * result + this.pos.hashCode();
        result = 31 * result + this.lexFile.hashCode();
        result = 31 * result + (this.isAdjSat ? 1231 : 1237);
        if (this.isAdjSat) {
            result = 31 * result + (this.headLemma == null ? 0 : this.headLemma.hashCode());
            result = 31 * result + this.headLexID;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ISenseKey)) {
            return false;
        }
        ISenseKey other = (ISenseKey)obj;
        if (!this.lemma.equals(other.getLemma())) {
            return false;
        }
        if (this.lexID != other.getLexicalID()) {
            return false;
        }
        if (this.pos != other.getPOS()) {
            return false;
        }
        if (this.lexFile.getNumber() != other.getLexicalFile().getNumber()) {
            return false;
        }
        if (this.isAdjSat != other.isAdjectiveSatellite()) {
            return false;
        }
        if (this.isAdjSat) {
            if (!this.headLemma.equals(other.getHeadWord())) {
                return false;
            }
            if (this.headLexID != other.getHeadID()) {
                return false;
            }
        }
        return true;
    }
}

