/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.data;

import edu.mit.jwi.data.IContentType;
import edu.mit.jwi.data.WordnetFile;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectAccessWordnetFile<T>
extends WordnetFile<T> {
    public DirectAccessWordnetFile(File file, IContentType<T> contentType) throws IOException {
        super(file, contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLine(String key) {
        ByteBuffer byteBuffer = this.fBuffer;
        synchronized (byteBuffer) {
            try {
                Integer byteOffset = Integer.parseInt(key);
                if (this.fBuffer.limit() <= byteOffset) {
                    return null;
                }
                this.fBuffer.position(byteOffset);
                String line = DirectAccessWordnetFile.getLine(this.fBuffer);
                return line.startsWith(key) ? line : null;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    @Override
    public Iterator<String> iterator() {
        return new DirectLineIterator((ByteBuffer)this.fMappedBuffer);
    }

    @Override
    public Iterator<String> iterator(String key) {
        return new DirectLineIterator((ByteBuffer)this.fMappedBuffer, key);
    }

    public class DirectLineIterator
    extends WordnetFile.LineIterator {
        ByteBuffer fMyBuffer;
        String previous;
        String next;

        public DirectLineIterator(ByteBuffer file) {
            this(file, null);
        }

        public DirectLineIterator(ByteBuffer buffer, String key) {
            super(DirectAccessWordnetFile.this, buffer, key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void findFirstLine(String key) {
            ByteBuffer byteBuffer = this.fMyBuffer;
            synchronized (byteBuffer) {
                try {
                    Integer byteOffset = Integer.parseInt(key);
                    if (DirectAccessWordnetFile.this.fBuffer.limit() <= byteOffset) {
                        return;
                    }
                    this.fMyBuffer.position(byteOffset);
                    this.next = WordnetFile.getLine(this.fMyBuffer);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }
}

