/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.model.change;

import edu.mit.story.core.StoryMessages;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.change.AbstractModelChange;
import edu.mit.story.core.model.change.DescFactoryChange;
import edu.mit.story.core.model.change.Flag;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.model.change.StoryChangeEventIntegrator;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import edu.mit.story.core.util.IHasProgressMonitor;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class CascadingModelChange
extends AbstractModelChange
implements IHasProgressMonitor {
    public final IModelChange change;
    protected IProgressMonitor monitor = new NullProgressMonitor();

    public CascadingModelChange(IModelChange change) {
        super(change.getName());
        if (change == null) {
            throw new NullPointerException();
        }
        this.change = change;
    }

    public boolean setProgressMonitor(IProgressMonitor newMonitor) {
        if (this.monitor == newMonitor) {
            return false;
        }
        this.monitor = newMonitor == null ? new NullProgressMonitor() : newMonitor;
        return true;
    }

    public IProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    protected StoryChangeEvent doApply(Object source, IMutableStoryModel model) {
        this.monitor.beginTask(StoryMessages.MSG_PROGRESS_TaskUpdatingDescriptions, model.repSize() + 1);
        this.monitor.subTask(StoryMessages.MSG_PROGRESS_SubtaskApplyingOriginal);
        StoryChangeEvent event = this.change.apply(source, model);
        this.monitor.worked(1);
        if (event == null) {
            return null;
        }
        StoryChangeEventIntegrator integrator = new StoryChangeEventIntegrator(event);
        Iterator i = model.repIterator();
        while (i.hasNext()) {
            IRep updateRep = (IRep)i.next();
            this.monitor.subTask(NLS.bind((String)StoryMessages.MSG_PROGRESS_SubtaskCascadingChanges, (Object)updateRep.getID()));
            boolean anteChanged = false;
            IRepSet antes = updateRep.getAntecedents();
            for (IRep ante : antes) {
                if (!integrator.changed(ante, Flag.DESCS)) continue;
                anteChanged = true;
                break;
            }
            if (anteChanged) {
                DescFactoryChange factChange = new DescFactoryChange(updateRep, integrator.asEvent());
                event = factChange.apply(source, model);
                integrator.addEvent(event);
            }
            this.monitor.worked(1);
        }
        return integrator.asEvent();
    }

    public IModelChange getWrappedChange() {
        return this.change;
    }

    public IModelChange combineWith(IModelChange change) {
        return null;
    }
}

