/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.pos;

import edu.mit.parsing.core.rep.pos.ITag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum GenericTag implements ITag
{
    NOUN("NN", "Noun", "A word that indicates an object, abstract or concrete"),
    VERB("VB", "Verb", "A word that indicates a state, event, or process"),
    ADJECTIVE("JJ", "Adjective", "A modifier to a noun"),
    ADVERB("RB", "Adverb", "A modifier to a verb"),
    PROPER_NOUN("PN", "Proper Noun", "A proper noun, such as a name"),
    FUNCTION("FN", "Function", "A grammatical function (closed class) word"),
    SYMBOL("SY", "Symbol", "A symbol or punctuation"),
    TOKEN("TK", "Other", "A token-level tag other than the tags above"),
    PHRASAL("PH", "Phrase", "A phrasal tag"),
    UNKNOWN("UN", "Unknown", "An unclassified tag");

    final String fTag;
    final String fName;
    final String fDesc;

    private GenericTag(String tag, String name, String description) {
        this.fTag = tag;
        this.fName = name;
        this.fDesc = description;
    }

    @Override
    public String getTagString() {
        return this.fTag;
    }

    public String getName() {
        return this.fName;
    }

    public String getDescription() {
        return this.fDesc;
    }

    @Override
    public GenericTag toGenericTag() {
        return this;
    }

    public String toString() {
        return this.fName;
    }

    @Override
    public boolean isOpenClass() {
        return this == NOUN || this == VERB || this == ADJECTIVE || this == ADVERB || this == PROPER_NOUN;
    }

    @Override
    public boolean isNoun() {
        return this == NOUN;
    }

    @Override
    public boolean isVerb() {
        return this == VERB;
    }

    @Override
    public boolean isAdverb() {
        return this == ADVERB;
    }

    @Override
    public boolean isAdjective() {
        return this == ADJECTIVE;
    }

    @Override
    public boolean isProperNoun() {
        return this == PROPER_NOUN;
    }

    @Override
    public boolean isPhrase() {
        return this == PHRASAL || this == UNKNOWN;
    }

    @Override
    public boolean isToken() {
        return this != PHRASAL;
    }

    @Override
    public boolean isStemmable() {
        return this == NOUN || this == VERB || this == ADJECTIVE || this == ADVERB;
    }
}

