/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.widgets;

import edu.mit.story.core.notify.ChangeNotifier;
import edu.mit.story.core.notify.IChangeNotifier;
import edu.mit.story.core.validation.Message;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.controllers.IHasAnnotationController;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationWidget<C extends IHasAnnotationController>
extends Composite
implements IChangeNotifier,
ChangeListener {
    private final ChangeNotifier notifier;
    protected final C controller;
    protected Button annotateButton;
    protected IMessageProvider message = Message.NO_MESSAGE;

    public AnnotationWidget(Composite parent, int style, C controller) {
        super(parent, style);
        if (controller == null) {
            throw new NullPointerException();
        }
        this.controller = controller;
        this.notifier = new ChangeNotifier();
        controller.getAnnotationController().getAnnotationModel().addChangeListener(this);
        this.setBackground(parent.getBackground());
        this.setForeground(parent.getForeground());
        this.createControl(this);
        this.updateFromModel();
    }

    public C getController() {
        return this.controller;
    }

    public Button getAnnotateButton() {
        return this.annotateButton;
    }

    protected abstract void createControl(Composite var1);

    protected final void updateAnnotationWidgetFromModel() {
        boolean isAnnotating = this.controller.getAnnotationController().getAnnotationModel().isAnnotating();
        if (this.annotateButton.getSelection() != isAnnotating) {
            this.annotateButton.setSelection(isAnnotating);
        }
        this.updateFromModel();
    }

    protected abstract void updateFromModel();

    protected void createAnnotateButton(Composite parent) {
        this.annotateButton = new Button(parent, 2);
        this.annotateButton.setImage(StoryUIPlugin.getDefault().getImageRegistry().get("ctool13/light13.gif"));
        this.annotateButton.setToolTipText("Annotate in Editor");
        this.annotateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AnnotationWidget.this.controller.getAnnotationController().setAnnotating(AnnotationWidget.this.annotateButton.getSelection());
            }
        });
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateAnnotationWidgetFromModel();
    }

    public void notifyChangeListeners(Object source) {
        this.notifier.notifyChangeListeners(source);
    }

    public void addChangeListener(ChangeListener listener) {
        this.notifier.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.notifier.removeChangeListener(listener);
    }

    public void allowNotifications() {
        this.notifier.allowNotifications();
    }

    public void suppressNotifications() {
        this.notifier.suppressNotifications();
    }
}

