/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.resolutions;

import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.build.StoryProblem;
import edu.mit.story.core.desc.IDescMultiSet;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.editor.StoryEditor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public abstract class AbstractProblemResolution
extends WorkbenchMarkerResolution {
    private final IMarker[] noMarkers = new IMarker[0];
    private String label;
    private String desc;
    private Image image;

    public AbstractProblemResolution(String label, String desc, Image image) {
        this.label = label;
        this.desc = desc;
        this.image = image;
    }

    public final void run(IMarker marker) {
        if (!(marker.getResource() instanceof IFile)) {
            return;
        }
        IStoryEditor editor = StoryEditor.getStoryEditor((IFile)marker.getResource());
        if (editor == null) {
            return;
        }
        StoryProblem problem = StoryProblem.toProblem((IMarker)marker, (IDescMultiSet)editor.getStoryModel().getData());
        if (problem == null) {
            return;
        }
        this.doRun((IStoryProblem)problem, editor);
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        return this.noMarkers;
    }

    protected abstract void doRun(IStoryProblem var1, IStoryEditor var2);

    public Image getImage() {
        if (this.image == null) {
            this.image = StoryUIPlugin.getDefault().getImageRegistry().get("obj16/story.gif");
        }
        return this.image;
    }

    public String getDescription() {
        return this.desc;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setDescription(String desc) {
        this.desc = desc;
    }

    public void setImage(Image image) {
        this.image = image;
    }
}

