/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.content;

import edu.mit.story.core.datamodel.IModelWrapper;
import edu.mit.story.core.datamodel.IViewModel;
import edu.mit.story.core.desc.DescSet;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.meta.IMetaDataSet;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.merge.MergeMetaRep;
import edu.mit.story.core.meta.note.NoteMetaRep;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.util.IClearable;
import edu.mit.story.ui.editor.IHasStoryEditor;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.label.StoryModelLabelProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StoryEditorContentProvider
implements IHasRep,
ITreeContentProvider,
IHasStoryEditor {
    private final IRep rep;
    private final StoryModelLabelProvider.INoElementsMessage noneMessage;
    private final Set<String> sources;
    private IStoryEditor editor = null;
    public static final Object[] emptyArray = new Object[0];

    public StoryEditorContentProvider(IRep rep, IStoryEditor editor, String noElementsMessage) {
        this(rep, editor, noElementsMessage, null);
    }

    public StoryEditorContentProvider(IRep rep, IStoryEditor editor, String noElementsMessage, Collection<? extends String> sources) {
        if (rep == null) {
            throw new NullPointerException();
        }
        if (noElementsMessage == null || noElementsMessage.trim().length() == 0) {
            noElementsMessage = "(no descriptions)";
        }
        this.sources = sources == null || sources.isEmpty() ? null : Collections.unmodifiableSet(new HashSet<String>(sources));
        this.rep = rep;
        this.noneMessage = new StoryModelLabelProvider.NoElementsMessage(noElementsMessage);
        this.inputChanged(null, null, editor);
    }

    public IRep getRep() {
        return this.rep;
    }

    public StoryModelLabelProvider.INoElementsMessage getNoElementsMessage() {
        return this.noneMessage;
    }

    public Set<String> getSources() {
        return this.sources;
    }

    @Override
    public IStoryEditor getStoryEditor() {
        return this.editor;
    }

    @Override
    public void setStoryEditor(IStoryEditor newEditor) {
        this.editor = newEditor;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.setStoryEditor(newInput instanceof IStoryEditor ? (IStoryEditor)newInput : null);
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IModelWrapper) {
            IViewModel[] models;
            IModelWrapper wrapper = (IModelWrapper)element;
            IViewModel[] iViewModelArray = models = wrapper.getModels();
            int n = models.length;
            int n2 = 0;
            while (n2 < n) {
                IViewModel model = iViewModelArray[n2];
                if (!(model instanceof IClearable) || !model.isCleared()) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        if (element instanceof IStoryEditor) {
            return true;
        }
        if (element instanceof IStoryModel) {
            return true;
        }
        if (element instanceof IDesc) {
            IDesc desc = (IDesc)element;
            IMetaDataSet notes = desc.getMetaData().get((IMetaRep)NoteMetaRep.getInstance());
            return !notes.isEmpty();
        }
        if (element instanceof IMetaDataSet) {
            IMetaDataSet descs = (IMetaDataSet)element;
            return !descs.isEmpty();
        }
        return false;
    }

    public Object[] getChildren(Object parent) {
        IDesc desc;
        IMetaDataSet notes;
        if (parent instanceof IModelWrapper) {
            IModelWrapper wrapper = (IModelWrapper)parent;
            IViewModel[] models = wrapper.getModels();
            ArrayList<IViewModel> result = new ArrayList<IViewModel>(models.length);
            IViewModel[] iViewModelArray = models;
            int n = models.length;
            int n2 = 0;
            while (n2 < n) {
                IViewModel model = iViewModelArray[n2];
                if (!(model instanceof IClearable) || !model.isCleared()) {
                    result.add(model);
                }
                ++n2;
            }
            return result.toArray();
        }
        if (parent instanceof IStoryEditor) {
            IStoryEditor editor = (IStoryEditor)parent;
            return new Object[]{editor.getStoryModel()};
        }
        if (parent instanceof IStoryModel) {
            IStoryModel model = (IStoryModel)parent;
            IDescSet descs = model.getData().getDescriptions(this.getRep());
            if (this.sources != null) {
                DescSet result = new DescSet(descs.getRep());
                for (IDesc d : descs) {
                    if (!MergeMetaRep.matches((IDesc)d, this.sources)) continue;
                    result.add((Object)d);
                }
                descs = result;
            }
            if (descs.isEmpty()) {
                return new Object[]{this.noneMessage};
            }
            return descs.toArray();
        }
        if (parent instanceof IDesc && !(notes = (desc = (IDesc)parent).getMetaData().get((IMetaRep)NoteMetaRep.getInstance())).isEmpty()) {
            return new Object[]{notes};
        }
        if (parent instanceof IMetaDataSet) {
            IMetaDataSet descs = (IMetaDataSet)parent;
            return descs.toArray();
        }
        return null;
    }

    public Object getParent(Object child) {
        return null;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        this.editor = null;
    }

    public static Element makeChild(Object parent, Object child) {
        return StoryEditorContentProvider.makeChild(-1, parent, child);
    }

    public static Element makeChild(int type, Object parent, Object child) {
        if (child instanceof IHasPosition) {
            return new ElementPos(type, parent, (IHasPosition)child);
        }
        return new Element(type, parent, child);
    }

    public static boolean isElement(Object element, int type) {
        return StoryEditorContentProvider.isElement(element, null, type);
    }

    public static boolean isElement(Object element, Class<?> childCls) {
        return StoryEditorContentProvider.isElement(element, childCls, 0);
    }

    public static boolean isElement(Object obj, Class<?> classe, int type) {
        if (classe == null && type == 0) {
            throw new IllegalArgumentException();
        }
        if (!(obj instanceof Element)) {
            return false;
        }
        Element child = (Element)obj;
        if (classe != null && !classe.isAssignableFrom(child.getElement().getClass())) {
            return false;
        }
        return type == 0 || child.getType() == type;
    }

    public static class Element
    implements IAdaptable {
        private final int type;
        private final Object parent;
        private final Object element;

        protected Element(int type, Object parent, Object element) {
            if (parent == null) {
                throw new NullPointerException();
            }
            if (element == null) {
                throw new NullPointerException();
            }
            this.type = type;
            this.parent = parent;
            this.element = element;
        }

        public int getType() {
            return this.type;
        }

        public Object getParent() {
            return this.parent;
        }

        public Object getElement() {
            return this.element;
        }

        public Object getAdapter(Class adapter) {
            if (adapter.isAssignableFrom(this.element.getClass())) {
                return this.element;
            }
            return null;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.element.hashCode();
            result = 31 * result + this.parent.hashCode();
            result = 31 * result + this.type;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Element other = (Element)obj;
            if (!this.element.equals(other.element)) {
                return false;
            }
            if (!this.parent.equals(other.parent)) {
                return false;
            }
            return this.type == other.type;
        }
    }

    public static class ElementPos
    extends Element
    implements IHasPosition {
        protected ElementPos(int type, Object parent, IHasPosition element) {
            super(type, parent, element);
        }

        public IHasPosition getElement() {
            return (IHasPosition)super.getElement();
        }

        public int getLength() {
            return this.getElement().getLength();
        }

        public int getOffset() {
            return this.getElement().getOffset();
        }

        public int getRightOffset() {
            return this.getElement().getRightOffset();
        }
    }
}

