/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards.dialogs;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.compare.SVNLocalCompareInput;
import org.tigris.subversion.subclipse.ui.dialogs.CompareDialog;
import org.tigris.subversion.subclipse.ui.util.ResourceSelectionTree;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialog;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialogPage;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardRevertPage;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class SvnWizardRevertPage
extends SvnWizardDialogPage {
    private IResource[] resourcesToRevert;
    private Object[] selectedResources;
    private HashMap statusMap;
    private ResourceSelectionTree resourceSelectionTree;
    private boolean resourceRemoved;
    private Button includeUnversionedButton;
    private boolean includeUnversioned;
    private boolean fromSyncView;

    public SvnWizardRevertPage(IResource[] resourcesToRevert, String url, HashMap statusMap, boolean fromSyncView) {
        super("RevertDialog", Policy.bind("RevertDialog.title"));
        this.fromSyncView = fromSyncView;
        this.includeUnversioned = fromSyncView ? true : SVNUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_select_unadded_resources_on_commit");
        this.resourcesToRevert = resourcesToRevert;
        this.statusMap = statusMap;
    }

    public void createControls(Composite outerContainer) {
        Composite composite = new Composite(outerContainer, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        ResourceSelectionTree.IToolbarControlCreator toolbarControlCreator = new ResourceSelectionTree.IToolbarControlCreator(){

            public void createToolbarControls(ToolBarManager toolbarManager) {
                toolbarManager.add((IContributionItem)new ControlContribution(this, "ignoreUnversioned"){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    protected Control createControl(Composite parent) {
                        SvnWizardRevertPage.access$0(1.access$0(this.this$1), new Button(parent, 32));
                        SvnWizardRevertPage.access$1(1.access$0(this.this$1)).setText(Policy.bind("CommitDialog.includeUnversioned"));
                        SvnWizardRevertPage.access$1(1.access$0(this.this$1)).setSelection(SvnWizardRevertPage.access$2(1.access$0(this.this$1)));
                        SvnWizardRevertPage.access$1(1.access$0(this.this$1)).addSelectionListener(new SelectionListener(this){
                            final /* synthetic */ 2 this$2;
                            {
                                this.this$2 = var1_1;
                            }

                            public void widgetSelected(SelectionEvent e) {
                                SvnWizardRevertPage.access$3(1.access$0(2.access$0(this.this$2)), SvnWizardRevertPage.access$1(1.access$0(2.access$0(this.this$2))).getSelection());
                                if (!SvnWizardRevertPage.access$2(1.access$0(2.access$0(this.this$2)))) {
                                    SvnWizardRevertPage.access$4(1.access$0(2.access$0(this.this$2))).removeUnversioned();
                                } else {
                                    SvnWizardRevertPage.access$4(1.access$0(2.access$0(this.this$2))).addUnversioned();
                                }
                                SvnWizardRevertPage.access$5(1.access$0(2.access$0(this.this$2)), SvnWizardRevertPage.access$4(1.access$0(2.access$0(this.this$2))).getSelectedResources());
                                1.access$0(2.access$0(this.this$2)).setPageComplete(SvnWizardRevertPage.access$6(1.access$0(2.access$0(this.this$2))));
                                if (!SvnWizardRevertPage.access$7(1.access$0(2.access$0(this.this$2)))) {
                                    1.access$0(2.access$0(this.this$2)).updatePreference(SvnWizardRevertPage.access$2(1.access$0(2.access$0(this.this$2))));
                                }
                            }

                            public void widgetDefaultSelected(SelectionEvent e) {
                            }
                        });
                        return SvnWizardRevertPage.access$1(1.access$0(this.this$1));
                    }

                    static /* synthetic */ 1 access$0(2 var0) {
                        return var0.this$1;
                    }
                });
            }

            public int getControlCount() {
                return 1;
            }

            static /* synthetic */ SvnWizardRevertPage access$0(1 var0) {
                return var0.SvnWizardRevertPage.this;
            }
        };
        this.resourceSelectionTree = new ResourceSelectionTree(composite, 0, Policy.bind("GenerateSVNDiff.Changes"), this.resourcesToRevert, this.statusMap, null, true, toolbarControlCreator, null);
        if (!this.resourceSelectionTree.showIncludeUnversionedButton()) {
            this.includeUnversionedButton.setVisible(false);
        }
        this.resourceSelectionTree.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SvnWizardRevertPage.this.selectedResources = SvnWizardRevertPage.this.resourceSelectionTree.getSelectedResources();
            }
        });
        ((CheckboxTreeViewer)this.resourceSelectionTree.getTreeViewer()).addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                SvnWizardRevertPage.this.selectedResources = SvnWizardRevertPage.this.resourceSelectionTree.getSelectedResources();
            }
        });
        this.resourceSelectionTree.getTreeViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                Object sel0 = sel.getFirstElement();
                if (sel0 instanceof IFile) {
                    ISVNLocalResource localResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)((IFile)sel0));
                    try {
                        new CompareDialog(SvnWizardRevertPage.this.getShell(), new SVNLocalCompareInput(localResource, SVNRevision.BASE, true)).open();
                    }
                    catch (SVNException sVNException) {}
                }
            }
        });
        if (!this.includeUnversioned) {
            this.resourceSelectionTree.removeUnversioned();
        }
        this.resourceSelectionTree.getTreeViewer().getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.selectedResources = this.resourceSelectionTree.getSelectedResources();
        this.setPageComplete(this.canFinish());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.revert_dialog_context");
    }

    public boolean performCancel() {
        return true;
    }

    public boolean performFinish() {
        this.resourceRemoved = this.resourceSelectionTree.isResourceRemoved();
        return true;
    }

    public void setMessage() {
        this.setMessage(Policy.bind("RevertDialog.resources"));
    }

    public void saveSettings() {
    }

    public IResource[] getSelectedResources() {
        if (this.selectedResources == null) {
            return this.resourcesToRevert;
        }
        List<Object> result = Arrays.asList(this.selectedResources);
        return result.toArray(new IResource[result.size()]);
    }

    public String getWindowTitle() {
        return Policy.bind("RevertDialog.title");
    }

    public void createButtonsForButtonBar(Composite parent, SvnWizardDialog wizardDialog) {
    }

    public boolean isResourceRemoved() {
        return this.resourceRemoved;
    }

    public void updatePreference(boolean includeUnversioned) {
        SVNUIPlugin.getPlugin().getPreferenceStore().setValue("pref_select_unadded_resources_on_commit", includeUnversioned);
    }

    private boolean canFinish() {
        return this.selectedResources.length > 0;
    }

    static /* synthetic */ void access$0(SvnWizardRevertPage svnWizardRevertPage, Button button) {
        svnWizardRevertPage.includeUnversionedButton = button;
    }

    static /* synthetic */ Button access$1(SvnWizardRevertPage svnWizardRevertPage) {
        return svnWizardRevertPage.includeUnversionedButton;
    }

    static /* synthetic */ boolean access$2(SvnWizardRevertPage svnWizardRevertPage) {
        return svnWizardRevertPage.includeUnversioned;
    }

    static /* synthetic */ void access$3(SvnWizardRevertPage svnWizardRevertPage, boolean bl) {
        svnWizardRevertPage.includeUnversioned = bl;
    }

    static /* synthetic */ boolean access$6(SvnWizardRevertPage svnWizardRevertPage) {
        return svnWizardRevertPage.canFinish();
    }

    static /* synthetic */ boolean access$7(SvnWizardRevertPage svnWizardRevertPage) {
        return svnWizardRevertPage.fromSyncView;
    }
}

