/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.repository;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.PluginTransferData;
import org.eclipse.ui.part.ViewPart;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.resources.RemoteFile;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.WorkspacePathValidator;
import org.tigris.subversion.subclipse.ui.actions.OpenRemoteFileAction;
import org.tigris.subversion.subclipse.ui.actions.RemoteResourceTransfer;
import org.tigris.subversion.subclipse.ui.actions.SVNAction;
import org.tigris.subversion.subclipse.ui.repository.IRepositoryListener;
import org.tigris.subversion.subclipse.ui.repository.RemoveRootAction;
import org.tigris.subversion.subclipse.ui.repository.RepositoriesViewDecorator;
import org.tigris.subversion.subclipse.ui.repository.RepositorySorter;
import org.tigris.subversion.subclipse.ui.repository.model.AllRootsElement;
import org.tigris.subversion.subclipse.ui.repository.model.RemoteContentProvider;
import org.tigris.subversion.subclipse.ui.wizards.NewLocationWizard;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizard;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialog;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardNewRepositoryPage;

public class RepositoriesView
extends ViewPart
implements ISelectionListener {
    public static final String VIEW_ID = "org.tigris.subversion.subclipse.ui.repository.RepositoriesView";
    private AllRootsElement root;
    private Action newAction;
    private RemoveRootAction removeRootAction;
    protected TreeViewer treeViewer;
    private DrillDownAdapter drillPart;
    private Action refreshAction;
    private Action refreshPopupAction;
    private Action collapseAllAction;
    private OpenRemoteFileAction openAction;
    private Action propertiesAction;
    private RemoteContentProvider contentProvider;
    private IRepositoryListener repositoryListener = new IRepositoryListener(){

        public void repositoryAdded(ISVNRepositoryLocation root) {
            RepositoriesView.this.getViewer().getControl().getDisplay().syncExec(new Runnable(this, root){
                final /* synthetic */ 1 this$1;
                private final /* synthetic */ ISVNRepositoryLocation val$root;
                {
                    this.this$1 = var1_1;
                    this.val$root = iSVNRepositoryLocation;
                }

                public void run() {
                    1.access$0(this.this$1).refreshViewer(null, false);
                    1.access$0(this.this$1).getViewer().setSelection((ISelection)new StructuredSelection((Object)this.val$root));
                }
            });
        }

        public void repositoryRemoved(ISVNRepositoryLocation root) {
            this.refresh(null, false);
        }

        public void repositoriesChanged(ISVNRepositoryLocation[] roots) {
            this.refresh(null, false);
        }

        public void remoteResourceDeleted(ISVNRemoteResource resource) {
            this.refresh(resource.getParent(), false);
        }

        public void remoteResourceCreated(ISVNRemoteFolder parent, String resourceName) {
            this.refresh(parent, true);
        }

        public void remoteResourceCopied(ISVNRemoteResource source, ISVNRemoteFolder destination) {
            this.refresh(destination, false);
        }

        public void remoteResourceMoved(ISVNRemoteResource resource, ISVNRemoteFolder destinationFolder, String destinationResourceName) {
            this.refresh(resource.getParent(), false);
            this.refresh(destinationFolder, false);
        }

        private void refresh(Object object, boolean refreshRepositoriesFolders) {
            Object finalObject = object;
            boolean finalRefreshReposFolders = refreshRepositoriesFolders;
            Display display = RepositoriesView.this.getViewer().getControl().getDisplay();
            display.syncExec(new Runnable(this, finalObject, finalRefreshReposFolders){
                final /* synthetic */ 1 this$1;
                private final /* synthetic */ Object val$finalObject;
                private final /* synthetic */ boolean val$finalRefreshReposFolders;
                {
                    this.this$1 = var1_1;
                    this.val$finalObject = object;
                    this.val$finalRefreshReposFolders = bl;
                }

                public void run() {
                    1.access$0(this.this$1).refreshViewer(this.val$finalObject, this.val$finalRefreshReposFolders);
                }
            });
        }

        public void repositoryModified(ISVNRepositoryLocation root) {
            this.refresh(null, false);
        }

        static /* synthetic */ RepositoriesView access$0(1 var0) {
            return var0.RepositoriesView.this;
        }
    };
    RepositoryDragSourceListener repositoryDragSourceListener;
    static /* synthetic */ Class class$0;

    protected void contributeActions() {
        final Shell shell = this.getShell();
        this.newAction = new Action(Policy.bind("RepositoriesView.new"), SVNUIPlugin.getPlugin().getImageDescriptor("wizards/newlocation_wiz.gif")){

            public void run() {
                if (!WorkspacePathValidator.validateWorkspacePath()) {
                    return;
                }
                NewLocationWizard wizard = new NewLocationWizard();
                WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                dialog.open();
            }
        };
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.newAction, "org.tigris.subversion.subclipse.ui.new_repository_location_action_context");
        this.propertiesAction = new PropertyDialogAction((IShellProvider)new SameShellProvider((Control)shell), (ISelectionProvider)this.getViewer());
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.propertiesAction);
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        if (selection.size() == 1 && selection.getFirstElement() instanceof ISVNRepositoryLocation) {
            this.propertiesAction.setEnabled(true);
        } else {
            this.propertiesAction.setEnabled(false);
        }
        this.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                boolean enabled = ss.size() == 1 && ss.getFirstElement() instanceof ISVNRepositoryLocation;
                RepositoriesView.this.propertiesAction.setEnabled(enabled);
            }
        });
        this.removeRootAction = new RemoveRootAction(this.treeViewer.getControl().getShell());
        this.removeRootAction.selectionChanged(null);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.removeRootAction, "org.tigris.subversion.subclipse.ui.remove_root_action_context");
        IActionBars bars = this.getViewSite().getActionBars();
        bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.removeRootAction);
        SVNUIPlugin plugin = SVNUIPlugin.getPlugin();
        this.refreshAction = new Action(Policy.bind("RepositoriesView.refresh"), SVNUIPlugin.getPlugin().getImageDescriptor("elcl16/refresh.gif")){

            public void run() {
                RepositoriesView.this.refreshViewer(null, true);
            }
        };
        this.refreshAction.setToolTipText(Policy.bind("RepositoriesView.refreshTooltip"));
        this.refreshAction.setDisabledImageDescriptor(plugin.getImageDescriptor("dlcl16/refresh.gif"));
        this.refreshAction.setHoverImageDescriptor(plugin.getImageDescriptor("clcl16/refresh.gif"));
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.refreshAction);
        this.refreshPopupAction = new Action(Policy.bind("RepositoriesView.refreshPopup"), SVNUIPlugin.getPlugin().getImageDescriptor("clcl16/refresh.gif")){

            public void run() {
                RepositoriesView.this.refreshViewerNode();
            }
        };
        this.collapseAllAction = new Action(Policy.bind("RepositoriesView.collapseAll"), SVNUIPlugin.getPlugin().getImageDescriptor("elcl16/collapseall.gif")){

            public void run() {
                RepositoriesView.this.collapseAll();
            }
        };
        this.collapseAllAction.setToolTipText(Policy.bind("RepositoriesView.collapseAllTooltip"));
        this.collapseAllAction.setHoverImageDescriptor(plugin.getImageDescriptor("clcl16/collapseall.gif"));
        MenuManager menuMgr = new MenuManager();
        Tree tree = this.treeViewer.getTree();
        Menu menu = menuMgr.createContextMenu((Control)tree);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                RepositoriesView.this.addWorkbenchActions(manager);
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        tree.setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.treeViewer);
        IToolBarManager tbm = bars.getToolBarManager();
        this.drillPart.addNavigationActions(tbm);
        tbm.add((IAction)this.refreshAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.collapseAllAction);
        tbm.update(false);
        this.openAction = new OpenRemoteFileAction();
        bars.updateActionBars();
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager actionBarsMenu = actionBars.getMenuManager();
        Action newRepositoryAction = new Action(Policy.bind("RepositoriesView.newRepository")){

            public void run() {
                SvnWizardNewRepositoryPage newRepositoryPage = new SvnWizardNewRepositoryPage();
                SvnWizard wizard = new SvnWizard(newRepositoryPage);
                SvnWizardDialog dialog = new SvnWizardDialog(RepositoriesView.this.getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    RepositoriesView.this.refreshViewer(null, false);
                }
            }
        };
        actionBarsMenu.add((IAction)newRepositoryAction);
    }

    protected void addWorkbenchActions(IMenuManager manager) {
        MenuManager sub = new MenuManager(Policy.bind("RepositoriesView.newSubmenu"), "group.add");
        sub.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)sub);
        manager.add((IContributionItem)new Separator("group.file"));
        manager.add((IContributionItem)new Separator("historyGroup"));
        manager.add((IContributionItem)new Separator("checkoutGroup"));
        manager.add((IContributionItem)new Separator("exportImportGroup"));
        manager.add((IContributionItem)new Separator("miscGroup"));
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IAction)this.refreshPopupAction);
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        this.removeRootAction.selectionChanged(selection);
        if (this.removeRootAction.isEnabled()) {
            manager.add((IAction)this.removeRootAction);
        }
        if (selection.size() == 1 && selection.getFirstElement() instanceof ISVNRepositoryLocation) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.propertiesAction);
        }
        sub.add((IAction)this.newAction);
    }

    public void createPartControl(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 770);
        this.contentProvider = new RemoteContentProvider();
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        final RepositoriesViewDecorator decorator = new RepositoriesViewDecorator();
        DecoratingLabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), new ILabelDecorator(){

            public Image decorateImage(Image image, Object obj) {
                RemoteFile remoteFile;
                if (obj instanceof RemoteFile && (remoteFile = (RemoteFile)obj).getLock() != null) {
                    return decorator.getImage(image);
                }
                return null;
            }

            public String decorateText(String text, Object obj) {
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object obj, String prop) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        this.root = new AllRootsElement();
        this.treeViewer.setInput((Object)this.root);
        this.treeViewer.setSorter((ViewerSorter)new RepositorySorter());
        this.drillPart = new DrillDownAdapter(this.treeViewer);
        this.contributeActions();
        String helpID = this.getHelpContextId();
        if (helpID != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.treeViewer.getControl(), helpID);
        }
        this.initializeListeners();
        SVNUIPlugin.getPlugin().getRepositoryManager().addRepositoryListener(this.repositoryListener);
    }

    protected void initializeListeners() {
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener((ISelectionListener)this);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this.removeRootAction);
        this.treeViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 0x100000E) {
                    RepositoriesView.this.refreshAction.run();
                }
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                RepositoriesView.this.handleDoubleClick(e);
            }
        });
        this.repositoryDragSourceListener = new RepositoryDragSourceListener();
        this.treeViewer.addDragSupport(20, new Transfer[]{RemoteResourceTransfer.getInstance(), PluginTransfer.getInstance()}, (DragSourceListener)this.repositoryDragSourceListener);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RepositoriesView.this.repositoryDragSourceListener.updateSelection((IStructuredSelection)event.getSelection());
            }
        });
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        String msg = this.getStatusLineMessage(selection);
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(msg);
    }

    private String getStatusLineMessage(ISelection selection) {
        Object element;
        if (selection == null || selection.isEmpty()) {
            return "";
        }
        if (!(selection instanceof IStructuredSelection)) {
            return "";
        }
        IStructuredSelection s = (IStructuredSelection)selection;
        if (s.size() > 1) {
            return Policy.bind("RepositoriesView.NItemsSelected", String.valueOf(s.size()));
        }
        Object object = s.getFirstElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.tigris.subversion.subclipse.core.ISVNResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((element = SVNAction.getAdapter(object, clazz)) instanceof ISVNRemoteResource) {
            ISVNRemoteResource res = (ISVNRemoteResource)element;
            String name = res.isContainer() ? res.getRepositoryRelativePath() : String.valueOf(res.getRepositoryRelativePath()) + " " + ((ISVNRemoteFile)res).getLastChangedRevision();
            return Policy.bind("RepositoriesView.ResourceInRepository", name, res.getRepository().getLocation());
        }
        return Policy.bind("RepositoriesView.OneItemSelected");
    }

    protected String getHelpContextId() {
        return "org.tigris.subversion.subclipse.ui.repositories_view_context";
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    protected Shell getShell() {
        return this.treeViewer.getTree().getShell();
    }

    protected TreeViewer getViewer() {
        return this.treeViewer;
    }

    protected void refreshViewer(Object object, boolean refreshRepositoriesFolders) {
        if (this.treeViewer == null) {
            return;
        }
        if (refreshRepositoriesFolders) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SVNProviderPlugin.getPlugin().getRepositories().refreshRepositoriesFolders(monitor);
                }
            };
            try {
                new ProgressMonitorDialog(this.getShell()).run(true, false, runnable);
            }
            catch (Exception e) {
                SVNUIPlugin.openError(this.getShell(), null, null, e, 2);
            }
        }
        if (object == null) {
            this.treeViewer.refresh();
        } else {
            ISVNRemoteFolder parent;
            if (object instanceof ISVNRemoteFolder && (parent = ((ISVNRemoteFolder)object).getParent()) == null) {
                this.treeViewer.refresh();
                return;
            }
            this.treeViewer.refresh(object);
        }
    }

    protected void refreshViewerNode() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object object = iter.next();
            if (object instanceof ISVNRepositoryLocation) {
                this.refreshAction.run();
                break;
            }
            if (object instanceof ISVNRemoteFolder) {
                ((ISVNRemoteFolder)object).refresh();
            }
            this.treeViewer.refresh(object);
        }
    }

    public void collapseAll() {
        if (this.treeViewer == null) {
            return;
        }
        this.treeViewer.getControl().setRedraw(false);
        this.treeViewer.collapseToLevel(this.treeViewer.getInput(), -1);
        this.treeViewer.getControl().setRedraw(true);
    }

    private void handleDoubleClick(DoubleClickEvent e) {
        IStructuredSelection structured;
        ISelection selection = e.getSelection();
        if (selection instanceof IStructuredSelection && (structured = (IStructuredSelection)selection).size() == 1) {
            Object first = structured.getFirstElement();
            if (first instanceof ISVNRemoteFile) {
                this.openAction.selectionChanged(null, selection);
                this.openAction.run(null);
            } else {
                this.treeViewer.setExpandedState(first, !this.treeViewer.getExpandedState(first));
            }
        }
    }

    public void dispose() {
        SVNUIPlugin.getPlugin().getRepositoryManager().removeRepositoryListener(this.repositoryListener);
        super.dispose();
        this.treeViewer = null;
    }

    private static final class RepositoryDragSourceListener
    implements DragSourceListener {
        private IStructuredSelection selection;

        private RepositoryDragSourceListener() {
        }

        public void dragStart(DragSourceEvent event) {
            if (this.selection != null) {
                Object[] array = this.selection.toArray();
                int i = 0;
                while (i < array.length) {
                    if (array[i] instanceof ISVNRemoteResource) {
                        event.doit = true;
                        return;
                    }
                    ++i;
                }
                event.doit = false;
            }
        }

        public void dragSetData(DragSourceEvent event) {
            block5: {
                block4: {
                    if (this.selection == null || !RemoteResourceTransfer.getInstance().isSupportedType(event.dataType)) break block4;
                    Object[] array = this.selection.toArray();
                    int i = 0;
                    while (i < array.length) {
                        if (array[i] instanceof ISVNRemoteResource) {
                            event.data = array[i];
                            return;
                        }
                        ++i;
                    }
                    break block5;
                }
                if (!PluginTransfer.getInstance().isSupportedType(event.dataType)) break block5;
                Object[] array = this.selection.toArray();
                int i = 0;
                while (i < array.length) {
                    if (array[i] instanceof ISVNRemoteResource) {
                        event.data = new PluginTransferData("org.tigris.subversion.subclipse.ui.svnRemoteDrop", RemoteResourceTransfer.getInstance().toByteArray((ISVNRemoteResource)array[i]));
                        return;
                    }
                    ++i;
                }
            }
        }

        public void dragFinished(DragSourceEvent event) {
        }

        public void updateSelection(IStructuredSelection selection) {
            this.selection = selection;
        }
    }
}

