/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.Iterator;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.AnimationEngine;
import org.eclipse.ui.internal.RectangleAnimationFeedbackBase;

public class LegacyAnimationFeedback
extends RectangleAnimationFeedbackBase {
    private static final int LINE_WIDTH = 1;
    private Display display;
    private Region shellRegion;
    private Shell theShell;

    public LegacyAnimationFeedback(Shell parentShell, Rectangle start, Rectangle end) {
        super(parentShell, start, end);
    }

    public void renderStep(AnimationEngine engine) {
        if (this.shellRegion != null) {
            this.shellRegion.dispose();
            this.shellRegion = new Region((Device)this.display);
        }
        Iterator currentRects = this.getCurrentRects(engine.amount()).iterator();
        while (currentRects.hasNext()) {
            Rectangle curRect = (Rectangle)currentRects.next();
            Rectangle rect = Geometry.toControl((Control)this.theShell, (Rectangle)curRect);
            this.shellRegion.add(rect);
            ++rect.x;
            ++rect.y;
            rect.width = Math.max(0, rect.width - 2);
            rect.height = Math.max(0, rect.height - 2);
            this.shellRegion.subtract(rect);
        }
        this.theShell.setRegion(this.shellRegion);
        this.display.update();
    }

    public void initialize(AnimationEngine engine) {
        this.theShell = new Shell(this.getAnimationShell(), 16392);
        this.display = this.theShell.getDisplay();
        Color color = this.display.getSystemColor(17);
        this.theShell.setBackground(color);
        this.shellRegion = new Region((Device)this.display);
        this.theShell.setRegion(this.shellRegion);
    }

    public void dispose() {
        this.theShell.setVisible(false);
        this.theShell.dispose();
        this.shellRegion.dispose();
    }

    public boolean jobInit(AnimationEngine engine) {
        if (!super.jobInit(engine)) {
            return false;
        }
        Rectangle shellBounds = Geometry.copy((Rectangle)((Rectangle)this.getStartRects().get(0)));
        Iterator startIter = this.getStartRects().iterator();
        Iterator endIter = this.getEndRects().iterator();
        while (startIter.hasNext()) {
            shellBounds.add((Rectangle)startIter.next());
            shellBounds.add((Rectangle)endIter.next());
        }
        this.theShell.setBounds(shellBounds);
        this.theShell.setVisible(true);
        return true;
    }
}

