/* Filename: IReferenceModel.java
 * Creator: M.A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: Sep 8, 2009
 */
package edu.mit.discourse.core.rep.referent.model;

import edu.mit.discourse.core.rep.referent.IReference;
import edu.mit.parsing.core.model.ISegmentSetModel;

/**
 * A model intended for use in building {@link IReference} objects.
 * 
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since edu.mit.discourse.ui 1.0.0
 */
public interface IReferenceModel extends IReference, ISegmentSetModel {

	/**
	 * Sets the parent of this reference model to the specified referent model.
	 * The parent may be set to <code>null</code>.
	 * 
	 * @param parent
	 *            the new parent of this reference model, or <code>null</code>
	 *            to clear the parent
	 * @since edu.mit.discourse.ui 1.0.0
	 */
	public void setParent(IReferentModel parent);

	/**
	 * Returns the loaded reference object; if there isn't one, returns
	 * <code>null</code>
	 * 
	 * @return the loaded reference object, if one exists, otherwise
	 *         <code>null</code>
	 * @since edu.mit.discourse.ui 1.0.0
	 */
	public IReference getLoaded();

	/**
	 * Loads the specified reference into the model, so that it's attributes can
	 * be modified. Changes to the model, once loaded, do not affect the
	 * original object.
	 * 
	 * @param ref
	 *            the reference to be loaded into the model.
	 * @throws NullPointerException
	 *             if the specified reference is <code>null</code>
	 * @since edu.mit.discourse.ui 1.0.0
	 */
	public void load(IReference ref);
	
}
