/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.validation;

import edu.mit.story.core.validation.BaseValidator;
import edu.mit.story.core.validation.Message;
import edu.mit.story.ui.StoryUIMessages;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerValidator
extends BaseValidator<IPath> {
    public static final Message containerEmpty = new Message(StoryUIMessages.ContainerGroup_Problem_FolderEmpty, 3);

    public IMessageProvider validate(IPath path) {
        if (path == null) {
            return containerEmpty;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String projectName = path.segment(0);
        if (projectName == null || !workspace.getRoot().getProject(projectName).exists()) {
            String message = NLS.bind((String)StoryUIMessages.ContainerGroup_Problem_NoProject, (Object)projectName);
            return new Message(message, 3);
        }
        IWorkspaceRoot root = workspace.getRoot();
        while (path.segmentCount() > 1) {
            if (root.getFile(path).exists()) {
                String message = NLS.bind((String)StoryUIMessages.ContainerGroup_Problem_PathOccupied, (Object)path.makeRelative());
                return new Message(message, 3);
            }
            path = path.removeLastSegments(1);
        }
        return null;
    }
}

