/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.label;

import edu.mit.story.core.desc.IDesc;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.build.StoryNature;
import java.util.HashSet;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.widgets.Display;

public class StoryLabelDecorator
extends BaseLabelProvider
implements ILightweightLabelDecorator,
IResourceChangeListener {
    protected ImageDescriptor errorOverlay;
    protected ImageDescriptor warningOverlay;

    public StoryLabelDecorator() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 16);
        this.errorOverlay = StoryUIPlugin.getDefault().getImageRegistry().getDescriptor("ovr16/error_ovr.gif");
        this.warningOverlay = StoryUIPlugin.getDefault().getImageRegistry().getDescriptor("ovr16/warning_ovr.gif");
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IMarkerDelta[] deltas = event.findMarkerDeltas("edu.mit.story.core.marker.problem", true);
        if (deltas.length == 0) {
            return;
        }
        HashSet<IResource> changed = new HashSet<IResource>();
        IMarkerDelta[] iMarkerDeltaArray = deltas;
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerDelta delta = iMarkerDeltaArray[n2];
            IResource r = delta.getResource();
            while (r.isAccessible()) {
                changed.add(r);
                if ((r = r.getParent()) != null) continue;
            }
            ++n2;
        }
        final LabelProviderChangedEvent e = new LabelProviderChangedEvent((IBaseLabelProvider)this, changed.toArray());
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                StoryLabelDecorator.this.fireLabelProviderChanged(e);
            }
        });
    }

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof IResource) {
            this.decorate((IResource)element, decoration);
        }
        if (element instanceof IDesc) {
            this.decorate((IDesc)element, decoration);
        }
    }

    protected void decorate(IResource resource, IDecoration decoration) {
        if (!resource.isAccessible() || !StoryNature.hasStoryNature(resource.getProject())) {
            return;
        }
        try {
            this.decorate(resource.findMaxProblemSeverity("edu.mit.story.core.marker.problem", true, 2), decoration);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected void decorate(int severity, IDecoration decoration) {
        switch (severity) {
            case 2: {
                decoration.addOverlay(this.errorOverlay, 2);
                break;
            }
            case 1: {
                decoration.addOverlay(this.warningOverlay, 2);
            }
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.errorOverlay = null;
        this.warningOverlay = null;
        super.dispose();
    }
}

