/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.controllers;

import edu.mit.story.core.datamodel.IBatchTargetModel;
import edu.mit.story.core.measure.FileExtractor;
import edu.mit.story.core.measure.ITargetExtractor;
import edu.mit.story.ui.controllers.IBatchTargetController;
import java.util.Collection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ResourceListSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchStoryTargetController<M extends IBatchTargetModel>
implements IBatchTargetController<M> {
    private final M model;
    private final String extension;
    private final ITargetExtractor<IFile> fileExtractor;

    public BatchStoryTargetController(M model, String extension) {
        if (model == null) {
            throw new NullPointerException();
        }
        if (extension == null) {
            throw new NullPointerException();
        }
        this.model = model;
        this.extension = extension;
        this.fileExtractor = new FileExtractor(extension);
    }

    @Override
    public M getModel() {
        return this.model;
    }

    @Override
    public void addAllTargets(IResource resource) {
        if (resource == null) {
            return;
        }
        this.model.getTargets().addAll(this.fileExtractor.getTargets(resource, null));
    }

    @Override
    public void selectTargets(Shell shell) {
        ResourceListSelectionDialog dialog = new ResourceListSelectionDialog(shell, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 7){

            protected boolean select(IResource resource) {
                if (resource.getType() != 1) {
                    return true;
                }
                return BatchStoryTargetController.this.extension.equalsIgnoreCase(resource.getFileExtension());
            }
        };
        dialog.setAllowUserToToggleDerived(false);
        dialog.setBlockOnOpen(true);
        dialog.setTitle("Select a File");
        dialog.setMessage("Select a file or a folder containing files");
        if (dialog.open() == 0) {
            Object[] objects;
            Object[] objectArray = objects = dialog.getResult();
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object resource = objectArray[n2];
                this.addAllTargets((IResource)resource);
                ++n2;
            }
        }
    }

    @Override
    public void removeTarget(IFile file) {
        this.model.getTargets().remove(file);
    }

    @Override
    public void removeTargets(Collection<? extends IFile> files) {
        this.model.getTargets().removeAll(files);
    }

    @Override
    public void clear() {
        this.model.getTargets().clear();
    }

    public void dispose() {
    }
}

