/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.actions;

import edu.mit.story.core.desc.DescMultiSet;
import edu.mit.story.core.desc.DescSet;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.element.IStoryElement;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import edu.mit.story.core.rep.IRepSupporter;
import edu.mit.story.core.rep.RepUtils;
import edu.mit.story.core.util.IUtilityClass;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.clipboard.ClipboardUtils;
import edu.mit.story.ui.dialogs.RepChooserDialog;
import edu.mit.story.ui.views.RepresentationTree;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public final class RepActionUtils
implements IUtilityClass {
    private RepActionUtils() {
    }

    public static boolean canCut(IRep rep, IMutableStoryModel provider) {
        if (rep == null | provider == null) {
            return false;
        }
        return RepActionUtils.canCopy(rep) & RepActionUtils.canDelete(rep, provider);
    }

    public static boolean canCut(IRepSet reps, IMutableStoryModel provider) {
        if (reps == null | provider == null) {
            return false;
        }
        if (reps.isEmpty()) {
            return false;
        }
        return RepActionUtils.canCopy(reps) & RepActionUtils.canDelete(reps, (IStoryModel)provider);
    }

    public static boolean canCopy(IRep rep) {
        return rep != null;
    }

    public static boolean canCopy(IRepSet reps) {
        if (reps == null) {
            return false;
        }
        return !reps.isEmpty();
    }

    public static boolean canPaste(IRep rep, IMutableStoryModel provider) {
        if (rep == null | provider == null) {
            return false;
        }
        return RepUtils.canAddConsistently((IRep)rep, (IRepSupporter)provider);
    }

    public static boolean canPaste(IRepSet reps, IMutableStoryModel provider) {
        if (reps == null | provider == null) {
            return false;
        }
        if (reps.isEmpty()) {
            return false;
        }
        return RepUtils.canAddAllConsistently((Collection)reps, (IRepSupporter)provider);
    }

    public static boolean canDelete(IRep rep, IMutableStoryModel provider) {
        if (rep == null | provider == null) {
            return false;
        }
        return provider.supports(rep) & !rep.equals(provider.getPrimary());
    }

    public static boolean canDelete(IRepSet reps, IStoryModel provider) {
        if (reps == null | provider == null) {
            return false;
        }
        if (reps.isEmpty()) {
            return false;
        }
        if (!(provider instanceof IMutableStoryModel)) {
            return false;
        }
        for (IRep rep : reps) {
            if (!(!provider.supports(rep) | rep.equals(provider.getPrimary()))) continue;
            return false;
        }
        return true;
    }

    public static boolean doCut(Object source, IRep rep, IMutableStoryModel provider, Clipboard clipboard) {
        if (clipboard == null) {
            return false;
        }
        if (!RepActionUtils.canCut(rep, provider)) {
            return false;
        }
        if (!RepActionUtils.doDelete(source, rep, provider)) {
            return false;
        }
        RepActionUtils.doCopy(rep, clipboard);
        return true;
    }

    public static boolean doCut(Object source, IRepSet reps, IMutableStoryModel provider, Clipboard clipboard) {
        if (clipboard == null) {
            return false;
        }
        if (!RepActionUtils.canCut(reps, provider)) {
            return false;
        }
        if (!RepActionUtils.doDelete(source, reps, provider)) {
            return false;
        }
        RepActionUtils.doCopy(reps, clipboard);
        return true;
    }

    public static boolean doCopy(IRep rep, Clipboard clipboard) {
        if (clipboard == null | rep == null) {
            return false;
        }
        ClipboardUtils.putStoryObject((IStoryElement)rep, clipboard);
        return true;
    }

    public static boolean doCopy(IRepSet reps, Clipboard clipboard) {
        if (clipboard == null | reps == null) {
            return false;
        }
        if (reps.isEmpty()) {
            return false;
        }
        ClipboardUtils.putStoryObject((IStoryElement)reps, clipboard);
        return true;
    }

    public static boolean doCopyData(IRep rep, IStoryModel provider, Clipboard clipboard) {
        if (rep == null | clipboard == null | provider == null) {
            return false;
        }
        IDescSet descs = provider.getData().getDescriptions(rep);
        if (descs == null | descs.size() == 0) {
            return false;
        }
        DescSet set = new DescSet(descs);
        ClipboardUtils.putStoryObjectData((IStoryElement)set, clipboard);
        return true;
    }

    public static boolean doCopyData(IRepSet reps, IStoryModel provider, Clipboard clipboard) {
        if (reps == null | clipboard == null | provider == null) {
            return false;
        }
        if (reps.isEmpty()) {
            return false;
        }
        DescMultiSet data = new DescMultiSet();
        for (IRep rep : reps) {
            IDescSet descs = provider.getData().getDescriptions(rep);
            if (descs == null | descs.size() == 0) continue;
            data.addAll((Collection)descs);
        }
        ClipboardUtils.putStoryObjectData((IStoryElement)data, clipboard);
        return true;
    }

    public static boolean doDelete(Object source, IRep rep, IMutableStoryModel provider) {
        if (!RepActionUtils.canDelete(rep, provider)) {
            return false;
        }
        return false;
    }

    public static boolean doDelete(Object source, IRepSet reps, IMutableStoryModel provider) {
        if (!RepActionUtils.canDelete(reps, (IStoryModel)provider)) {
            return false;
        }
        return false;
    }

    public static boolean showConfirmRepresentationDeletePrompt(boolean plural1, boolean plural2) {
        return false;
    }

    public static boolean showConfirmDescriptionDeletePrompt(boolean plural) {
        return false;
    }

    public static boolean focusOn(Shell shell) {
        return RepActionUtils.focusOn(shell, null);
    }

    public static boolean focusOn(Shell shell, RepresentationTree view) {
        if (shell == null) {
            return false;
        }
        RepChooserDialog dialog = new RepChooserDialog(shell);
        if (dialog.open() != 0) {
            return false;
        }
        IRep rep = dialog.getSelectedRepresentation();
        if (rep == null) {
            return false;
        }
        return RepActionUtils.focusOnSpecific(view, rep);
    }

    public static boolean focusOnSpecific(IRep rep) {
        return RepActionUtils.focusOnSpecific(null, rep);
    }

    public static boolean focusOnSpecific(RepresentationTree view, IRep rep) {
        if (rep == null) {
            return false;
        }
        if (view == null) {
            view = RepActionUtils.findView();
        }
        if (view == null) {
            return false;
        }
        view.setRepresentation(rep);
        return true;
    }

    public static RepresentationTree findView() {
        try {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            return (RepresentationTree)page.showView("edu.mit.story.views.RepresentationTree");
        }
        catch (PartInitException e) {
            Status status = new Status(4, StoryUIPlugin.getDefault().getID(), 0, e.getLocalizedMessage(), (Throwable)e);
            StoryUIPlugin.getDefault().getLog().log((IStatus)status);
            return null;
        }
    }
}

