/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.subscriber;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.core.util.File2Resource;
import org.tigris.subversion.subclipse.core.util.Util;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.dialogs.CommitToTagsWarningDialog;
import org.tigris.subversion.subclipse.ui.operations.CommitOperation;
import org.tigris.subversion.subclipse.ui.settings.ProjectProperties;
import org.tigris.subversion.subclipse.ui.subscriber.SVNSynchronizeOperation;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizard;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardCommitPage;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialog;

public class CommitSynchronizeOperation
extends SVNSynchronizeOperation {
    private String commitComment;
    private IResource[] resourcesToCommit;
    private String url;
    private ChangeSet changeSet;
    private boolean commit;
    private boolean keepLocks;
    private String proposedComment;
    private ISynchronizePageConfiguration configuration;

    protected CommitSynchronizeOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements, String url, String proposedComment) {
        super(configuration, elements);
        this.configuration = configuration;
        this.url = url;
        this.proposedComment = proposedComment;
    }

    private boolean confirmCommit(SyncInfoSet set) {
        block20: {
            this.commit = false;
            IResource[] modified = set.getResources();
            ArrayList<IFile> conflictFiles = new ArrayList<IFile>();
            ArrayList<IResource> filteredModified = new ArrayList<IResource>();
            boolean switched = false;
            int i = 0;
            while (i < modified.length) {
                IResource resource = modified[i];
                filteredModified.add(resource);
                if (!(resource instanceof IContainer)) {
                    ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
                    try {
                        if (svnResource.isManaged() && svnResource.getStatus().isTextConflicted()) {
                            IFile conflictWorkingFile;
                            IFile conflictOldFile;
                            IFile conflictNewFile = (IFile)File2Resource.getResource((File)svnResource.getStatus().getConflictNew());
                            if (conflictNewFile != null) {
                                conflictFiles.add(conflictNewFile);
                            }
                            if ((conflictOldFile = (IFile)File2Resource.getResource((File)svnResource.getStatus().getConflictOld())) != null) {
                                conflictFiles.add(conflictOldFile);
                            }
                            if ((conflictWorkingFile = (IFile)File2Resource.getResource((File)svnResource.getStatus().getConflictWorking())) != null) {
                                conflictFiles.add(conflictWorkingFile);
                            }
                        }
                        if (svnResource.getStatus().isSwitched()) {
                            this.url = svnResource.getStatus().getUrlString();
                            switched = true;
                        }
                    }
                    catch (SVNException sVNException) {}
                }
                ++i;
            }
            if (switched && modified.length > 1) {
                this.url = null;
            }
            if (conflictFiles.size() > 0) {
                Iterator iter = conflictFiles.iterator();
                while (iter.hasNext()) {
                    IFile conflictFile = (IFile)iter.next();
                    filteredModified.remove(conflictFile);
                }
                modified = new IResource[filteredModified.size()];
                filteredModified.toArray(modified);
            }
            if (modified.length > 0) {
                block19: {
                    IPreferenceStore preferenceStore = SVNUIPlugin.getPlugin().getPreferenceStore();
                    boolean commitToTagsPathWithoutWarning = preferenceStore.getBoolean("pref_commit_to_tags_path_without_warning");
                    if (commitToTagsPathWithoutWarning || !this.onTagPath(modified)) break block19;
                    this.commit = true;
                    this.getShell().getDisplay().syncExec(new Runnable(){

                        public void run() {
                            CommitToTagsWarningDialog dialog = new CommitToTagsWarningDialog(CommitSynchronizeOperation.this.getShell());
                            CommitSynchronizeOperation.this.commit = dialog.open() == 0;
                        }
                    });
                    if (this.commit) break block19;
                    return false;
                }
                try {
                    ProjectProperties projectProperties = ProjectProperties.getProjectProperties(modified[0]);
                    SvnWizardCommitPage commitPage = new SvnWizardCommitPage(modified, this.url, projectProperties, new HashMap(), this.changeSet, true);
                    if (this.proposedComment == null || this.proposedComment.length() == 0) {
                        commitPage.setComment(this.getProposedComment(modified));
                    } else {
                        commitPage.setComment(this.proposedComment);
                    }
                    commitPage.setSyncInfoSet(set);
                    SvnWizard wizard = new SvnWizard(commitPage);
                    final SvnWizardDialog dialog = new SvnWizardDialog(this.getShell(), (IWizard)wizard);
                    wizard.setParentDialog((Dialog)dialog);
                    this.getShell().getDisplay().syncExec(new Runnable(){

                        public void run() {
                            CommitSynchronizeOperation.this.commit = dialog.open() == 0;
                        }
                    });
                    if (this.commit) {
                        this.resourcesToCommit = commitPage.getSelectedResources();
                        this.keepLocks = commitPage.isKeepLocks();
                    }
                    this.commitComment = commitPage.getComment();
                }
                catch (SVNException e) {
                    if (e.operationInterrupted()) break block20;
                    SVNUIPlugin.log(4, e.getMessage(), e);
                }
            }
        }
        return this.commit;
    }

    protected boolean promptForConflictHandling(Shell shell, SyncInfoSet syncSet) {
        return true;
    }

    private String getProposedComment(IResource[] resourcesToCommit) {
        StringBuffer comment = new StringBuffer();
        ChangeSet[] sets = SVNProviderPlugin.getPlugin().getChangeSetManager().getSets();
        int numMatchedSets = 0;
        int i = 0;
        while (i < sets.length) {
            ChangeSet set = sets[i];
            if (this.isUserSet(set) && this.containsOne(set, resourcesToCommit)) {
                if (numMatchedSets > 0) {
                    comment.append(System.getProperty("line.separator"));
                }
                comment.append(set.getComment());
                ++numMatchedSets;
            }
            ++i;
        }
        return comment.toString();
    }

    private boolean isUserSet(ChangeSet set) {
        if (set instanceof ActiveChangeSet) {
            ActiveChangeSet acs = (ActiveChangeSet)set;
            return acs.isUserCreated();
        }
        return false;
    }

    private boolean containsOne(ChangeSet set, IResource[] resourcesToCommit) {
        int j = 0;
        while (j < resourcesToCommit.length) {
            ActiveChangeSet acs;
            IResource resource = resourcesToCommit[j];
            if (set.contains(resource)) {
                return true;
            }
            if (set instanceof ActiveChangeSet && (acs = (ActiveChangeSet)set).getDiffTree().members(resource).length > 0) {
                return true;
            }
            ++j;
        }
        return false;
    }

    private int promptForConflicts(Shell shell, SyncInfoSet syncSet) {
        String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};
        String title = Policy.bind("SyncAction.commit.conflict.title");
        String question = Policy.bind("SyncAction.commit.conflict.question");
        final MessageDialog dialog = new MessageDialog(shell, title, null, question, 3, buttons, 0);
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
        return dialog.getReturnCode();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        SyncInfoSet syncSet = this.getSyncInfoSet();
        if (!this.promptForConflictHandling(this.getShell(), syncSet)) {
            return;
        }
        Map projectSyncInfos = this.getProjectSyncInfoSetMap(syncSet);
        Iterator iter = projectSyncInfos.keySet().iterator();
        IProject project = (IProject)iter.next();
        SVNTeamProvider provider = (SVNTeamProvider)RepositoryProvider.getProvider((IProject)project, (String)"org.tigris.subversion.subclipse.core.svnnature");
        monitor.beginTask(null, projectSyncInfos.size() * 100);
        this.run(provider, syncSet, Policy.subMonitorFor(monitor, 100));
        monitor.done();
    }

    protected void run(SVNTeamProvider provider, SyncInfoSet set, IProgressMonitor monitor) {
        if (set.hasConflicts() || set.hasIncomingChanges()) {
            switch (this.promptForConflicts(this.getShell(), set)) {
                case 0: {
                    set.removeConflictingNodes();
                    set.removeIncomingNodes();
                    break;
                }
                case 1: {
                    return;
                }
                default: {
                    return;
                }
            }
        }
        if (this.confirmCommit(set)) {
            IResource[][] resourcesToBeAdded = new IResource[1][];
            IResource[][] resourcesToBeDeleted = new IResource[1][];
            ArrayList<IResource> toBeAddedList = new ArrayList<IResource>();
            ArrayList<IResource> toBeDeletedList = new ArrayList<IResource>();
            int i = 0;
            while (i < this.resourcesToCommit.length) {
                IResource resource = this.resourcesToCommit[i];
                ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
                try {
                    if (!svnResource.isManaged()) {
                        toBeAddedList.add(resource);
                    }
                    if (svnResource.getStatus().isMissing()) {
                        toBeDeletedList.add(resource);
                    }
                }
                catch (SVNException e) {
                    SVNUIPlugin.log(4, e.getMessage(), e);
                }
                ++i;
            }
            resourcesToBeAdded[0] = new IResource[toBeAddedList.size()];
            toBeAddedList.toArray(resourcesToBeAdded[0]);
            resourcesToBeDeleted[0] = new IResource[toBeDeletedList.size()];
            toBeDeletedList.toArray(resourcesToBeDeleted[0]);
            try {
                CommitOperation commit = new CommitOperation(this.getPart(), this.resourcesToCommit, resourcesToBeAdded[0], resourcesToBeDeleted[0], this.resourcesToCommit, this.commitComment, this.keepLocks);
                if (SVNProviderPlugin.getPlugin().getPluginPreferences().getBoolean("show_out_of_date_folders")) {
                    commit.setConfiguration(this.configuration);
                }
                commit.run();
            }
            catch (InvocationTargetException e) {
                SVNUIPlugin.log(4, e.getMessage(), e);
            }
            catch (InterruptedException e) {
                SVNUIPlugin.log(4, e.getMessage(), e);
            }
        }
    }

    public void setChangeSet(ChangeSet changeSet) {
        this.changeSet = changeSet;
    }

    private boolean onTagPath(IResource[] modifiedResources) throws SVNException {
        if (this.url == null) {
            IResource resource = modifiedResources[0];
            ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
            String firstUrl = svnResource.getStatus().getUrlString();
            if (firstUrl == null || resource.getType() == 1) {
                firstUrl = Util.getParentUrl((ISVNLocalResource)svnResource);
            }
            if (firstUrl.indexOf("/tags/") != -1) {
                return true;
            }
        } else if (this.url.indexOf("/tags/") != -1) {
            return true;
        }
        return false;
    }
}

