/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.util;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Debug {
    private static final char spaceChar = ' ';
    private static final String colon = ": ";
    private static final char leftBracket = '[';
    private static final char rightBracket = ']';
    private static final String comma = ", ";
    private static final String needsImplementing = "needs to be implemented";
    private static final String nullIndicator = "null";
    private static final String spaceStr = " ";
    private static final String spaceCharToString = "\\s";
    private static final String unknownMethod = "Unknown Method";

    public static void implement() {
        System.err.println(String.valueOf(Debug.getIdentifier()) + spaceStr + needsImplementing);
    }

    public static void implement(String note) {
        System.err.println(String.valueOf(Debug.getIdentifier()) + spaceStr + needsImplementing + colon + note);
    }

    public static void out() {
        System.out.println(Debug.getIdentifier());
    }

    public static void out(String message) {
        if (message == null) {
            System.out.println(String.valueOf(Debug.getIdentifier()) + comma + nullIndicator);
            return;
        }
        if (message.equals("")) {
            System.out.println(Debug.getIdentifier());
            return;
        }
        System.out.println(String.valueOf(Debug.getIdentifier()) + comma + message);
    }

    public static void out(Object o) {
        if (o == null) {
            System.out.println(String.valueOf(Debug.getIdentifier()) + comma + nullIndicator);
            return;
        }
        System.out.println(String.valueOf(Debug.getIdentifier()) + comma + o.toString());
    }

    public static void out(int skiplines, String message) {
        if (message == null) {
            int i = 0;
            while (i < skiplines) {
                System.out.println();
                ++i;
            }
            System.out.println(Debug.getIdentifier());
            return;
        }
        if (message.equals("")) {
            int i = 0;
            while (i < skiplines) {
                System.out.println();
                ++i;
            }
            System.out.println(Debug.getIdentifier());
            return;
        }
        int i = 0;
        while (i < skiplines) {
            System.out.println();
            ++i;
        }
        System.out.println(String.valueOf(Debug.getIdentifier()) + comma + message);
    }

    public static void err() {
        System.err.println(Debug.getIdentifier());
    }

    public static void err(String message) {
        if (message == null) {
            System.err.println(Debug.getIdentifier());
            return;
        }
        if (message.length() == 0) {
            System.err.println(Debug.getIdentifier());
            return;
        }
        System.err.println(String.valueOf(Debug.getIdentifier()) + comma + message);
    }

    public static void err(Object o) {
        if (o == null) {
            System.err.println(String.valueOf(Debug.getIdentifier()) + comma + nullIndicator);
        } else {
            System.err.println(String.valueOf(Debug.getIdentifier()) + comma + o.toString());
        }
    }

    public static void err(int skiplines, String message) {
        if (message == null) {
            int i = 0;
            while (i < skiplines) {
                System.out.println();
                ++i;
            }
            System.err.println(Debug.getIdentifier());
        } else if (message.equals("")) {
            int i = 0;
            while (i < skiplines) {
                System.out.println();
                ++i;
            }
            System.err.println(Debug.getIdentifier());
        } else {
            int i = 0;
            while (i < skiplines) {
                System.out.println();
                ++i;
            }
            System.err.println(String.valueOf(Debug.getIdentifier()) + comma + message);
        }
    }

    private static String getIdentifier() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        boolean first = true;
        StackTraceElement[] stackTraceElementArray = stack;
        int n = stack.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement frame = stackTraceElementArray[n2];
            if (first) {
                first = false;
            } else if (!Debug.class.getName().equals(frame.getClassName())) {
                return frame.toString();
            }
            ++n2;
        }
        return unknownMethod;
    }

    public static String toString(Object o) {
        return o == null ? nullIndicator : o.toString();
    }

    public static String showWhitespace(String str) {
        StringBuffer sb = new StringBuffer(str.length());
        int i = 0;
        while (i < str.length()) {
            sb.append(Debug.showWhitespace(str.charAt(i)));
            ++i;
        }
        return sb.toString();
    }

    public static String showWhitespace(char c) {
        if (c == '\b') {
            return "\\b";
        }
        if (c == '\f') {
            return "\\f";
        }
        if (c == '\n') {
            return "\\n";
        }
        if (c == '\r') {
            return "\\r";
        }
        if (c == '\t') {
            return "\\t";
        }
        if (c == ' ') {
            return spaceCharToString;
        }
        return Character.toString(c);
    }

    public static String toString(Collection<?> c) {
        StringBuffer sb = new StringBuffer(2048);
        sb.append('[');
        Iterator<?> i = c.iterator();
        while (i.hasNext()) {
            sb.append(Debug.toString(i.next()));
            if (!i.hasNext()) continue;
            sb.append(comma);
        }
        sb.append(']');
        return sb.toString();
    }

    public static String toFriendlyString(long l) {
        StringBuilder sb = new StringBuilder();
        sb.append(Long.toString(l));
        int i = sb.length() - 3;
        while (i > 0) {
            sb.insert(i, ',');
            i -= 3;
        }
        return sb.toString();
    }

    public static long printMemory() {
        long used = Debug.getMemory();
        long kb = used / 1024L;
        System.out.println("Memory in use: " + Debug.toFriendlyString(kb) + " kB");
        return used;
    }

    public static long getMemory() {
        Runtime r = Runtime.getRuntime();
        r.gc();
        return r.totalMemory() - r.freeMemory();
    }

    public static class ProgressBar {
        public static final int DEFAULT_TICKS = 50;
        private final int expected;
        private final int expectedTicks;
        private final double step;
        private final boolean printDate;
        private final boolean printMemory;
        private int count = 0;
        private int tickCount = 0;
        private double nextTick = 0.0;
        private Date start = null;
        private Date end = null;
        private long memory = 0L;

        public ProgressBar(int expected) {
            this(expected, 50);
        }

        public ProgressBar(int expected, int ticks) {
            this(expected, ticks, true, false);
        }

        public ProgressBar(int expected, int ticks, boolean printDate, boolean printMemory) {
            if (expected <= 0) {
                throw new IllegalArgumentException("Expected increments must be positive");
            }
            if (ticks <= 0) {
                throw new IllegalArgumentException("Number of printed ticks must be positive");
            }
            this.expected = expected;
            this.expectedTicks = ticks;
            this.nextTick = this.step = (double)expected / (double)ticks;
            this.printDate = printDate;
            this.printMemory = printMemory;
            StringBuilder sb = new StringBuilder(ticks);
            sb.append("100% bar: ");
            int i = 0;
            while (i < ticks) {
                sb.append('.');
                ++i;
            }
            sb.append(" (total=" + expected + ")");
            this.start = new Date();
            if (printDate) {
                System.out.println("Started " + this.start);
            }
            if (printMemory) {
                this.memory = Debug.printMemory();
            }
            System.out.println(sb.toString());
            System.out.print("Progress: ");
        }

        public void increment() {
            this.increment(1);
        }

        public void increment(int i) {
            this.count += i;
            while (this.nextTick <= (double)this.count) {
                System.out.print('.');
                ++this.tickCount;
                this.nextTick += this.step;
            }
        }

        public void finish() {
            while (this.tickCount < this.expectedTicks) {
                System.out.print('.');
                ++this.tickCount;
            }
            this.end = new Date();
            long millis = this.end.getTime() - this.start.getTime();
            float secs = (float)millis / 1000.0f;
            System.out.println(" (count=" + this.count + ", time=" + secs + "s)");
            if (this.printDate) {
                System.out.println("Finished " + new Date());
            }
            if (this.printMemory) {
                long inc = (Debug.printMemory() - this.memory) / 1024L;
                System.out.println("Memory delta  : " + Debug.toFriendlyString(inc) + " kB");
            }
        }

        public int getTotalExpected() {
            return this.expected;
        }

        public int getTotalExpectedTicks() {
            return this.expectedTicks;
        }

        public Date getStartTime() {
            return this.start;
        }

        public Date getEndTime() {
            return this.end;
        }

        public int getCount() {
            return this.count;
        }

        public int getTickCount() {
            return this.tickCount;
        }

        public double getStepSize() {
            return this.step;
        }
    }

    public static class Time {
        private final Date begin = new Date();
        private Date end;
        private long millis;
        private float seconds;
        private float minutes;

        public void stop() {
            this.end = new Date();
            this.millis = this.end.getTime() - this.begin.getTime();
            this.seconds = (float)this.millis / 1000.0f;
            this.minutes = (float)this.millis / 60000.0f;
        }

        public void print() {
            this.print("Time: ");
        }

        public void print(String prefix) {
            StringBuilder sb = new StringBuilder();
            sb.append(prefix);
            sb.append(Float.toString(this.getSeconds()));
            sb.append(" s");
            if (this.minutes > 1.0f) {
                sb.append(" (~");
                sb.append(Math.floor(this.getMinutes()));
                sb.append(" min)");
            }
            System.out.println(sb.toString());
        }

        public float getMinutes() {
            return this.minutes;
        }

        public float getSeconds() {
            return this.seconds;
        }

        public long getMillis() {
            return this.millis;
        }

        public static Time start() {
            return new Time();
        }
    }
}

