/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.rep.text;

import edu.mit.story.core.StoryMessages;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.rep.text.ITextRegion;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TextRegion implements ITextRegion
{
    TEXT(StoryMessages.TextRegion_Text_name, StoryMessages.TextRegion_Text_desc, new char[0]),
    SINGLE(StoryMessages.TextRegion_Single_name, StoryMessages.TextRegion_Single_desc, '/'),
    MULTI(StoryMessages.TextRegion_Multi_name, StoryMessages.TextRegion_Multi_desc, '/', '*');

    private final String name;
    private final String desc;
    private final char[] ignoreChars;

    private TextRegion(String name, String desc, char ... charArray) {
        if (name.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.desc = desc;
        char[] cArray = this.ignoreChars = charArray == null ? null : new char[charArray.length];
        if (this.ignoreChars != null) {
            System.arraycopy(charArray, 0, this.ignoreChars, 0, charArray.length);
            Arrays.sort(this.ignoreChars);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public char[] getIgnoredChars() {
        if (this.ignoreChars == null) {
            return null;
        }
        char[] result = new char[this.ignoreChars.length];
        System.arraycopy(this.ignoreChars, 0, result, 0, this.ignoreChars.length);
        return result;
    }

    @Override
    public boolean isText() {
        return this == TEXT;
    }

    @Override
    public boolean isComment() {
        return this == SINGLE || this == MULTI;
    }

    @Override
    public String serialize() {
        return this.name();
    }

    public String toString() {
        return this.name();
    }

    @Override
    public boolean equals(IData tgtData, IAlignedStoryModel model) {
        return this.equals(tgtData);
    }

    public static TextRegion reconstitute(String name) {
        return TextRegion.valueOf(name.toUpperCase());
    }
}

