/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.property;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.descriptor.IRegisteredDescriptor;
import edu.mit.story.core.property.IConfigDescriptor;
import edu.mit.story.core.property.IConfiguration;
import edu.mit.story.core.property.IConfigurationManager;
import edu.mit.story.core.property.IPropertyDescriptor;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration
implements IConfiguration {
    private static final long serialVersionUID = 1L;
    private final IConfigDescriptor desc;
    private final Map<String, String> backingMap;
    private final Map<String, IConfiguration> configMap;
    private Set<String> keySet;
    private Collection<String> valueCollection;
    private Set<Map.Entry<String, String>> entrySet;

    public Configuration(IConfigDescriptor desc) {
        this(desc, Collections.emptyMap());
    }

    public Configuration(IConfigDescriptor desc, Map<String, String> args) {
        if (desc == null) {
            throw new NullPointerException();
        }
        this.desc = desc;
        int configCount = 0;
        for (IPropertyDescriptor pDesc : desc.values()) {
            if (!pDesc.isConfigurableProperty()) continue;
            ++configCount;
        }
        this.backingMap = new HashMap<String, String>(desc.size());
        this.configMap = this.createConfigMap();
        IConfigurationManager m = StoryPlugin.getDefault().getConfigurationManager();
        for (IPropertyDescriptor pDesc : desc.values()) {
            IRegisteredDescriptor configDesc;
            this.internalPut(pDesc.getID(), pDesc.getDefaultValue());
            if (!pDesc.isConfigurableProperty() || (configDesc = (IRegisteredDescriptor)m.getDescriptor(pDesc.getDefaultValue())) == null) continue;
            this.configMap.put(pDesc.getID(), ((IConfigDescriptor)configDesc.create()).createDefault());
        }
        this.putAll((Map<? extends String, ? extends String>)args);
    }

    public Configuration(IConfiguration src) {
        this(src.getConfigurationDescriptor(), src);
        for (IPropertyDescriptor pDesc : this.desc.values()) {
            IConfiguration config;
            if (!pDesc.isConfigurableProperty() || (config = src.getConfigurations().get(pDesc.getKey())) == null) continue;
            this.configMap.put(pDesc.getKey(), config.clone());
        }
    }

    protected Map<String, IConfiguration> createConfigMap() {
        return new ConfigMap();
    }

    @Override
    public Configuration clone() {
        return new Configuration(this);
    }

    @Override
    public String getID() {
        return this.desc.getID();
    }

    @Override
    public String getName() {
        return this.desc.getName();
    }

    @Override
    public String getDescription() {
        return this.desc.getDescription();
    }

    @Override
    public boolean configure(IConfiguration config) {
        this.clear();
        if (config != null) {
            this.putAll(config);
            for (Map.Entry<String, IConfiguration> entry : this.getConfigurations().entrySet()) {
                this.configMap.put(entry.getKey(), entry.getValue().clone());
            }
        }
        return true;
    }

    @Override
    public IConfiguration getConfiguration() {
        return this;
    }

    @Override
    public Map<String, IConfiguration> getConfigurations() {
        return this.configMap;
    }

    @Override
    public IConfigDescriptor getConfigurationDescriptor() {
        return this.desc;
    }

    @Override
    public IConfiguration getConfiguration(String key) {
        return this.configMap.get(key);
    }

    @Override
    public IConfiguration putConfiguration(String key, IConfiguration config) {
        return this.configMap.put(key, config);
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public void clear() {
        for (String key : this.keySet()) {
            this.remove(key);
        }
    }

    @Override
    public String get(Object key) {
        return this.backingMap.get(key);
    }

    @Override
    public String remove(Object key) {
        String oldValue = this.backingMap.get(key);
        if (oldValue != null) {
            String keyStr = (String)key;
            this.backingMap.put(keyStr, ((IPropertyDescriptor)this.desc.get(key)).getDefaultValue());
        }
        return oldValue;
    }

    protected String resetValue(Map.Entry<String, String> entry) {
        IPropertyDescriptor pDesc = (IPropertyDescriptor)this.desc.get(entry.getKey());
        return entry.setValue(pDesc.getDefaultValue());
    }

    @Override
    public String put(String key, String value) {
        String newValue;
        IPropertyDescriptor pDesc = (IPropertyDescriptor)this.desc.get(key);
        if (pDesc == null) {
            return null;
        }
        String string = newValue = pDesc.isValid(value) ? value : pDesc.getDefaultValue();
        if (pDesc.isConfigurableProperty()) {
            IConfigurationManager m = StoryPlugin.getDefault().getConfigurationManager();
            IRegisteredDescriptor cDesc = (IRegisteredDescriptor)m.getDescriptor(newValue);
            if (cDesc == null) {
                this.configMap.put(pDesc.getKey(), null);
            } else {
                this.configMap.put(pDesc.getKey(), ((IConfigDescriptor)cDesc.create()).createDefault());
            }
        }
        return this.internalPut(key, newValue);
    }

    protected String internalPut(String key, String value) {
        return this.backingMap.put(key, value);
    }

    protected void putProperty(IPropertyDescriptor pDesc) {
        IConfigDescriptor cDesc = this.getConfigurationDescriptor();
        cDesc.put(pDesc.getID(), pDesc);
        this.put(pDesc.getID(), pDesc.getDefaultValue());
    }

    protected void removeProperty(String key) {
        IConfigDescriptor cDesc = this.getConfigurationDescriptor();
        cDesc.remove(key);
        this.backingMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> t) {
        for (Map.Entry<? extends String, ? extends String> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.backingMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.backingMap.containsValue(value);
    }

    @Override
    public Set<String> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<String> values() {
        if (this.valueCollection == null) {
            this.valueCollection = new ValueCollection();
        }
        return this.valueCollection;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + this.backingMap.hashCode();
        result = 31 * result + this.configMap.hashCode();
        result = 31 * result + this.desc.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Configuration other = (Configuration)obj;
        if (!this.backingMap.equals(other.backingMap)) {
            return false;
        }
        if (!this.configMap.equals(other.configMap)) {
            return false;
        }
        return this.desc.equals(other.desc);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ConfigMap
    extends HashMap<String, IConfiguration> {
        private static final long serialVersionUID = 1L;

        protected ConfigMap() {
        }

        protected ConfigMap(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        public IConfiguration put(String key, IConfiguration config) {
            if (config == null) {
                return (IConfiguration)this.remove(key);
            }
            IPropertyDescriptor pDesc = (IPropertyDescriptor)Configuration.this.desc.get(key);
            if (pDesc != null) {
                if (!pDesc.isConfigurableProperty()) {
                    return null;
                }
                if (!pDesc.isValid(config.getID())) {
                    return null;
                }
            }
            Configuration.this.internalPut(key, config.getID());
            return this.internalPut(key, config);
        }

        protected IConfiguration internalPut(String key, IConfiguration config) {
            return super.put(key, config);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class EntrySet
    extends AbstractSet<Map.Entry<String, String>> {
        protected EntrySet() {
        }

        @Override
        public int size() {
            return Configuration.this.backingMap.size();
        }

        @Override
        public Iterator<Map.Entry<String, String>> iterator() {
            return new EntryIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class EntryIterator
        extends ViewIterator<Map.Entry<String, String>> {
            protected EntryIterator() {
            }

            @Override
            protected Map.Entry<String, String> getNext(Map.Entry<String, String> entry) {
                return new ProtectedEntry(entry);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class KeySet
    extends AbstractSet<String> {
        protected KeySet() {
        }

        @Override
        public int size() {
            return Configuration.this.backingMap.size();
        }

        @Override
        public Iterator<String> iterator() {
            return new KeyIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class KeyIterator
        implements Iterator<String> {
            private Iterator<Map.Entry<String, String>> backingItr;
            private Map.Entry<String, String> last;

            protected KeyIterator() {
                this.backingItr = Configuration.this.backingMap.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.backingItr.hasNext();
            }

            @Override
            public String next() {
                this.last = this.backingItr.next();
                return this.last.getKey();
            }

            @Override
            public void remove() {
                IPropertyDescriptor pDesc = (IPropertyDescriptor)Configuration.this.desc.get(this.last.getKey());
                this.last.setValue(pDesc.getDefaultValue());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ProtectedEntry
    implements Map.Entry<String, String> {
        private Map.Entry<String, String> backing;

        public ProtectedEntry(Map.Entry<String, String> backing) {
            if (backing == null) {
                throw new NullPointerException();
            }
            this.backing = backing;
        }

        @Override
        public String getKey() {
            return this.backing.getKey();
        }

        @Override
        public String getValue() {
            return this.backing.getValue();
        }

        @Override
        public String setValue(String value) {
            return Configuration.this.resetValue(this.backing);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ValueCollection
    extends AbstractCollection<String> {
        protected ValueCollection() {
        }

        @Override
        public int size() {
            return Configuration.this.backingMap.size();
        }

        @Override
        public Iterator<String> iterator() {
            return new ValueIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class ValueIterator
        extends ViewIterator<String> {
            protected ValueIterator() {
            }

            @Override
            protected String getNext(Map.Entry<String, String> entry) {
                return entry.getValue();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class ViewIterator<E>
    implements Iterator<E> {
        private Iterator<Map.Entry<String, String>> backingItr;
        private Map.Entry<String, String> last;

        protected ViewIterator() {
            this.backingItr = Configuration.this.backingMap.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.backingItr.hasNext();
        }

        @Override
        public E next() {
            this.last = this.backingItr.next();
            return this.getNext(this.last);
        }

        protected abstract E getNext(Map.Entry<String, String> var1);

        @Override
        public void remove() {
            Configuration.this.resetValue(this.last);
        }
    }
}

