/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.manager;

import edu.mit.story.core.descriptor.IDescriptor;
import edu.mit.story.core.manager.IManager;
import edu.mit.story.core.util.EntriesValueListView;
import edu.mit.story.core.util.UninitializedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractManager<D extends IDescriptor>
implements IManager<D> {
    private Object initSync = new Object();
    private boolean isInitialized = false;
    protected List<D> descriptorList;
    protected Map<String, D> idMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        Object object = this.initSync;
        synchronized (object) {
            if (this.isInitialized) {
                return;
            }
            this.idMap = this.createIDMap();
            this.isInitialized = this.doInit();
            if (!this.isInitialized) {
                this.idMap = null;
            }
        }
    }

    protected Map<String, D> createIDMap() {
        return new TreeMap();
    }

    protected abstract boolean doInit();

    protected void checkInit() {
        if (!this.isInitialized()) {
            throw new UninitializedException();
        }
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public D getDescriptor(String id) {
        this.checkInit();
        return (D)((IDescriptor)this.idMap.get(id));
    }

    @Override
    public List<D> getDescriptors() {
        this.checkInit();
        if (this.descriptorList == null) {
            this.descriptorList = Collections.unmodifiableList(new EntriesValueListView<D>(this.idMap.entrySet()));
        }
        return this.descriptorList;
    }

    protected boolean registerDescriptor(D desc) {
        if (desc == null) {
            return false;
        }
        this.idMap.put(desc.getID(), desc);
        return true;
    }

    public static List<IConfigurationElement> getElements(String extensionPoint) {
        ArrayList<IConfigurationElement> result = new ArrayList<IConfigurationElement>();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(extensionPoint);
        if (point == null) {
            return result;
        }
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            result.addAll(Arrays.asList(extension.getConfigurationElements()));
            ++n2;
        }
        return result;
    }

    public static List<IConfigurationElement> getElements(String extensionPoint, String name) {
        ArrayList<IConfigurationElement> result = new ArrayList<IConfigurationElement>();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(extensionPoint);
        if (point == null) {
            return result;
        }
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getName().equals(name)) {
                    result.add(element);
                }
                ++n4;
            }
            ++n2;
        }
        return result;
    }
}

