/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.agreement.rand;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import edu.mit.story.core.agreement.rand.IContingencyTable;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContingencyTable
implements IContingencyTable {
    private final int size;
    private final int[][] values;
    private final int[] rowSums;
    private final int[] colSums;
    private final int sum;

    public <T> ContingencyTable(Set<? extends Set<T>> rowSets, Set<? extends Set<T>> colSets) {
        int numRows = rowSets.size();
        int numCols = colSets.size();
        int[][] values = new int[numRows][numCols];
        int[] rowSums = new int[numRows];
        int[] colSums = new int[numCols];
        int sum = 0;
        int rowIdx = -1;
        for (Set<T> rowSet : rowSets) {
            ++rowIdx;
            int colIdx = -1;
            for (Set<T> colSet : colSets) {
                int val;
                values[rowIdx][++colIdx] = val = Sets.intersection(rowSet, colSet).size();
                int n = rowIdx;
                rowSums[n] = rowSums[n] + val;
                int n2 = colIdx;
                colSums[n2] = colSums[n2] + val;
                sum += val;
            }
        }
        this.size = numRows * numCols;
        this.values = values;
        this.rowSums = rowSums;
        this.colSums = colSums;
        this.sum = sum;
    }

    @Override
    public int get(int rowIdx, int colIdx) {
        return this.values[rowIdx][colIdx];
    }

    @Override
    public int getRowSum(int rowIdx) {
        return this.rowSums[rowIdx];
    }

    @Override
    public int getColumnSum(int colIdx) {
        return this.colSums[colIdx];
    }

    @Override
    public int getSum() {
        return this.sum;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int numRows() {
        return this.rowSums.length;
    }

    @Override
    public int numColumns() {
        return this.colSums.length;
    }

    @Override
    public int[] row(int rowIdx) {
        int[] row = this.values[rowIdx];
        int[] copy = new int[row.length];
        System.arraycopy(row, 0, copy, 0, row.length);
        return copy;
    }

    @Override
    public int[] column(int colIdx) {
        int numRows = this.numRows();
        int[] col = new int[numRows];
        int rowIdx = 0;
        while (rowIdx < numRows) {
            col[rowIdx] = this.values[rowIdx][colIdx];
            ++rowIdx;
        }
        return col;
    }

    public String toString() {
        return ContingencyTable.toString(this);
    }

    public static String toString(IContingencyTable table) {
        String entryStr;
        int cIdx;
        String[][] entries = new String[table.numRows()][table.numColumns()];
        String[] rowSums = new String[table.numRows()];
        String[] colSums = new String[table.numColumns()];
        int entryWidth = 0;
        int rIdx = 0;
        while (rIdx < table.numRows()) {
            cIdx = 0;
            while (cIdx < table.numColumns()) {
                entries[rIdx][cIdx] = entryStr = Integer.toString(table.get(rIdx, cIdx));
                entryWidth = Math.max(entryWidth, entryStr.length());
                ++cIdx;
            }
            ++rIdx;
        }
        rIdx = 0;
        while (rIdx < rowSums.length) {
            rowSums[rIdx] = entryStr = Integer.toString(table.getRowSum(rIdx));
            entryWidth = Math.max(entryWidth, entryStr.length());
            ++rIdx;
        }
        int cIdx2 = 0;
        while (cIdx2 < colSums.length) {
            colSums[cIdx2] = entryStr = Integer.toString(table.getColumnSum(cIdx2));
            entryWidth = Math.max(entryWidth, entryStr.length());
            ++cIdx2;
        }
        String total = Integer.toString(table.getSum());
        entryWidth = Math.max(entryWidth, total.length());
        rIdx = 0;
        while (rIdx < entries.length) {
            cIdx = 0;
            while (cIdx < entries[rIdx].length) {
                entries[rIdx][cIdx] = Strings.padStart((String)entries[rIdx][cIdx], (int)entryWidth, (char)' ');
                ++cIdx;
            }
            ++rIdx;
        }
        rIdx = 0;
        while (rIdx < rowSums.length) {
            rowSums[rIdx] = Strings.padStart((String)rowSums[rIdx], (int)entryWidth, (char)' ');
            ++rIdx;
        }
        cIdx2 = 0;
        while (cIdx2 < colSums.length) {
            colSums[cIdx2] = Strings.padStart((String)colSums[cIdx2], (int)entryWidth, (char)' ');
            ++cIdx2;
        }
        int colIdxWidth = Integer.toString(table.numColumns() - 1).length();
        StringBuilder sb = new StringBuilder();
        StringBuilder div = new StringBuilder();
        String afterIdx = "| ";
        int i = 0;
        while (i < colIdxWidth) {
            sb.append(' ');
            div.append('-');
            ++i;
        }
        sb.append(afterIdx);
        div.append("+-");
        int len = sb.length();
        int cIdx3 = 0;
        while (cIdx3 < table.numColumns()) {
            sb.append(Strings.padStart((String)Integer.toString(cIdx3), (int)entryWidth, (char)' ')).append(' ');
            ++cIdx3;
        }
        sb.append("| ");
        sb.append(Strings.repeat((String)" ", (int)entryWidth));
        while (len < sb.length()) {
            div.append('-');
            ++len;
        }
        sb.append('\n');
        sb.append((CharSequence)div);
        int rIdx2 = 0;
        while (rIdx2 < rowSums.length) {
            sb.append('\n');
            sb.append(Strings.padStart((String)Integer.toString(rIdx2), (int)colIdxWidth, (char)' '));
            sb.append(afterIdx);
            int cIdx4 = 0;
            while (cIdx4 < table.numColumns()) {
                sb.append(entries[rIdx2][cIdx4]).append(' ');
                ++cIdx4;
            }
            sb.append('|');
            sb.append(rowSums[rIdx2]);
            ++rIdx2;
        }
        sb.append('\n');
        sb.append((CharSequence)div);
        sb.append('\n');
        sb.append(Strings.repeat((String)" ", (int)colIdxWidth));
        sb.append(afterIdx);
        cIdx3 = 0;
        while (cIdx3 < colSums.length) {
            sb.append(colSums[cIdx3]).append(' ');
            ++cIdx3;
        }
        sb.append('|');
        sb.append(Strings.padStart((String)total, (int)entryWidth, (char)' '));
        return sb.toString();
    }
}

