/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.core.rep.sense.algorithm;

import edu.mit.jwi.item.IIndexWord;
import edu.mit.jwi.item.IWord;
import edu.mit.jwi.item.IWordID;
import edu.mit.jwi.item.POS;
import edu.mit.parsing.core.rep.pos.IPosData;
import edu.mit.parsing.core.util.IBaseWordInfo;
import edu.mit.wordnet.core.WordnetUtils;
import edu.mit.wordnet.core.rep.sense.ISenseAssignment;
import edu.mit.wordnet.core.rep.sense.SenseAssignment;
import edu.mit.wordnet.core.rep.sense.algorithm.AbstractSenseTagger;
import edu.mit.wordnet.core.rep.sense.dict.IExtendedDictionary;
import edu.mit.wordnet.core.rep.sense.evidence.MonosemousEvidence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlatSenseTagger
extends AbstractSenseTagger {
    @Override
    public List<ISenseAssignment> doTag(IBaseWordInfo word) {
        IPosData posTag = word.getPosTag();
        if (posTag == null) {
            return Collections.emptyList();
        }
        POS pos = WordnetUtils.convertToPOS(posTag.getTag());
        if (pos == null) {
            return Collections.emptyList();
        }
        IExtendedDictionary dict = this.getDictionary();
        IIndexWord idxWord = dict.getIndexWord(word.getBaseForm(), pos);
        if (idxWord == null) {
            return Collections.emptyList();
        }
        if (idxWord.getWordIDs().size() == 1) {
            IWord sense = dict.getWord((IWordID)idxWord.getWordIDs().get(0));
            if (sense == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(new SenseAssignment(sense, MonosemousEvidence.getInstance()));
        }
        ArrayList<ISenseAssignment> result = new ArrayList<ISenseAssignment>(idxWord.getWordIDs().size());
        for (IWordID wordID : idxWord.getWordIDs()) {
            IWord sense = dict.getWord(wordID);
            if (sense == null) continue;
            result.add(new SenseAssignment(sense, null));
        }
        return result;
    }
}

